/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.food.ItemConserve;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PedestalRecipes
extends SerializableRecipe {
    public static List<PedestalRecipe> recipes = new ArrayList<PedestalRecipe>();
    public static ArrayList<PedestalRecipe>[] recipeSets = new ArrayList[2];

    @Override
    public void registerDefaults() {
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_light_revolver_dani), null, new RecipesCommon.OreDictStack(OreDictManager.PB.plate()), null, new RecipesCommon.OreDictStack(OreDictManager.GOLD.plate()), new RecipesCommon.ComparableStack(ModItems.gun_light_revolver), new RecipesCommon.OreDictStack(OreDictManager.GOLD.plate()), null, new RecipesCommon.OreDictStack(OreDictManager.PB.plate()), null).extra(PedestalExtraCondition.NEW_MOON));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_maresleg_broken), new RecipesCommon.ComparableStack(ModBlocks.barbed_wire), new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.plate()), new RecipesCommon.ComparableStack(ModBlocks.barbed_wire), new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.plate()), new RecipesCommon.ComparableStack(ModItems.gun_maresleg), new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.plate()), new RecipesCommon.ComparableStack(ModBlocks.barbed_wire), new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.plate()), new RecipesCommon.ComparableStack(ModBlocks.barbed_wire)));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_heavy_revolver_lilmac), null, new RecipesCommon.ComparableStack(ModItems.weapon_mod_special, 1, (Enum)GunFactory.EnumModSpecial.SCOPE), null, new RecipesCommon.ComparableStack(ModItems.powder_magic), new RecipesCommon.ComparableStack(ModItems.gun_heavy_revolver), new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.plate()), null, new RecipesCommon.OreDictStack(OreDictManager.BONE.grip()), new RecipesCommon.ComparableStack(Items.field_151034_e, 3)));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_heavy_revolver_protege), new RecipesCommon.ComparableStack(ModBlocks.chain, 16), new RecipesCommon.OreDictStack(OreDictManager.CINNABAR.gem()), new RecipesCommon.ComparableStack(ModBlocks.chain, 16), new RecipesCommon.ComparableStack(ModItems.scrap_nuclear), new RecipesCommon.ComparableStack(ModItems.gun_heavy_revolver), new RecipesCommon.ComparableStack(ModItems.scrap_nuclear), new RecipesCommon.ComparableStack(ModBlocks.chain, 16), new RecipesCommon.OreDictStack(OreDictManager.CINNABAR.gem()), new RecipesCommon.ComparableStack(ModBlocks.chain, 16)));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_amat_subtlety), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot()), new RecipesCommon.OreDictStack(OreDictManager.AL.plateCast()), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot()), new RecipesCommon.OreDictStack(OreDictManager.AL.plateCast()), new RecipesCommon.ComparableStack(ModItems.gun_amat), new RecipesCommon.OreDictStack(OreDictManager.AL.plateCast()), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot()), new RecipesCommon.OreDictStack(OreDictManager.AL.plateCast()), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot())));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_amat_penance), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot()), new RecipesCommon.OreDictStack(OreDictManager.DURA.plateCast()), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot()), new RecipesCommon.ComparableStack(ModItems.weapon_mod_special, 1, (Enum)GunFactory.EnumModSpecial.SILENCER), new RecipesCommon.ComparableStack(ModItems.gun_amat), new RecipesCommon.ComparableStack(ModItems.weapon_mod_special, 1, (Enum)GunFactory.EnumModSpecial.FURNITURE_BLACK), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot()), new RecipesCommon.OreDictStack(OreDictManager.DURA.plateCast()), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot())));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_flamer_daybreaker), new RecipesCommon.OreDictStack(OreDictManager.GOLD.plateCast()), new RecipesCommon.ComparableStack((Item)ModItems.canned_conserve, 1, (Enum)ItemConserve.EnumFoodType.SLIME), new RecipesCommon.OreDictStack(OreDictManager.GOLD.plateCast()), new RecipesCommon.OreDictStack(OreDictManager.P_WHITE.ingot()), new RecipesCommon.ComparableStack(ModItems.gun_flamer), new RecipesCommon.OreDictStack(OreDictManager.P_WHITE.ingot()), new RecipesCommon.OreDictStack(OreDictManager.GOLD.plateCast()), new RecipesCommon.ComparableStack(ModItems.stick_dynamite), new RecipesCommon.OreDictStack(OreDictManager.GOLD.plateCast())).extra(PedestalExtraCondition.SUN));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_autoshotgun_sexy), new RecipesCommon.ComparableStack(ModItems.bolt_spike, 16), new RecipesCommon.ComparableStack(ModItems.wild_p), new RecipesCommon.ComparableStack(ModItems.bolt_spike, 16), new RecipesCommon.ComparableStack(ModItems.card_qos), new RecipesCommon.ComparableStack(ModItems.gun_autoshotgun), new RecipesCommon.ComparableStack(ModItems.card_aos), new RecipesCommon.ComparableStack(ModItems.bolt_spike, 16), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.bolt_spike, 16)));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_minigun_lacunae), null, new RecipesCommon.ComparableStack(ModItems.powder_magic, 4), null, new RecipesCommon.ComparableStack(ModItems.item_secret, 4, (Enum)ItemEnums.EnumSecretType.SELENIUM_STEEL), new RecipesCommon.ComparableStack(ModItems.gun_minigun), new RecipesCommon.ComparableStack(ModItems.item_secret, 4, (Enum)ItemEnums.EnumSecretType.SELENIUM_STEEL), null, new RecipesCommon.ComparableStack(ModItems.powder_magic, 4), null).extra(PedestalExtraCondition.FULL_MOON));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_laser_pistol_morning_glory), null, new RecipesCommon.ComparableStack(ModItems.morning_glory, 1), null, new RecipesCommon.ComparableStack(ModItems.item_secret, 2, (Enum)ItemEnums.EnumSecretType.SELENIUM_STEEL), new RecipesCommon.ComparableStack(ModItems.gun_laser_pistol), new RecipesCommon.ComparableStack(ModItems.item_secret, 2, (Enum)ItemEnums.EnumSecretType.SELENIUM_STEEL), null, new RecipesCommon.OreDictStack(OreDictManager.EMERALD.gem(), 16), null));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_folly), new RecipesCommon.ComparableStack(ModItems.item_secret, 4, (Enum)ItemEnums.EnumSecretType.FOLLY), new RecipesCommon.ComparableStack(ModItems.item_secret, 2, (Enum)ItemEnums.EnumSecretType.CONTROLLER), new RecipesCommon.ComparableStack(ModItems.item_secret, 4, (Enum)ItemEnums.EnumSecretType.FOLLY), new RecipesCommon.OreDictStack(OreDictManager.BSCCO.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.STAR.block(), 64), new RecipesCommon.OreDictStack(OreDictManager.BSCCO.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.item_secret, 4, (Enum)ItemEnums.EnumSecretType.FOLLY), new RecipesCommon.ComparableStack(ModItems.item_secret, 2, (Enum)ItemEnums.EnumSecretType.CONTROLLER), new RecipesCommon.ComparableStack(ModItems.item_secret, 4, (Enum)ItemEnums.EnumSecretType.FOLLY)).extra(PedestalExtraCondition.FULL_MOON).set(1));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_aberrator), null, new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), null, new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.mechanism(), 4), new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), null, new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), null).set(1));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.gun_aberrator_eott), new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.mechanism(), 16), new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR)).extra(PedestalExtraCondition.GOOD_KARMA).set(1));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.ammo_secret, 1, GunFactory.EnumAmmoSecret.FOLLY_SM.ordinal()), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.powder_magic), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.powder_magic), new RecipesCommon.ComparableStack(ModItems.chunk_ore, 1, (Enum)ItemEnums.EnumChunkType.MOONSTONE), new RecipesCommon.ComparableStack(ModItems.powder_magic), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.powder_magic), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1)).extra(PedestalExtraCondition.FULL_MOON).set(1));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.ammo_secret, 1, GunFactory.EnumAmmoSecret.FOLLY_NUKE.ordinal()), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.powder_magic), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.powder_magic), new RecipesCommon.ComparableStack(ModItems.ammo_standard, 4, (Enum)GunFactory.EnumAmmo.NUKE_HIGH), new RecipesCommon.ComparableStack(ModItems.powder_magic), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.powder_magic), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1)).extra(PedestalExtraCondition.FULL_MOON).set(1));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.ammo_secret, 5, GunFactory.EnumAmmoSecret.P35_800.ordinal()), null, null, null, null, new RecipesCommon.ComparableStack(ModItems.item_secret, 1, (Enum)ItemEnums.EnumSecretType.ABERRATOR), null, null, null, null).set(1));
        PedestalRecipes.register(new PedestalRecipe(new ItemStack(ModItems.ammo_secret, 10, GunFactory.EnumAmmoSecret.P35_800_BL.ordinal()), null, null, null, null, new RecipesCommon.ComparableStack(ModItems.item_secret, 3, (Enum)ItemEnums.EnumSecretType.ABERRATOR), null, null, null, null).set(1));
    }

    public static void register(PedestalRecipe recipe) {
        recipes.add(recipe);
        int set = Math.abs(recipe.recipeSet) % recipeSets.length;
        recipeSets[set].add(recipe);
    }

    @Override
    public String getFileName() {
        return "hbmPedestal.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
        for (int i = 0; i < recipeSets.length; ++i) {
            recipeSets[i].clear();
        }
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        ItemStack output = PedestalRecipes.readItemStack(obj.get("output").getAsJsonArray());
        JsonArray inputArray = obj.get("input").getAsJsonArray();
        RecipesCommon.AStack[] input = new RecipesCommon.AStack[9];
        for (int i = 0; i < 9; ++i) {
            JsonElement element = inputArray.get(i);
            if (element.isJsonNull()) {
                input[i] = null;
                continue;
            }
            input[i] = PedestalRecipes.readAStack(element.getAsJsonArray());
        }
        PedestalRecipe rec = new PedestalRecipe(output, input);
        if (obj.has("extra")) {
            rec.extra = PedestalExtraCondition.valueOf(obj.get("extra").getAsString());
        }
        if (obj.has("set")) {
            rec.recipeSet = obj.get("set").getAsInt();
        }
        PedestalRecipes.register(rec);
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        PedestalRecipe rec = (PedestalRecipe)recipe;
        writer.name("output");
        PedestalRecipes.writeItemStack(rec.output, writer);
        writer.name("input").beginArray();
        for (int i = 0; i < rec.input.length; ++i) {
            if (rec.input[i] == null) {
                writer.nullValue();
                continue;
            }
            PedestalRecipes.writeAStack(rec.input[i], writer);
        }
        writer.endArray();
        writer.name("extra").value(rec.extra.name());
        if (rec.recipeSet != 0) {
            writer.name("set").value((long)rec.recipeSet);
        }
    }

    static {
        for (int i = 0; i < recipeSets.length; ++i) {
            PedestalRecipes.recipeSets[i] = new ArrayList();
        }
    }

    public static class PedestalRecipe {
        public ItemStack output;
        public RecipesCommon.AStack[] input;
        public int recipeSet = 0;
        public PedestalExtraCondition extra = PedestalExtraCondition.NONE;

        public PedestalRecipe(ItemStack output, RecipesCommon.AStack ... input) {
            this.output = output;
            this.input = input;
        }

        public PedestalRecipe extra(PedestalExtraCondition extra) {
            this.extra = extra;
            return this;
        }

        public PedestalRecipe set(int set) {
            this.recipeSet = set;
            return this;
        }
    }

    public static enum PedestalExtraCondition {
        NONE,
        FULL_MOON,
        NEW_MOON,
        SUN,
        GOOD_KARMA,
        BAD_KARMA;

    }
}

