/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.items.special.ItemBedrockOreNew;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CombinationRecipes
extends SerializableRecipe {
    public static HashMap<Object, Tuple.Pair<ItemStack, FluidStack>> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        recipes.put(OreDictManager.COAL.gem(), new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.COAL), new FluidStack(Fluids.COALCREOSOTE, 100)));
        recipes.put(OreDictManager.COAL.dust(), new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.COAL), new FluidStack(Fluids.COALCREOSOTE, 100)));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.briquette, (Enum)ItemEnums.EnumBriquetteType.COAL)), new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.COAL), new FluidStack(Fluids.COALCREOSOTE, 150)));
        recipes.put(OreDictManager.LIGNITE.gem(), new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.LIGNITE), new FluidStack(Fluids.COALCREOSOTE, 50)));
        recipes.put(OreDictManager.LIGNITE.dust(), new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.LIGNITE), new FluidStack(Fluids.COALCREOSOTE, 50)));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.briquette, (Enum)ItemEnums.EnumBriquetteType.LIGNITE)), new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.LIGNITE), new FluidStack(Fluids.COALCREOSOTE, 100)));
        recipes.put(OreDictManager.CHLOROCALCITE.dust(), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(ModItems.powder_calcium), new FluidStack(Fluids.CHLORINE, 250)));
        recipes.put(OreDictManager.MOLYSITE.dust(), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(Items.field_151042_j), new FluidStack(Fluids.CHLORINE, 250)));
        recipes.put(OreDictManager.CINNABAR.crystal(), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(ModItems.sulfur), new FluidStack(Fluids.MERCURY, 100)));
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151114_aO), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(ModItems.sulfur), new FluidStack(Fluids.CHLORINE, 100)));
        recipes.put(OreDictManager.SODALITE.gem(), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(ModItems.powder_sodium), new FluidStack(Fluids.CHLORINE, 100)));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.chunk_ore, (Enum)ItemEnums.EnumChunkType.CRYOLITE)), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(ModItems.powder_aluminium, 1), new FluidStack(Fluids.LYE, 150)));
        recipes.put(OreDictManager.NA.dust(), new Tuple.Pair<Object, FluidStack>(null, new FluidStack(Fluids.SODIUM, 100)));
        recipes.put(OreDictManager.LIMESTONE.dust(), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(ModItems.powder_calcium), new FluidStack(Fluids.CARBONDIOXIDE, 50)));
        recipes.put("logWood", new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(Items.field_151044_h, 1, 1), new FluidStack(Fluids.WOODOIL, 250)));
        recipes.put("treeSapling", new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.powder_ash, (Enum)ItemEnums.EnumAshType.WOOD), new FluidStack(Fluids.WOODOIL, 50)));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.briquette, (Enum)ItemEnums.EnumBriquetteType.WOOD)), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(Items.field_151044_h, 1, 1), new FluidStack(Fluids.WOODOIL, 500)));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE)), new Tuple.Pair<ItemStack, Object>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.PETROLEUM), null));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRACK)), new Tuple.Pair<ItemStack, Object>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.PETROLEUM), null));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.COAL)), new Tuple.Pair<ItemStack, Object>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.COAL), null));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.WOOD)), new Tuple.Pair<ItemStack, Object>(OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.COAL), null));
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151120_aE), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(Items.field_151102_aT, 2), new FluidStack(Fluids.ETHANOL, 50)));
        recipes.put(new RecipesCommon.ComparableStack(Blocks.field_150435_aG), new Tuple.Pair<ItemStack, Object>(new ItemStack(Blocks.field_150336_V, 1), null));
        for (ItemBedrockOreNew.CelestialBedrockOreType type : ItemBedrockOreNew.CelestialBedrockOre.getAllTypes()) {
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE, type)), new Tuple.Pair<ItemStack, FluidStack>(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE_ROASTED, type), new FluidStack(Fluids.VITRIOL, 50)));
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type)), new Tuple.Pair<ItemStack, FluidStack>(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_ROASTED, type), new FluidStack(Fluids.VITRIOL, 50)));
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_BYPRODUCT, type)), new Tuple.Pair<ItemStack, FluidStack>(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_ROASTED, type), new FluidStack(Fluids.VITRIOL, 50)));
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_BYPRODUCT, type)), new Tuple.Pair<ItemStack, FluidStack>(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_ROASTED, type), new FluidStack(Fluids.VITRIOL, 50)));
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_BYPRODUCT, type)), new Tuple.Pair<ItemStack, FluidStack>(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_ROASTED, type), new FluidStack(Fluids.VITRIOL, 50)));
        }
    }

    public static Tuple.Pair<ItemStack, FluidStack> getOutput(ItemStack stack) {
        String[] dictKeys;
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack.func_77973_b(), 1, stack.func_77960_j());
        if (recipes.containsKey(comp)) {
            Tuple.Pair<ItemStack, FluidStack> out = recipes.get(comp);
            return new Tuple.Pair<ItemStack, FluidStack>(out.getKey() == null ? null : out.getKey().func_77946_l(), out.getValue());
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            if (!recipes.containsKey(key)) continue;
            Tuple.Pair<ItemStack, FluidStack> out = recipes.get(key);
            return new Tuple.Pair<ItemStack, FluidStack>(out.getKey() == null ? null : out.getKey().func_77946_l(), out.getValue());
        }
        return null;
    }

    public static HashMap getRecipes() {
        HashMap<Object, ItemStack[]> recipes = new HashMap<Object, ItemStack[]>();
        for (Map.Entry<Object, Tuple.Pair<ItemStack, FluidStack>> entry : CombinationRecipes.recipes.entrySet()) {
            Object o;
            Object key = entry.getKey();
            Tuple.Pair<ItemStack, FluidStack> val = entry.getValue();
            Object object = o = key instanceof String ? new RecipesCommon.OreDictStack((String)key) : key;
            if (val.getKey() != null && val.getValue() != null) {
                recipes.put(o, new ItemStack[]{val.getKey(), ItemFluidIcon.make(val.getValue())});
                continue;
            }
            if (val.getKey() != null) {
                recipes.put(o, new ItemStack[]{val.getKey()});
                continue;
            }
            if (val.getValue() == null) continue;
            recipes.put(o, new ItemStack[]{ItemFluidIcon.make(val.getValue())});
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmCombination.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack in = CombinationRecipes.readAStack(obj.get("input").getAsJsonArray());
        FluidStack fluid = null;
        ItemStack out = null;
        if (obj.has("fluid")) {
            fluid = CombinationRecipes.readFluidStack(obj.get("fluid").getAsJsonArray());
        }
        if (obj.has("output")) {
            out = CombinationRecipes.readItemStack(obj.get("output").getAsJsonArray());
        }
        if (in instanceof RecipesCommon.ComparableStack) {
            recipes.put(((RecipesCommon.ComparableStack)in).makeSingular(), new Tuple.Pair<ItemStack, FluidStack>(out, fluid));
        } else if (in instanceof RecipesCommon.OreDictStack) {
            recipes.put(((RecipesCommon.OreDictStack)in).name, new Tuple.Pair<ItemStack, FluidStack>(out, fluid));
        }
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        Object in = rec.getKey();
        Tuple.Pair Pair2 = (Tuple.Pair)rec.getValue();
        ItemStack output = (ItemStack)Pair2.key;
        FluidStack fluid = (FluidStack)Pair2.value;
        writer.name("input");
        if (in instanceof String) {
            CombinationRecipes.writeAStack(new RecipesCommon.OreDictStack((String)in), writer);
        } else if (in instanceof RecipesCommon.ComparableStack) {
            CombinationRecipes.writeAStack((RecipesCommon.ComparableStack)in, writer);
        }
        if (output != null) {
            writer.name("output");
            CombinationRecipes.writeItemStack(output, writer);
        }
        if (fluid != null) {
            writer.name("fluid");
            CombinationRecipes.writeFluidStack(fluid, writer);
        }
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }
}

