/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityFish
extends EntityWaterMob {
    private Vec3 currentSwimTarget;

    public EntityFish(World world, double swimSpeed, float watchDistance) {
        super(world);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, watchDistance));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, swimSpeed));
        this.currentSwimTarget = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        this.func_70105_a(2.0f, 2.0f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(10.0);
    }

    protected void func_70665_d(DamageSource source, float amount) {
        super.func_70665_d(source, amount);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.func_70090_H()) {
            this.field_70125_A += 0.2f;
            this.field_70177_z = 0.0f;
            this.func_70637_d(true);
            if (this.field_70122_E) {
                this.func_70024_g(0.4 * this.field_70146_Z.nextDouble() - 0.4 * this.field_70146_Z.nextDouble(), 0.0, 0.4 * this.field_70146_Z.nextDouble() - 0.4 * this.field_70146_Z.nextDouble());
            }
        }
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.updateSwimTarget();
        this.moveTowardsTarget();
        this.updateRotation();
    }

    private void updateSwimTarget() {
        if (this.field_70146_Z.nextInt(200) == 0 || !this.func_70090_H()) {
            double targetX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 20.0;
            double targetY = MathHelper.func_151237_a((double)(this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * 8.0), (double)0.0, (double)(this.field_70170_p.func_72800_K() - 1));
            double targetZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 20.0;
            this.currentSwimTarget = Vec3.func_72443_a((double)targetX, (double)targetY, (double)targetZ);
        }
    }

    private void moveTowardsTarget() {
        double deltaX = this.currentSwimTarget.field_72450_a - this.field_70165_t;
        double deltaY = this.currentSwimTarget.field_72448_b - this.field_70163_u;
        double deltaZ = this.currentSwimTarget.field_72449_c - this.field_70161_v;
        double distance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        double dirX = deltaX / distance;
        double dirY = deltaY / distance;
        double dirZ = deltaZ / distance;
        double speed = 0.01;
        this.field_70159_w += dirX * speed + (this.field_70146_Z.nextDouble() - 0.5) * 0.02;
        this.field_70181_x += dirY * speed + (this.field_70146_Z.nextDouble() - 0.5) * 0.02;
        this.field_70179_y += dirZ * speed + (this.field_70146_Z.nextDouble() - 0.5) * 0.02;
        this.updateRotation((float)dirX, (float)dirY, (float)dirZ);
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70090_H()) {
            this.field_70181_x *= (double)0.8f;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70722_aY = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f6 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            this.field_70721_aZ += (f6 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    private void updateRotation() {
        double deltaX = this.field_70159_w;
        double deltaZ = this.field_70179_y;
        double deltaY = this.field_70181_x;
        float targetYaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 90.0f;
        float targetPitch = (float)(-(Math.atan2(deltaY, Math.sqrt(deltaX * deltaX + deltaZ * deltaZ)) * 57.29577951308232));
        this.field_70177_z = this.updateRotation(this.field_70177_z, targetYaw, 10.0f);
        this.field_70125_A = this.updateRotation(this.field_70125_A, targetPitch, 10.0f);
    }

    private float updateRotation(float currentRotation, float targetRotation, float maxIncrement) {
        float deltaRotation = MathHelper.func_76142_g((float)(targetRotation - currentRotation));
        if (deltaRotation > maxIncrement) {
            deltaRotation = maxIncrement;
        }
        if (deltaRotation < -maxIncrement) {
            deltaRotation = -maxIncrement;
        }
        return currentRotation + deltaRotation;
    }
}

