/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.trait;

import com.hbm.dim.trait.CelestialBodyTrait;
import com.hbm.entity.mob.siege.EntitySiegeCraft;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class CBT_Invasion
extends CelestialBodyTrait {
    public int wave;
    public int kills;
    public double waveTime;
    public boolean isInvading;
    public int lastSpawns;
    public int spawndelay;

    public CBT_Invasion() {
    }

    public CBT_Invasion(int wave, double waveTime, boolean isInvading) {
        this.wave = wave;
        this.waveTime = waveTime;
        this.isInvading = isInvading;
    }

    public void prepare() {
        if (!this.isInvading && this.waveTime > 100.0) {
            this.waveTime -= 1.0;
            if (this.waveTime <= 0.0) {
                this.isInvading = true;
            }
        }
    }

    public void invade(int killReq, double wavetimerbase) {
        if (!this.isInvading) {
            return;
        }
        this.waveTime -= 1.0;
        if (this.waveTime <= 0.0) {
            ++this.wave;
            this.waveTime = wavetimerbase;
        }
    }

    public void spawn() {
        if (this.lastSpawns > 10) {
            return;
        }
        switch (this.wave) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    public static void spawnAttempt(World world) {
        if (world.func_82737_E() % 60L == 0L && !world.field_73010_i.isEmpty()) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            player.func_146105_b(new ChatComponentText("Incoming!").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            double spawnX = player.field_70165_t + world.field_73012_v.nextGaussian() * 20.0;
            double spawnZ = player.field_70161_v + world.field_73012_v.nextGaussian() * 20.0;
            double spawnY = world.func_72976_f((int)spawnX, (int)spawnZ);
            EntitySiegeCraft invaderCraft = new EntitySiegeCraft(world);
            invaderCraft.func_70012_b(spawnX, spawnY, spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)invaderCraft);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("wave", this.wave);
        nbt.func_74768_a("kills", this.kills);
        nbt.func_74780_a("waveTime", this.waveTime);
        nbt.func_74757_a("isInvading", this.isInvading);
        nbt.func_74768_a("lastSpawns", this.lastSpawns);
        nbt.func_74768_a("spawnDelay", this.spawndelay);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.wave = nbt.func_74762_e("wave");
        this.kills = nbt.func_74762_e("kills");
        this.isInvading = nbt.func_74767_n("isInvading");
        this.waveTime = nbt.func_74769_h("waveTime");
        this.lastSpawns = nbt.func_74762_e("lastSpawns");
        this.spawndelay = nbt.func_74762_e("spawnDelay");
    }

    @Override
    public void writeToBytes(ByteBuf buf) {
        buf.writeInt(this.kills);
        buf.writeInt(this.wave);
        buf.writeDouble(this.waveTime);
        buf.writeBoolean(this.isInvading);
        buf.writeInt(this.lastSpawns);
        buf.writeInt(this.spawndelay);
    }

    @Override
    public void readFromBytes(ByteBuf buf) {
        this.kills = buf.readInt();
        this.wave = buf.readInt();
        this.waveTime = buf.readDouble();
        this.isInvading = buf.readBoolean();
        this.lastSpawns = buf.readInt();
        this.spawndelay = buf.readInt();
    }
}

