/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.laythe;

import com.hbm.dim.WorldChunkManagerCelestial;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.laythe.ChunkProviderLaythe;
import com.hbm.dim.laythe.SkyProviderLaytheSunset;
import com.hbm.dim.laythe.biome.BiomeGenBaseLaythe;
import com.hbm.dim.laythe.genlayer.GenLayerDiversifyLaythe;
import com.hbm.dim.laythe.genlayer.GenLayerLaytheBiomes;
import com.hbm.dim.laythe.genlayer.GenLayerLaytheIslands;
import com.hbm.dim.laythe.genlayer.GenLayerLaytheOceans;
import com.hbm.dim.laythe.genlayer.GenLayerLaythePolar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;

public class WorldProviderLaythe
extends WorldProviderCelestial {
    @Override
    public void func_76572_b() {
        this.field_76578_c = new WorldChunkManagerCelestial(WorldProviderLaythe.createBiomeGenerators(this.field_76579_a.func_72905_C()));
    }

    public String func_80007_l() {
        return "Laythe";
    }

    public IChunkProvider func_76555_c() {
        return new ChunkProviderLaythe(this.field_76579_a, this.getSeed(), false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return new SkyProviderLaytheSunset();
    }

    @Override
    public boolean hasLife() {
        return true;
    }

    @Override
    public int getWaterOpacity() {
        return 1;
    }

    @Override
    public float fogDensity(EntityViewRenderEvent.FogDensity event) {
        if (event.block.func_149688_o() == Material.field_151586_h) {
            return 0.03f;
        }
        return super.fogDensity(event);
    }

    @Override
    public boolean updateLightmap(int[] lightmap) {
        float sun = this.getSunBrightness(1.0f);
        for (int i = 0; i < 256; ++i) {
            float sky = this.field_76573_f[i / 16];
            float jool = Math.max(sky - sun, 0.0f);
            int[] color = this.unpackColor(lightmap[i]);
            color[1] = (int)((float)color[1] + jool * 60.0f);
            if (color[1] > 255) {
                color[1] = 255;
            }
            lightmap[i] = this.packColor(color);
        }
        return true;
    }

    private static WorldChunkManagerCelestial.BiomeGenLayers createBiomeGenerators(long seed) {
        GenLayer biomes = new GenLayerLaytheBiomes(seed);
        biomes = new GenLayerLaythePolar(1000L, biomes);
        biomes = new GenLayerZoom(1040L, biomes);
        biomes = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)biomes, (int)1);
        biomes = new GenLayerLaythePolar(1300L, biomes);
        biomes = new GenLayerDiversifyLaythe(1000L, biomes);
        biomes = new GenLayerLaytheOceans(56000L, biomes);
        biomes = new GenLayerLaytheIslands(200L, biomes);
        biomes = new GenLayerZoom(1200L, biomes);
        biomes = new GenLayerZoom(1001L, biomes);
        biomes = new GenLayerLaytheOceans(4000L, biomes);
        biomes = new GenLayerLaytheOceans(4001L, biomes, BiomeGenBaseLaythe.laytheCoast.field_76756_M);
        biomes = new GenLayerZoom(1003L, biomes);
        biomes = new GenLayerLaytheOceans(4342L, biomes, BiomeGenBaseLaythe.laytheCoast.field_76756_M);
        biomes = new GenLayerSmooth(700L, biomes);
        biomes = new GenLayerZoom(1006L, biomes);
        GenLayerVoronoiZoom genLayerVoronoiZoom = new GenLayerVoronoiZoom(10L, biomes);
        return new WorldChunkManagerCelestial.BiomeGenLayers(biomes, (GenLayer)genLayerVoronoiZoom, seed);
    }
}

