/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.tile.IPropulsion;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.handler.ThreeInts;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityOrbitalStationComputer;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class BlockOrbitalStationComputer
extends BlockDummyable
implements ILookOverlay {
    public BlockOrbitalStationComputer(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOrbitalStationComputer();
    }

    @Override
    public int[] getDimensions() {
        return new int[]{0, 0, 0, 0, 0, 0};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!CelestialBody.inOrbit(world)) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return false;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityOrbitalStationComputer)) {
            return false;
        }
        TileEntityOrbitalStationComputer computer = (TileEntityOrbitalStationComputer)te;
        if (computer.isTravelling()) {
            return false;
        }
        ItemStack heldStack = player.func_70694_bm();
        if (heldStack != null && heldStack.func_77973_b() instanceof ItemVOTVdrive) {
            if (computer.slots[0] != null) {
                return false;
            }
            ItemVOTVdrive.Destination destination = ItemVOTVdrive.getDestination(heldStack);
            if (destination.body == SolarSystem.Body.ORBIT) {
                return false;
            }
            if (!computer.travelTo(destination.body.getBody(), heldStack.func_77946_l())) return false;
            heldStack.field_77994_a = 0;
            world.func_72908_a((double)x, (double)y, (double)z, "hbm:item.upgradePlug", 1.0f, 1.0f);
            return true;
        } else if (heldStack == null && computer.slots[0] != null) {
            if (!player.field_71071_by.func_70441_a(computer.slots[0].func_77946_l())) {
                player.func_71019_a(computer.slots[0].func_77946_l(), false);
            }
            computer.slots[0] = null;
            computer.markChanged();
            return true;
        } else {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)pos[0], (int)pos[1], (int)pos[2]);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        if (!CelestialBody.inOrbit(world)) {
            ArrayList<String> text = new ArrayList<String>();
            text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! " + I18nUtil.resolveKey("atmosphere.noOrbit", new Object[0]) + " ! ! !");
            ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
            return;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityOrbitalStationComputer)) {
            return;
        }
        TileEntityOrbitalStationComputer computer = (TileEntityOrbitalStationComputer)te;
        OrbitalStation station = OrbitalStation.clientStation;
        double progress = station.getUnscaledProgress(0.0f);
        ArrayList<String> text = new ArrayList<String>();
        if (!station.hasEngines) {
            text.add(EnumChatFormatting.RED + "No engines available");
        } else if (station.errorsAt.size() > 0) {
            for (ThreeInts errorAt : station.errorsAt) {
                TileEntity error = world.func_147438_o(errorAt.x, errorAt.y, errorAt.z);
                if (error == null || !(error instanceof IPropulsion)) continue;
                ((IPropulsion)error).addErrors(text);
            }
        } else if (progress > 0.0) {
            if (station.state == OrbitalStation.StationState.LEAVING) {
                text.add(EnumChatFormatting.AQUA + I18nUtil.resolveKey("station.engage", new Object[0]) + ": " + EnumChatFormatting.RESET + I18nUtil.resolveKey("body." + station.target.name, new Object[0]));
            } else if (station.state == OrbitalStation.StationState.ARRIVING) {
                text.add(EnumChatFormatting.AQUA + I18nUtil.resolveKey("station.disengage", new Object[0]));
            } else {
                text.add(EnumChatFormatting.AQUA + I18nUtil.resolveKey("station.travelling", new Object[0]) + ": " + EnumChatFormatting.RESET + I18nUtil.resolveKey("body." + station.target.name, new Object[0]));
            }
            text.add(EnumChatFormatting.AQUA + I18nUtil.resolveKey("station.progress", new Object[0]) + ": " + EnumChatFormatting.RESET + "" + Math.round(progress * 100.0) + "%");
        } else if (computer.hasDrive) {
            if (Minecraft.func_71410_x().field_71439_g.func_70694_bm() != null) {
                text.add(I18nUtil.resolveKey("station.removeDrive", new Object[0]));
            } else {
                text.add(I18nUtil.resolveKey("station.interactDrive", new Object[0]));
            }
        } else {
            text.add(I18nUtil.resolveKey("station.insertDrive", new Object[0]));
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

