/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.IBlockMulti;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.StructureConfig;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.gui.element.GuiFileList;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.Tuple;
import com.hbm.util.i18n.I18nUtil;
import com.hbm.world.gen.nbt.NBTStructure;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Keyboard;

public class BlockWandStructure
extends BlockContainer
implements IBlockMulti,
IGUIProvider,
ILookOverlay {
    private IIcon saveIcon;
    private IIcon loadIcon;

    public BlockWandStructure() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityWandStructure();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.saveIcon = iconRegister.func_94245_a("hbm:wand_structure_save");
        this.loadIcon = iconRegister.func_94245_a("hbm:wand_structure_load");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 1) {
            return this.loadIcon;
        }
        return this.saveIcon;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandStructure)) {
            return false;
        }
        TileEntityWandStructure structure = (TileEntityWandStructure)te;
        if (!player.func_70093_af()) {
            Block block = ModBlocks.getBlockFromStack(player.func_70694_bm());
            if (block != null && !ModBlocks.isStructureBlock(block, true)) {
                Tuple.Pair<Block, Integer> bm = new Tuple.Pair<Block, Integer>(block, player.func_70694_bm().func_77960_j());
                if (structure.blacklist.contains(bm)) {
                    structure.blacklist.remove(bm);
                } else {
                    structure.blacklist.add(bm);
                }
                return true;
            }
            if (world.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 1));
    }

    @Override
    public int getSubCount() {
        return 2;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta == 1) {
            return this.func_149739_a() + ".load";
        }
        return this.func_149739_a() + ".save";
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TileEntityWandStructure structure = (TileEntityWandStructure)world.func_147438_o(x, y, z);
        if (meta == 1) {
            return new GuiStructureLoad(structure);
        }
        return new GuiStructureSave(structure);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) != 0) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandStructure)) {
            return;
        }
        TileEntityWandStructure structure = (TileEntityWandStructure)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.GRAY + "Name: " + EnumChatFormatting.RESET + structure.name);
        text.add(EnumChatFormatting.GRAY + "Blacklist:");
        for (Tuple.Pair<Block, Integer> bm : structure.blacklist) {
            text.add(EnumChatFormatting.RED + "- " + bm.getKey().func_149739_a() + " : " + bm.getValue());
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".save.name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @SideOnly(value=Side.CLIENT)
    public static class GuiStructureLoad
    extends GuiScreen {
        private final TileEntityWandStructure tile;
        private GuiTextField textName;
        private GuiFileList fileList;
        private GuiButton performAction;
        private boolean loadOnClose = false;
        private static File structureDirectory = new File(Minecraft.func_71410_x().field_71412_D, "structures");
        private static String nameFilter = "";
        private static final FileFilter structureFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile() || !file.getName().endsWith(".nbt")) {
                    return false;
                }
                return nameFilter.isEmpty() || file.getName().contains(nameFilter);
            }
        };

        public GuiStructureLoad(TileEntityWandStructure tile) {
            this.tile = tile;
        }

        public void func_73866_w_() {
            Keyboard.enableRepeatEvents((boolean)true);
            this.textName = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, 50, 300, 20);
            this.textName.func_146180_a(this.tile.name);
            nameFilter = this.tile.name;
            structureDirectory.mkdir();
            this.fileList = new GuiFileList(this.field_146297_k, structureDirectory.listFiles(structureFilter), this::selectFile, nameFilter, this.field_146294_l, this.field_146295_m, 70, this.field_146295_m - 90, 16);
            this.performAction = new GuiButton(0, this.field_146294_l / 2 - 150, this.field_146295_m - 70, 300, 20, "LOAD");
        }

        public void selectFile(File file) {
            String fileName = file.getName();
            this.textName.func_146180_a(fileName.substring(0, fileName.length() - 4));
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.fileList.func_148128_a(mouseX, mouseY, partialTicks);
            this.textName.func_146194_f();
            this.performAction.func_146112_a(this.field_146297_k, mouseX, mouseY);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        public void func_146281_b() {
            Keyboard.enableRepeatEvents((boolean)false);
            NBTTagCompound data = new NBTTagCompound();
            this.tile.func_145841_b(data);
            data.func_74778_a("name", this.textName.func_146179_b());
            if (this.loadOnClose) {
                data.func_74757_a("load", true);
            }
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e));
        }

        protected void func_73869_a(char typedChar, int keyCode) {
            super.func_73869_a(typedChar, keyCode);
            this.textName.func_146201_a(typedChar, keyCode);
            if (!nameFilter.equals(this.textName.func_146179_b())) {
                nameFilter = this.textName.func_146179_b();
                this.fileList = new GuiFileList(this.field_146297_k, structureDirectory.listFiles(structureFilter), this::selectFile, nameFilter, this.field_146294_l, this.field_146295_m, 70, this.field_146295_m - 90, 16);
            }
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            this.textName.func_146192_a(mouseX, mouseY, mouseButton);
            this.fileList.func_148179_a(mouseX, mouseY, mouseButton);
            this.fileList.select(this.textName.func_146179_b());
            if (this.performAction.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                this.loadOnClose = true;
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
            }
        }

        protected void func_146286_b(int mouseX, int mouseY, int state) {
            super.func_146286_b(mouseX, mouseY, state);
            this.fileList.func_148181_b(mouseX, mouseY, state);
        }

        public boolean func_73868_f() {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class GuiStructureSave
    extends GuiScreen {
        private final TileEntityWandStructure tile;
        private GuiTextField textName;
        private GuiTextField textSizeX;
        private GuiTextField textSizeY;
        private GuiTextField textSizeZ;
        private GuiButton performAction;
        private boolean saveOnClose = false;

        public GuiStructureSave(TileEntityWandStructure tile) {
            this.tile = tile;
        }

        public void func_73866_w_() {
            Keyboard.enableRepeatEvents((boolean)true);
            this.textName = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, 50, 300, 20);
            this.textName.func_146180_a(this.tile.name);
            this.textSizeX = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, 100, 50, 20);
            this.textSizeX.func_146180_a("" + this.tile.sizeX);
            this.textSizeY = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 100, 100, 50, 20);
            this.textSizeY.func_146180_a("" + this.tile.sizeY);
            this.textSizeZ = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 50, 100, 50, 20);
            this.textSizeZ.func_146180_a("" + this.tile.sizeZ);
            this.performAction = new GuiButton(0, this.field_146294_l / 2 - 150, 150, 300, 20, "SAVE");
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            this.textName.func_146194_f();
            this.textSizeX.func_146194_f();
            this.textSizeY.func_146194_f();
            this.textSizeZ.func_146194_f();
            this.performAction.func_146112_a(this.field_146297_k, mouseX, mouseY);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        public void func_146281_b() {
            Keyboard.enableRepeatEvents((boolean)false);
            NBTTagCompound data = new NBTTagCompound();
            this.tile.func_145841_b(data);
            data.func_74778_a("name", this.textName.func_146179_b());
            try {
                data.func_74768_a("sizeX", Integer.parseInt(this.textSizeX.func_146179_b()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                data.func_74768_a("sizeY", Integer.parseInt(this.textSizeY.func_146179_b()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                data.func_74768_a("sizeZ", Integer.parseInt(this.textSizeZ.func_146179_b()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.saveOnClose) {
                data.func_74757_a("save", true);
            }
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e));
        }

        protected void func_73869_a(char typedChar, int keyCode) {
            super.func_73869_a(typedChar, keyCode);
            this.textName.func_146201_a(typedChar, keyCode);
            this.textSizeX.func_146201_a(typedChar, keyCode);
            this.textSizeY.func_146201_a(typedChar, keyCode);
            this.textSizeZ.func_146201_a(typedChar, keyCode);
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            this.textName.func_146192_a(mouseX, mouseY, mouseButton);
            this.textSizeX.func_146192_a(mouseX, mouseY, mouseButton);
            this.textSizeY.func_146192_a(mouseX, mouseY, mouseButton);
            this.textSizeZ.func_146192_a(mouseX, mouseY, mouseButton);
            if (this.performAction.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                this.saveOnClose = true;
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
            }
        }

        public boolean func_73868_f() {
            return false;
        }
    }

    public static class TileEntityWandStructure
    extends TileEntityLoadedBase
    implements IControlReceiver {
        public String name = "";
        public int sizeX = 1;
        public int sizeY = 1;
        public int sizeZ = 1;
        public Set<Tuple.Pair<Block, Integer>> blacklist = new HashSet<Tuple.Pair<Block, Integer>>();

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                this.networkPackNT(256);
            }
        }

        public void saveStructure(EntityPlayer player) {
            if (this.name.isEmpty()) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Could not save: invalid name"));
                return;
            }
            if (this.sizeX <= 0 || this.sizeY <= 0 || this.sizeZ <= 0) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Could not save: invalid dimensions"));
                return;
            }
            Tuple.Pair<Block, Integer> air = new Tuple.Pair<Block, Integer>(Blocks.field_150350_a, 0);
            this.blacklist.add(air);
            File file = NBTStructure.quickSaveArea(this.name + ".nbt", this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.field_145851_c + this.sizeX - 1, this.field_145848_d + this.sizeY, this.field_145849_e + this.sizeZ - 1, this.blacklist);
            this.blacklist.remove(air);
            if (file == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Failed to save structure"));
                return;
            }
            ChatComponentText fileText = new ChatComponentText(file.getName());
            fileText.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getParentFile().getAbsolutePath()));
            fileText.func_150256_b().func_150228_d(Boolean.valueOf(true));
            player.func_145747_a(new ChatComponentText("Saved structure as ").func_150257_a((IChatComponent)fileText));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadStructure(EntityPlayer player) {
            if (this.name.isEmpty()) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Could not load: no filename specified"));
                return;
            }
            File structureDirectory = new File(Minecraft.func_71410_x().field_71412_D, "structures");
            structureDirectory.mkdir();
            File structureFile = new File(structureDirectory, this.name + ".nbt");
            boolean previousDebug = StructureConfig.debugStructures;
            StructureConfig.debugStructures = true;
            try {
                NBTStructure structure = new NBTStructure(structureFile);
                this.sizeX = structure.getSizeX();
                this.sizeY = structure.getSizeY();
                this.sizeZ = structure.getSizeZ();
                structure.build(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 0, false, true);
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
                player.func_145747_a((IChatComponent)new ChatComponentText("Structure loaded"));
            }
            catch (FileNotFoundException ex) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Could not load: file not found"));
            }
            finally {
                StructureConfig.debugStructures = previousDebug;
            }
        }

        @Override
        public void serialize(ByteBuf buf) {
            BufferUtil.writeString(buf, this.name);
            buf.writeInt(this.sizeX);
            buf.writeInt(this.sizeY);
            buf.writeInt(this.sizeZ);
            buf.writeInt(this.blacklist.size());
            for (Tuple.Pair<Block, Integer> bm : this.blacklist) {
                buf.writeInt(Block.func_149682_b((Block)bm.getKey()));
                buf.writeInt(bm.getValue().intValue());
            }
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.name = BufferUtil.readString(buf);
            this.sizeX = buf.readInt();
            this.sizeY = buf.readInt();
            this.sizeZ = buf.readInt();
            int count = buf.readInt();
            this.blacklist = new HashSet<Tuple.Pair<Block, Integer>>();
            for (int i = 0; i < count; ++i) {
                Block block = Block.func_149729_e((int)buf.readInt());
                int meta = buf.readInt();
                this.blacklist.add(new Tuple.Pair<Block, Integer>(block, meta));
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.name = nbt.func_74779_i("name");
            this.sizeX = nbt.func_74762_e("sizeX");
            this.sizeY = nbt.func_74762_e("sizeY");
            this.sizeZ = nbt.func_74762_e("sizeZ");
            int[] blocks = nbt.func_74759_k("blocks");
            int[] metas = nbt.func_74759_k("metas");
            this.blacklist = new HashSet<Tuple.Pair<Block, Integer>>();
            for (int i = 0; i < blocks.length; ++i) {
                this.blacklist.add(new Tuple.Pair<Block, Integer>(Block.func_149729_e((int)blocks[i]), metas[i]));
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74778_a("name", this.name);
            nbt.func_74768_a("sizeX", this.sizeX);
            nbt.func_74768_a("sizeY", this.sizeY);
            nbt.func_74768_a("sizeZ", this.sizeZ);
            nbt.func_74783_a("blocks", this.blacklist.stream().mapToInt(b -> Block.func_149682_b((Block)((Block)b.getKey()))).toArray());
            nbt.func_74783_a("metas", this.blacklist.stream().mapToInt(b -> (Integer)b.getValue()).toArray());
        }

        @Override
        public boolean hasPermission(EntityPlayer player) {
            return true;
        }

        @Override
        public void receiveControl(NBTTagCompound data) {
        }

        @Override
        public void receiveControl(EntityPlayer player, NBTTagCompound nbt) {
            this.func_145839_a(nbt);
            this.func_70296_d();
            if (nbt.func_74767_n("save")) {
                this.saveStructure(player);
            }
            if (nbt.func_74767_n("load")) {
                this.loadStructure(player);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public AxisAlignedBB getRenderBoundingBox() {
            return INFINITE_EXTENT_AABB;
        }

        @SideOnly(value=Side.CLIENT)
        public double func_145833_n() {
            return 65536.0;
        }
    }
}

