/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import api.hbm.fluidmk2.IFluidReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.ClientConfig;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemRebarPlacer;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.render.block.ISBRHUniversal;
import com.hbm.render.util.RenderBlocksNT;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.network.TileEntityPipeBaseNT;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.INetworkProvider;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.RebarNetwork;
import com.hbm.uninos.networkproviders.RebarNetworkProvider;
import com.hbm.util.BobMathUtil;
import com.hbm.util.Compat;
import com.hbm.util.InventoryUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockRebar
extends BlockContainer
implements ISBRHUniversal {
    @SideOnly(value=Side.CLIENT)
    protected IIcon concrete;

    public BlockRebar() {
        super(Material.field_151573_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.concrete = reg.func_94245_a("hbm:concrete_liquid");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityRebar();
    }

    public int func_149645_b() {
        return renderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityRebar)) {
            return;
        }
        TileEntityRebar rebar = (TileEntityRebar)tile;
        rebar.hasConnection = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity neighbor = Compat.getTileStandard(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (!(neighbor instanceof TileEntityPipeBaseNT)) continue;
            rebar.hasConnection = true;
            return;
        }
    }

    @Override
    public void renderInventoryBlock(Block block, int meta, int modelId, Object renderBlocks) {
        GL11.glPushMatrix();
        RenderBlocks renderer = (RenderBlocks)renderBlocks;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        double o = 0.25;
        renderer.func_147782_a(0.4375 - o, 0.0, 0.4375 - o, 0.5625 - o, 1.0, 0.5625 - o);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.4375 - o, 0.0, 0.4375 + o, 0.5625 - o, 1.0, 0.5625 + o);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.4375 + o, 0.0, 0.4375 - o, 0.5625 + o, 1.0, 0.5625 - o);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.4375 + o, 0.0, 0.4375 + o, 0.5625 + o, 1.0, 0.5625 + o);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.0, 0.4375 - o, 0.4375 - o, 1.0, 0.5625 - o, 0.5625 - o);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.0, 0.4375 - o, 0.4375 + o, 1.0, 0.5625 - o, 0.5625 + o);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.0, 0.4375 + o, 0.4375 - o, 1.0, 0.5625 + o, 0.5625 - o);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.0, 0.4375 + o, 0.4375 + o, 1.0, 0.5625 + o, 0.5625 + o);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.4375 - o, 0.4375 - o, 0.0, 0.5625 - o, 0.5625 - o, 1.0);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.4375 - o, 0.4375 + o, 0.0, 0.5625 - o, 0.5625 + o, 1.0);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.4375 + o, 0.4375 - o, 0.0, 0.5625 + o, 0.5625 - o, 1.0);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        renderer.func_147782_a(0.4375 + o, 0.4375 + o, 0.0, 0.5625 + o, 0.5625 + o, 1.0);
        RenderBlocksNT.renderStandardInventoryBlock(block, meta, renderer);
        GL11.glPopMatrix();
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, Object renderBlocks) {
        RenderBlocksNT renderer = RenderBlocksNT.INSTANCE.setWorld(world);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        double o = 0.25;
        double min = -0.001;
        double max = 1.001;
        if (ClientConfig.RENDER_REBAR_SIMPLE.get().booleanValue()) {
            renderer.func_147782_a(0.4375, min, 0.4375, 0.5625, max, 0.5625);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(min, 0.4375, 0.4375, max, 0.5625, 0.5625);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(0.4375, 0.4375, min, 0.5625, 0.5625, max);
            renderer.func_147784_q(block, x, y, z);
        } else {
            renderer.func_147782_a(0.4375 - o, min, 0.4375 - o, 0.5625 - o, max, 0.5625 - o);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(0.4375 - o, min, 0.4375 + o, 0.5625 - o, max, 0.5625 + o);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(0.4375 + o, min, 0.4375 - o, 0.5625 + o, max, 0.5625 - o);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(0.4375 + o, min, 0.4375 + o, 0.5625 + o, max, 0.5625 + o);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(min, 0.4375 - o, 0.4375 - o, max, 0.5625 - o, 0.5625 - o);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(min, 0.4375 - o, 0.4375 + o, max, 0.5625 - o, 0.5625 + o);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(min, 0.4375 + o, 0.4375 - o, max, 0.5625 + o, 0.5625 - o);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(min, 0.4375 + o, 0.4375 + o, max, 0.5625 + o, 0.5625 + o);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(0.4375 - o, 0.4375 - o, min, 0.5625 - o, 0.5625 - o, max);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(0.4375 - o, 0.4375 + o, min, 0.5625 - o, 0.5625 + o, max);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(0.4375 + o, 0.4375 - o, min, 0.5625 + o, 0.5625 - o, max);
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a(0.4375 + o, 0.4375 + o, min, 0.5625 + o, 0.5625 + o, max);
            renderer.func_147784_q(block, x, y, z);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderRebar(List tiles, float interp) {
        ArrayList<TileEntityRebar> rebars = new ArrayList<TileEntityRebar>();
        for (Object o : tiles) {
            if (!(o instanceof TileEntityRebar)) continue;
            TileEntityRebar rebar = (TileEntityRebar)o;
            if (rebar.progress > 0) {
                rebars.add(rebar);
            }
            if (rebars.size() < ClientConfig.RENDER_REBAR_LIMIT.get()) continue;
            break;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        WorldClient world = mc.field_71441_e;
        double dx = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)interp;
        double dy = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)interp;
        double dz = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)interp;
        if (!rebars.isEmpty()) {
            GL11.glPushMatrix();
            GL11.glShadeModel((int)7425);
            EntityRenderer entityRenderer = mc.field_71460_t;
            entityRenderer.func_78463_b((double)interp);
            RenderBlocksNT renderer = RenderBlocksNT.INSTANCE.setWorld((IBlockAccess)world);
            renderer.func_147757_a(((BlockRebar)ModBlocks.rebar).concrete);
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78382_b();
            for (TileEntityRebar rebar : rebars) {
                tess.func_78373_b(-dx, -dy, -dz);
                tess.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
                renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, (double)rebar.progress / 1000.0, 1.0);
                renderer.func_147784_q(ModBlocks.rebar, rebar.field_145851_c, rebar.field_145848_d, rebar.field_145849_e);
            }
            tess.func_78381_a();
            tess.func_78373_b(0.0, 0.0, 0.0);
            renderer.func_147771_a();
            entityRenderer.func_78483_a((double)interp);
            GL11.glShadeModel((int)7424);
            GL11.glPopMatrix();
        }
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.rebar_placer && player.func_70694_bm().func_77942_o() && player.func_70694_bm().field_77990_d.func_74764_b("pos") && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int[] pos = player.func_70694_bm().field_77990_d.func_74759_k("pos");
            MovingObjectPosition mop = mc.field_71476_x;
            ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
            int iX = mop.field_72311_b + dir.offsetX;
            int iY = mop.field_72312_c + dir.offsetY;
            int iZ = mop.field_72309_d + dir.offsetZ;
            double minX = (double)Math.min(pos[0], iX) + 0.125;
            double maxX = (double)Math.max(pos[0], iX) + 0.875;
            double minY = (double)Math.min(pos[1], iY) + 0.125;
            double maxY = (double)Math.max(pos[1], iY) + 0.875;
            double minZ = (double)Math.min(pos[2], iZ) + 0.125;
            double maxZ = (double)Math.max(pos[2], iZ) + 0.875;
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78373_b(-dx, -dy, -dz);
            tess.func_78371_b(1);
            tess.func_78380_c(240);
            tess.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
            tess.func_78377_a(minX, maxY, minZ);
            tess.func_78377_a(minX, maxY, maxZ);
            tess.func_78377_a(minX, maxY, maxZ);
            tess.func_78377_a(maxX, maxY, maxZ);
            tess.func_78377_a(maxX, maxY, maxZ);
            tess.func_78377_a(maxX, maxY, minZ);
            tess.func_78377_a(maxX, maxY, minZ);
            tess.func_78377_a(minX, maxY, minZ);
            tess.func_78377_a(minX, minY, minZ);
            tess.func_78377_a(minX, minY, maxZ);
            tess.func_78377_a(minX, minY, maxZ);
            tess.func_78377_a(maxX, minY, maxZ);
            tess.func_78377_a(maxX, minY, maxZ);
            tess.func_78377_a(maxX, minY, minZ);
            tess.func_78377_a(maxX, minY, minZ);
            tess.func_78377_a(minX, minY, minZ);
            tess.func_78377_a(minX, minY, minZ);
            tess.func_78377_a(minX, maxY, minZ);
            tess.func_78377_a(maxX, minY, minZ);
            tess.func_78377_a(maxX, maxY, minZ);
            tess.func_78377_a(maxX, minY, maxZ);
            tess.func_78377_a(maxX, maxY, maxZ);
            tess.func_78377_a(minX, minY, maxZ);
            tess.func_78377_a(minX, maxY, maxZ);
            tess.func_78381_a();
            tess.func_78373_b(0.0, 0.0, 0.0);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
            int rebarLeft = InventoryUtil.countAStackMatches((EntityPlayer)player, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rebar), true);
            int rebarRequired = (Math.max(pos[0], iX) - Math.min(pos[0], iX) + 1) * (Math.max(pos[1], iY) - Math.min(pos[1], iY) + 1) * (Math.max(pos[2], iZ) - Math.min(pos[2], iZ) + 1);
            MainRegistry.proxy.displayTooltip((rebarRequired > rebarLeft ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + rebarLeft + " / " + rebarRequired, 1000, 3);
        }
    }

    public static class RebarNode
    extends GenNode<RebarNetwork> {
        public RebarNode(INetworkProvider<RebarNetwork> provider, BlockPos ... positions) {
            super(provider, positions);
        }

        public RebarNode setConnections(DirPos ... connections) {
            super.setConnections(connections);
            return this;
        }
    }

    public static class TileEntityRebar
    extends TileEntityLoadedBase
    implements IFluidReceiverMK2,
    IBufPacketReceiver {
        public Block concrete;
        public int concreteMeta;
        public int progress;
        public int prevProgress;
        protected RebarNode node;
        public boolean hasConnection = false;

        public TileEntityRebar setup(Block b, int m) {
            this.concrete = b;
            this.concreteMeta = m;
            return this;
        }

        public void func_145845_h() {
            long time = this.field_145850_b.func_82737_E();
            if (!this.field_145850_b.field_72995_K) {
                if (this.prevProgress != this.progress) {
                    this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                    this.prevProgress = this.progress;
                }
                if (this.progress >= 1000) {
                    if (this.concrete != null && ItemRebarPlacer.isValidConk(Item.func_150898_a((Block)this.concrete), this.concreteMeta)) {
                        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.concrete, this.concreteMeta, 3);
                    } else {
                        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.concrete_rebar);
                    }
                    return;
                }
                if (time % 60L == 0L) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        this.trySubscribe(Fluids.CONCRETE, this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                    }
                }
                if (this.node == null || this.node.expired) {
                    this.node = (RebarNode)UniNodespace.getNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, RebarNetworkProvider.THE_PROVIDER);
                    if (this.node == null || this.node.expired) {
                        this.node = this.createNode();
                        UniNodespace.createNode(this.field_145850_b, this.node);
                    }
                }
                this.networkPackNT(100);
            }
        }

        public void func_145843_s() {
            super.func_145843_s();
            if (!this.field_145850_b.field_72995_K && this.node != null) {
                UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, RebarNetworkProvider.THE_PROVIDER);
            }
        }

        @Override
        public void serialize(ByteBuf buf) {
            buf.writeInt(this.progress);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.progress = buf.readInt();
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.progress = nbt.func_74762_e("progress");
            this.hasConnection = nbt.func_74767_n("hasConnection");
            if (nbt.func_74764_b("block")) {
                this.concrete = Block.func_149729_e((int)nbt.func_74762_e("block"));
                this.concreteMeta = nbt.func_74762_e("meta");
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74768_a("progress", this.progress);
            nbt.func_74757_a("hasConnection", this.hasConnection);
            if (this.concrete != null) {
                nbt.func_74768_a("block", Block.func_149682_b((Block)this.concrete));
                nbt.func_74768_a("meta", this.concreteMeta);
            }
        }

        public RebarNode createNode() {
            TileEntityRebar tile = this;
            return new RebarNode(RebarNetworkProvider.THE_PROVIDER, new BlockPos[]{new BlockPos(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)}).setConnections(new DirPos(tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, Library.POS_X), new DirPos(tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, Library.NEG_X), new DirPos(tile.field_145851_c, tile.field_145848_d + 1, tile.field_145849_e, Library.POS_Y), new DirPos(tile.field_145851_c, tile.field_145848_d - 1, tile.field_145849_e, Library.NEG_Y), new DirPos(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, Library.POS_Z), new DirPos(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, Library.NEG_Z));
        }

        @Override
        public FluidTank[] getAllTanks() {
            FluidTank tank = new FluidTank(Fluids.CONCRETE, 1000);
            tank.setFill(this.progress);
            return new FluidTank[]{tank};
        }

        @Override
        public long transferFluid(FluidType type, int pressure, long amount) {
            if (type != Fluids.CONCRETE) {
                return amount;
            }
            if (this.node == null || this.node.expired || !this.node.hasValidNet()) {
                return amount;
            }
            ArrayList<TileEntityRebar> lowestLinks = new ArrayList<TileEntityRebar>();
            int lowestY = 256;
            int progress = 0;
            int capacity = 0;
            for (Object o : ((RebarNetwork)this.node.net).links) {
                TileEntity tile;
                RebarNode node = (RebarNode)o;
                int y = node.positions[0].getY();
                if (y < lowestY) {
                    lowestY = y;
                    progress = 0;
                    capacity = 0;
                    lowestLinks.clear();
                }
                if (y != lowestY || !((tile = this.field_145850_b.func_147438_o(node.positions[0].getX(), y, node.positions[0].getZ())) instanceof TileEntityRebar)) continue;
                TileEntityRebar rebar = (TileEntityRebar)tile;
                progress += rebar.progress;
                capacity += 1000;
                lowestLinks.add(rebar);
            }
            if (capacity > 0 && !lowestLinks.isEmpty()) {
                int maxSpeed = 50;
                int maxAccept = (int)BobMathUtil.min(new long[]{capacity - progress, amount, maxSpeed * lowestLinks.size()});
                int target = Math.min((progress + maxAccept) / lowestLinks.size(), 1000);
                for (TileEntityRebar rebar : lowestLinks) {
                    int delta;
                    if (rebar.progress >= target || (long)(delta = target - rebar.progress) > amount) continue;
                    rebar.progress += delta;
                    amount -= (long)delta;
                }
            }
            return amount;
        }

        @Override
        public long getDemand(FluidType type, int pressure) {
            return 10000L;
        }
    }
}

