/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.gui.GUIRBMKConsole;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBoiler;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControlAuto;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControlManual;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKCooler;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKHeater;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKOutgasser;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import com.hbm.util.BufferUtil;
import com.hbm.util.Compat;
import com.hbm.util.EnumUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRBMKConsole
extends TileEntityMachineBase
implements IControlReceiver,
IGUIProvider,
SimpleComponent,
CompatHandler.OCComponent {
    private int targetX;
    private int targetY;
    private int targetZ;
    private byte rotation;
    public static final int fluxDisplayBuffer = 60;
    public int[] fluxBuffer = new int[60];
    public RBMKColumn[] columns = new RBMKColumn[225];
    public RBMKScreen[] screens = new RBMKScreen[6];

    public TileEntityRBMKConsole() {
        super(0);
        for (int i = 0; i < this.screens.length; ++i) {
            this.screens[i] = new RBMKScreen();
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.field_145850_b.field_72984_F.func_76320_a("rbmkConsole_rescan");
                this.rescan();
                this.field_145850_b.field_72984_F.func_76319_b();
                this.prepareScreenInfo();
            }
            this.networkPackNT(50);
        }
    }

    private void rescan() {
        double flux = 0.0;
        for (int index = 0; index < this.columns.length; ++index) {
            int rz;
            int rx = this.getXFromIndex(index);
            TileEntity te = Compat.getTileStandard(this.field_145850_b, this.targetX + rx, this.targetY, this.targetZ + (rz = this.getZFromIndex(index)));
            if (te instanceof TileEntityRBMKBase) {
                TileEntityRBMKBase rbmk = (TileEntityRBMKBase)te;
                this.columns[index] = new RBMKColumn(rbmk.getConsoleType(), rbmk.getNBTForConsole());
                this.columns[index].data.func_74780_a("heat", rbmk.heat);
                this.columns[index].data.func_74780_a("maxHeat", rbmk.maxHeat());
                if (rbmk.isModerated()) {
                    this.columns[index].data.func_74757_a("moderated", true);
                }
                if (!(te instanceof TileEntityRBMKRod)) continue;
                TileEntityRBMKRod fuel = (TileEntityRBMKRod)te;
                flux += fuel.lastFluxQuantity;
                continue;
            }
            this.columns[index] = null;
        }
        for (int i = 0; i < this.fluxBuffer.length - 1; ++i) {
            this.fluxBuffer[i] = this.fluxBuffer[i + 1];
        }
        this.fluxBuffer[this.fluxBuffer.length - 1] = (int)flux;
    }

    private void prepareScreenInfo() {
        for (RBMKScreen screen : this.screens) {
            if (screen.type == ScreenType.NONE) {
                screen.display = null;
                continue;
            }
            double value = 0.0;
            int count = 0;
            block15: for (Integer i : screen.columns) {
                RBMKColumn col = this.columns[i];
                if (col == null) continue;
                switch (screen.type) {
                    case COL_TEMP: {
                        ++count;
                        value += col.data.func_74769_h("heat");
                        continue block15;
                    }
                    case FUEL_DEPLETION: {
                        if (!col.data.func_74764_b("enrichment")) continue block15;
                        ++count;
                        value += 100.0 - col.data.func_74769_h("enrichment") * 100.0;
                        continue block15;
                    }
                    case FUEL_POISON: {
                        if (!col.data.func_74764_b("xenon")) continue block15;
                        ++count;
                        value += col.data.func_74769_h("xenon");
                        continue block15;
                    }
                    case FUEL_TEMP: {
                        if (!col.data.func_74764_b("c_heat")) continue block15;
                        ++count;
                        value += col.data.func_74769_h("c_heat");
                        continue block15;
                    }
                    case ROD_EXTRACTION: {
                        if (!col.data.func_74764_b("level")) continue block15;
                        ++count;
                        value += col.data.func_74769_h("level") * 100.0;
                    }
                }
            }
            double result = value / (double)count;
            String text = (double)((int)(result * 10.0)) / 10.0 + "";
            switch (screen.type) {
                case COL_TEMP: {
                    text = "rbmk.screen.temp=" + text + "\u00b0C";
                    break;
                }
                case FUEL_DEPLETION: {
                    text = "rbmk.screen.depletion=" + text + "%";
                    break;
                }
                case FUEL_POISON: {
                    text = "rbmk.screen.xenon=" + text + "%";
                    break;
                }
                case FUEL_TEMP: {
                    text = "rbmk.screen.core=" + text + "\u00b0C";
                    break;
                }
                case ROD_EXTRACTION: {
                    text = "rbmk.screen.rod=" + text + "%";
                }
            }
            screen.display = text;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            buf.writeBoolean(true);
            for (RBMKColumn column : this.columns) {
                if (column == null || column.type == null) {
                    buf.writeByte(-1);
                    continue;
                }
                buf.writeByte((int)((byte)column.type.ordinal()));
                BufferUtil.writeNBT(buf, column.data);
            }
            BufferUtil.writeIntArray(buf, this.fluxBuffer);
            for (RBMKScreen screen : this.screens) {
                BufferUtil.writeString(buf, screen.display);
            }
        } else {
            buf.writeBoolean(false);
            for (RBMKScreen screen : this.screens) {
                buf.writeByte((int)((byte)screen.type.ordinal()));
            }
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        if (buf.readBoolean()) {
            for (int i = 0; i < this.columns.length; ++i) {
                byte ordinal = buf.readByte();
                this.columns[i] = ordinal == -1 ? null : new RBMKColumn(ColumnType.values()[ordinal], BufferUtil.readNBT(buf));
            }
            this.fluxBuffer = BufferUtil.readIntArray(buf);
            for (RBMKScreen screen : this.screens) {
                screen.display = BufferUtil.readString(buf);
            }
        } else {
            for (RBMKScreen screen : this.screens) {
                screen.type = ScreenType.values()[buf.readByte()];
            }
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        int x;
        if (data.func_74764_b("level")) {
            Set keys = data.func_150296_c();
            for (String key : keys) {
                int z;
                int index;
                TileEntity te;
                if (!key.startsWith("sel_") || !((te = Compat.getTileStandard(this.field_145850_b, this.targetX + (x = this.getXFromIndex(index = data.func_74762_e(key))), this.targetY, this.targetZ + (z = this.getZFromIndex(index)))) instanceof TileEntityRBMKControlManual)) continue;
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.startingLevel = rod.level;
                rod.setTarget(MathHelper.func_151237_a((double)data.func_74769_h("level"), (double)0.0, (double)1.0));
                te.func_70296_d();
            }
        }
        if (data.func_74764_b("toggle")) {
            ScreenType type;
            byte slot = data.func_74771_c("toggle");
            int next = this.screens[slot].type.ordinal() + 1;
            this.screens[slot].type = type = ScreenType.values()[next % ScreenType.values().length];
        }
        if (data.func_74764_b("id")) {
            byte slot = data.func_74771_c("id");
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < 225; ++i) {
                if (!data.func_74767_n("s" + i)) continue;
                list.add(i);
            }
            Integer[] cols = list.toArray(new Integer[0]);
            this.screens[slot].columns = cols;
        }
        if (data.func_74764_b("assignColor")) {
            int[] cols;
            byte color = data.func_74771_c("assignColor");
            int[] nArray = cols = data.func_74759_k("cols");
            int n = nArray.length;
            for (x = 0; x < n; ++x) {
                int z;
                int i = nArray[x];
                int x2 = this.getXFromIndex(i);
                TileEntity te = Compat.getTileStandard(this.field_145850_b, this.targetX + x2, this.targetY, this.targetZ + (z = this.getZFromIndex(i)));
                if (!(te instanceof TileEntityRBMKControlManual)) continue;
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.color = (TileEntityRBMKControlManual.RBMKColor)((Object)EnumUtil.grabEnumSafely(TileEntityRBMKControlManual.RBMKColor.class, color));
                te.func_70296_d();
            }
        }
        if (data.func_74764_b("compressor")) {
            int[] cols = data.func_74759_k("cols");
            for (Object i : (Object)cols) {
                int z;
                int x3 = this.getXFromIndex((int)i);
                TileEntity te = Compat.getTileStandard(this.field_145850_b, this.targetX + x3, this.targetY, this.targetZ + (z = this.getZFromIndex((int)i)));
                if (!(te instanceof TileEntityRBMKBoiler)) continue;
                TileEntityRBMKBoiler rod = (TileEntityRBMKBoiler)te;
                rod.cyceCompressor();
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 3));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targetX = nbt.func_74762_e("tX");
        this.targetY = nbt.func_74762_e("tY");
        this.targetZ = nbt.func_74762_e("tZ");
        for (int i = 0; i < this.screens.length; ++i) {
            this.screens[i].type = ScreenType.values()[nbt.func_74771_c("t" + i)];
            this.screens[i].columns = (Integer[])Arrays.stream(nbt.func_74759_k("s" + i)).boxed().toArray(Integer[]::new);
        }
        this.rotation = nbt.func_74771_c("rotation");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tY", this.targetY);
        nbt.func_74768_a("tZ", this.targetZ);
        for (int i = 0; i < this.screens.length; ++i) {
            nbt.func_74774_a("t" + i, (byte)this.screens[i].type.ordinal());
            nbt.func_74783_a("s" + i, Arrays.stream(this.screens[i].columns).mapToInt(Integer::intValue).toArray());
        }
        nbt.func_74774_a("rotation", this.rotation);
    }

    public void rotate() {
        this.rotation = (byte)((this.rotation + 1) % 4);
    }

    public int getXFromIndex(int col) {
        int i = col % 15 - 7;
        int j = col / 15 - 7;
        switch (this.rotation) {
            case 0: {
                return i;
            }
            case 1: {
                return -j;
            }
            case 2: {
                return -i;
            }
            case 3: {
                return j;
            }
        }
        return i;
    }

    public int getZFromIndex(int col) {
        int i = col % 15 - 7;
        int j = col / 15 - 7;
        switch (this.rotation) {
            case 0: {
                return j;
            }
            case 1: {
                return i;
            }
            case 2: {
                return -j;
            }
            case 3: {
                return -i;
            }
        }
        return j;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKConsole(player.field_71071_by, this);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "rbmk_console";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getColumnData(Context context, Arguments args) {
        int x = args.checkInteger(0) - 7;
        int y = -args.checkInteger(1) + 7;
        int i = x;
        int j = y;
        switch (this.rotation) {
            case 0: {
                break;
            }
            case 1: {
                i = y;
                j = -x;
                break;
            }
            case 2: {
                i = -x;
                j = -y;
                break;
            }
            case 3: {
                i = -y;
                j = x;
            }
        }
        int index = (j + 7) * 15 + (i + 7);
        TileEntity te = Compat.getTileStandard(this.field_145850_b, this.targetX + x, this.targetY, this.targetZ + y);
        if (te instanceof TileEntityRBMKBase) {
            TileEntityRBMKBase column = (TileEntityRBMKBase)te;
            NBTTagCompound column_data = this.columns[index].data;
            LinkedHashMap<String, Object> data_table = new LinkedHashMap<String, Object>();
            data_table.put("type", column.getConsoleType().name());
            data_table.put("hullTemp", column_data.func_74769_h("heat"));
            data_table.put("realSimWater", column.reasimWater);
            data_table.put("realSimSteam", column.reasimSteam);
            data_table.put("moderated", column_data.func_74767_n("moderated"));
            data_table.put("level", column_data.func_74769_h("level"));
            data_table.put("targetLevel", column_data.func_74769_h("targetLevel"));
            data_table.put("color", column_data.func_74765_d("color"));
            data_table.put("enrichment", column_data.func_74769_h("enrichment"));
            data_table.put("xenon", column_data.func_74769_h("xenon"));
            data_table.put("coreSkinTemp", column_data.func_74769_h("c_heat"));
            data_table.put("coreTemp", column_data.func_74769_h("c_coreHeat"));
            data_table.put("coreMaxTemp", column_data.func_74769_h("c_maxHeat"));
            if (te instanceof TileEntityRBMKControlAuto) {
                TileEntityRBMKControlAuto controlAuto = (TileEntityRBMKControlAuto)te;
                data_table.put("function", controlAuto.function.toString());
                data_table.put("heatUpper", controlAuto.heatUpper);
                data_table.put("heatLower", controlAuto.heatLower);
                data_table.put("levelUpper", controlAuto.levelUpper);
                data_table.put("levelLower", controlAuto.levelLower);
            }
            if (te instanceof TileEntityRBMKRod) {
                TileEntityRBMKRod fuelChannel = (TileEntityRBMKRod)te;
                data_table.put("fluxQuantity", fuelChannel.lastFluxQuantity);
                data_table.put("fluxRatio", fuelChannel.fluxFastRatio);
                ItemStack rod = fuelChannel.func_70301_a(0);
                if (rod != null) {
                    data_table.put("rodName", rod.func_77977_a());
                } else {
                    data_table.put("rodName", "");
                }
            }
            if (te instanceof TileEntityRBMKBoiler) {
                TileEntityRBMKBoiler boiler = (TileEntityRBMKBoiler)te;
                data_table.put("water", boiler.feed.getFill());
                data_table.put("steam", boiler.steam.getFill());
                data_table.put("steamType", Fluids.fromID(column_data.func_74765_d("type")).getUnlocalizedName());
            }
            if (te instanceof TileEntityRBMKOutgasser) {
                TileEntityRBMKOutgasser irradiationChannel = (TileEntityRBMKOutgasser)te;
                data_table.put("fluxProgress", irradiationChannel.progress);
                data_table.put("requiredFlux", 10000);
                ItemStack input = irradiationChannel.func_70301_a(0);
                if (input != null) {
                    data_table.put("craftingName", input.func_77977_a());
                    data_table.put("craftingNumber", input.field_77994_a);
                } else {
                    data_table.put("craftingName", "");
                    data_table.put("craftingNumber", 0);
                }
            }
            if (te instanceof TileEntityRBMKHeater) {
                TileEntityRBMKHeater heaterChannel = (TileEntityRBMKHeater)te;
                data_table.put("coolant", heaterChannel.feed.getFill());
                data_table.put("hotcoolant", heaterChannel.steam.getFill());
                data_table.put("coldtype", Fluids.fromID(column_data.func_74765_d("type")).getUnlocalizedName());
                data_table.put("hottype", Fluids.fromID(column_data.func_74765_d("hottype")).getUnlocalizedName());
            }
            if (te instanceof TileEntityRBMKCooler) {
                TileEntityRBMKCooler coolerChannel = (TileEntityRBMKCooler)te;
                data_table.put("cryogel", coolerChannel.getAllTanks()[0].getFill());
            }
            return new Object[]{data_table};
        }
        return new Object[]{null};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getRBMKPos(Context context, Arguments args) {
        if (this.targetX != 0 || this.targetY != 0 || this.targetZ != 0) {
            LinkedHashMap<String, Integer> data_table = new LinkedHashMap<String, Integer>();
            data_table.put("rbmkCenterX", this.targetX);
            data_table.put("rbmkCenterY", this.targetY);
            data_table.put("rbmkCenterZ", this.targetZ);
            return new Object[]{data_table};
        }
        return new Object[]{null};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setLevel(Context context, Arguments args) {
        double new_level = args.checkDouble(0);
        boolean foundRods = false;
        for (int i = -7; i <= 7; ++i) {
            for (int j = -7; j <= 7; ++j) {
                TileEntity te = Compat.getTileStandard(this.field_145850_b, this.targetX + i, this.targetY, this.targetZ + j);
                if (!(te instanceof TileEntityRBMKControlManual)) continue;
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.startingLevel = rod.level;
                new_level = Math.min(1.0, Math.max(0.0, new_level));
                rod.setTarget(new_level);
                te.func_70296_d();
                foundRods = true;
            }
        }
        if (foundRods) {
            return new Object[0];
        }
        return new Object[]{"No control rods found"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setColumnLevel(Context context, Arguments args) {
        int x = args.checkInteger(0) - 7;
        int y = -args.checkInteger(1) + 7;
        double new_level = args.checkDouble(2);
        TileEntity te = Compat.getTileStandard(this.field_145850_b, this.targetX + x, this.targetY, this.targetZ + y);
        if (te instanceof TileEntityRBMKControlManual) {
            TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
            rod.startingLevel = rod.level;
            new_level = Math.min(1.0, Math.max(0.0, new_level));
            rod.setTarget(new_level);
            te.func_70296_d();
            return new Object[0];
        }
        return new Object[]{"No control rod found at " + (x + 7) + "," + (7 - y)};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setColorLevel(Context context, Arguments args) {
        int color = args.checkInteger(0);
        double new_level = args.checkDouble(1);
        boolean foundRods = false;
        if (color >= 0 && color <= 4) {
            for (int i = -7; i <= 7; ++i) {
                for (int j = -7; j <= 7; ++j) {
                    TileEntity te = Compat.getTileStandard(this.field_145850_b, this.targetX + i, this.targetY, this.targetZ + j);
                    if (!(te instanceof TileEntityRBMKControlManual)) continue;
                    TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                    if (rod.color != TileEntityRBMKControlManual.RBMKColor.values()[color]) continue;
                    rod.startingLevel = rod.level;
                    new_level = Math.min(1.0, Math.max(0.0, new_level));
                    rod.setTarget(new_level);
                    te.func_70296_d();
                    foundRods = true;
                }
            }
            if (foundRods) {
                return new Object[0];
            }
            return new Object[]{"No rods for color " + color + " found"};
        }
        return new Object[]{"Color " + color + " does not exist"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setColor(Context context, Arguments args) {
        int x = args.checkInteger(0) - 7;
        int y = -args.checkInteger(1) + 7;
        int new_color = args.checkInteger(2);
        if (new_color >= 0 && new_color <= 4) {
            TileEntity te = Compat.getTileStandard(this.field_145850_b, this.targetX + x, this.targetY, this.targetZ + y);
            if (te instanceof TileEntityRBMKControlManual) {
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.color = TileEntityRBMKControlManual.RBMKColor.values()[new_color];
                te.func_70296_d();
                return new Object[0];
            }
            return new Object[]{"No control rod found at " + (x + 7) + "," + (7 - y)};
        }
        return new Object[]{"Color " + new_color + " does not exist"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] pressAZ5(Context context, Arguments args) {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.shutdown", 1.0f, 1.0f);
        boolean hasRods = false;
        for (int i = -7; i <= 7; ++i) {
            for (int j = -7; j <= 7; ++j) {
                TileEntity te = Compat.getTileStandard(this.field_145850_b, this.targetX + i, this.targetY, this.targetZ + j);
                if (!(te instanceof TileEntityRBMKControlManual)) continue;
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.startingLevel = rod.level;
                rod.setTarget(0.0);
                te.func_70296_d();
                hasRods = true;
            }
        }
        if (hasRods) {
            return new Object[0];
        }
        return new Object[]{"No control rods found"};
    }

    public static enum ScreenType {
        NONE(0),
        COL_TEMP(18),
        ROD_EXTRACTION(36),
        FUEL_DEPLETION(54),
        FUEL_POISON(72),
        FUEL_TEMP(90);

        public int offset;

        private ScreenType(int offset) {
            this.offset = offset;
        }
    }

    public class RBMKScreen {
        public ScreenType type = ScreenType.NONE;
        public Integer[] columns = new Integer[0];
        public String display = null;

        public RBMKScreen() {
        }

        public RBMKScreen(ScreenType type, Integer[] columns, String display) {
            this.type = type;
            this.columns = columns;
            this.display = display;
        }
    }

    public static enum ColumnType {
        BLANK(0),
        FUEL(10),
        FUEL_SIM(90),
        CONTROL(20),
        CONTROL_AUTO(30),
        BOILER(40),
        MODERATOR(50),
        ABSORBER(60),
        REFLECTOR(70),
        OUTGASSER(80),
        BREEDER(100),
        STORAGE(110),
        COOLER(120),
        HEATEX(130);

        public int offset;

        private ColumnType(int offset) {
            this.offset = offset;
        }
    }

    public static class RBMKColumn {
        public ColumnType type;
        public NBTTagCompound data;

        public RBMKColumn(ColumnType type) {
            this.type = type;
        }

        public RBMKColumn(ColumnType type, NBTTagCompound data) {
            this.type = type;
            this.data = data != null ? data : new NBTTagCompound();
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getFancyStats() {
            if (this.data == null) {
                return null;
            }
            ArrayList<String> stats = new ArrayList<String>();
            stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.heat", (double)((int)(this.data.func_74769_h("heat") * 10.0)) / 10.0 + "\u00b0C"));
            switch (this.type) {
                case FUEL: 
                case FUEL_SIM: {
                    stats.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("rbmk.rod.depletion", (double)((int)((1.0 - this.data.func_74769_h("enrichment")) * 100000.0)) / 1000.0 + "%"));
                    stats.add(EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("rbmk.rod.xenon", (double)((int)(this.data.func_74769_h("xenon") * 1000.0)) / 1000.0 + "%"));
                    stats.add(EnumChatFormatting.DARK_RED + I18nUtil.resolveKey("rbmk.rod.coreTemp", (double)((int)(this.data.func_74769_h("c_coreHeat") * 10.0)) / 10.0 + "\u00b0C"));
                    stats.add(EnumChatFormatting.RED + I18nUtil.resolveKey("rbmk.rod.skinTemp", (double)((int)(this.data.func_74769_h("c_heat") * 10.0)) / 10.0 + "\u00b0C", (double)((int)(this.data.func_74769_h("c_maxHeat") * 10.0)) / 10.0 + "\u00b0C"));
                    break;
                }
                case BOILER: {
                    stats.add(EnumChatFormatting.BLUE + I18nUtil.resolveKey("rbmk.boiler.water", this.data.func_74762_e("water"), this.data.func_74762_e("maxWater")));
                    stats.add(EnumChatFormatting.WHITE + I18nUtil.resolveKey("rbmk.boiler.steam", this.data.func_74762_e("steam"), this.data.func_74762_e("maxSteam")));
                    stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.boiler.type", Fluids.fromID(this.data.func_74765_d("type")).getLocalizedName()));
                    break;
                }
                case CONTROL: {
                    short col;
                    if (this.data.func_74764_b("color") && (col = this.data.func_74765_d("color")) >= 0 && col < TileEntityRBMKControlManual.RBMKColor.values().length) {
                        stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.control." + TileEntityRBMKControlManual.RBMKColor.values()[col].name().toLowerCase(Locale.US), new Object[0]));
                    }
                }
                case CONTROL_AUTO: {
                    stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.control.level", (int)(this.data.func_74769_h("level") * 100.0) + "%"));
                    break;
                }
                case HEATEX: {
                    stats.add(EnumChatFormatting.BLUE + Fluids.fromID(this.data.func_74765_d("type")).getLocalizedName() + " " + this.data.func_74762_e("water") + "/" + this.data.func_74762_e("maxWater") + "mB");
                    stats.add(EnumChatFormatting.RED + Fluids.fromID(this.data.func_74765_d("hottype")).getLocalizedName() + " " + this.data.func_74762_e("steam") + "/" + this.data.func_74762_e("maxSteam") + "mB");
                }
            }
            if (this.data.func_74767_n("moderated")) {
                stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.moderated", new Object[0]));
            }
            return stats;
        }
    }
}

