/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.conveyor.IConveyorBelt;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBedrockOreTE;
import com.hbm.blocks.generic.BlockDepth;
import com.hbm.blocks.network.CraneInserter;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineExcavator;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineExcavator;
import com.hbm.inventory.recipes.ShredderRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemDrillbit;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.items.special.ItemBedrockOreBase;
import com.hbm.lib.Library;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Compat;
import com.hbm.util.EnumUtil;
import com.hbm.util.InventoryUtil;
import com.hbm.util.ItemStackUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineExcavator
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardReceiver,
IControlReceiver,
IGUIProvider,
IUpgradeInfoProvider,
IFluidCopiable {
    public static final long maxPower = 1000000L;
    public long power;
    public boolean operational = false;
    public boolean enableDrill = false;
    public boolean enableCrusher = false;
    public boolean enableWalling = false;
    public boolean enableVeinMiner = false;
    public boolean enableSilkTouch = false;
    protected int ticksWorked = 0;
    protected int targetDepth = 0;
    protected boolean bedrockDrilling = false;
    public float drillRotation = 0.0f;
    public float prevDrillRotation = 0.0f;
    public float drillExtension = 0.0f;
    public float prevDrillExtension = 0.0f;
    public float crusherRotation = 0.0f;
    public float prevCrusherRotation = 0.0f;
    public int chuteTimer = 0;
    public double speed = 1.0;
    public final long baseConsumption = 10000L;
    public long consumption = 10000L;
    public FluidTank tank;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    private HashSet<BlockPos> recursionBrake = new HashSet();
    private int minX = 0;
    private int minY = 0;
    private int minZ = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int maxZ = 0;
    AxisAlignedBB bb = null;

    public TileEntityMachineExcavator() {
        super(14);
        this.tank = new FluidTank(Fluids.NONE, 16000);
    }

    @Override
    public String getName() {
        return "container.machineExcavator";
    }

    @Override
    public void func_145845_h() {
        this.upgradeManager.checkSlots(this, this.slots, 2, 3);
        int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
        int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
        this.consumption = 10000L * (long)(1 + speedLevel);
        this.consumption /= (long)(1 + powerLevel);
        if (!this.field_145850_b.field_72995_K) {
            this.tank.setType(1, this.slots);
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.tryEjectBuffer();
                for (DirPos pos : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            if (this.chuteTimer > 0) {
                --this.chuteTimer;
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.getPower(), this.getMaxPower());
            this.operational = false;
            int radiusLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.EFFECT);
            ItemDrillbit.EnumDrillType type = this.getInstalledDrill();
            if (this.enableDrill && type != null && this.power >= this.getPowerConsumption()) {
                this.operational = true;
                this.power -= this.getPowerConsumption();
                this.speed = type.speed;
                this.speed *= 1.0 + (double)speedLevel / 2.0;
                int maxDepth = this.field_145848_d - 4;
                if ((this.bedrockDrilling || this.targetDepth <= maxDepth) && this.tryDrill(1 + radiusLevel * 2)) {
                    ++this.targetDepth;
                    if (this.targetDepth > maxDepth) {
                        this.enableDrill = false;
                    }
                }
            } else {
                this.targetDepth = 0;
            }
            this.networkPackNT(150);
        } else {
            this.prevDrillExtension = this.drillExtension;
            if (this.drillExtension != (float)this.targetDepth) {
                float speed;
                float diff = Math.abs(this.drillExtension - (float)this.targetDepth);
                if (diff <= (speed = Math.max(0.15f, diff / 10.0f))) {
                    this.drillExtension = this.targetDepth;
                } else {
                    float sig = Math.signum(this.drillExtension - (float)this.targetDepth);
                    this.drillExtension -= sig * speed;
                }
            }
            this.prevDrillRotation = this.drillRotation;
            this.prevCrusherRotation = this.crusherRotation;
            if (this.operational) {
                this.drillRotation += 15.0f;
                if (this.enableCrusher) {
                    this.crusherRotation += 15.0f;
                }
            }
            if (this.drillRotation >= 360.0f) {
                this.drillRotation -= 360.0f;
                this.prevDrillRotation -= 360.0f;
            }
            if (this.crusherRotation >= 360.0f) {
                this.crusherRotation -= 360.0f;
                this.prevCrusherRotation -= 360.0f;
            }
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX * 4 - rot.offsetX, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ * 4 - rot.offsetZ, dir), new DirPos(this.field_145851_c + rot.offsetX * 4, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * 4, rot), new DirPos(this.field_145851_c - rot.offsetX * 4, this.field_145848_d + 1, this.field_145849_e - rot.offsetZ * 4, rot.getOpposite())};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.enableDrill);
        buf.writeBoolean(this.enableCrusher);
        buf.writeBoolean(this.enableWalling);
        buf.writeBoolean(this.enableVeinMiner);
        buf.writeBoolean(this.enableSilkTouch);
        buf.writeBoolean(this.operational);
        buf.writeInt(this.targetDepth);
        buf.writeInt(this.chuteTimer);
        buf.writeLong(this.power);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.enableDrill = buf.readBoolean();
        this.enableCrusher = buf.readBoolean();
        this.enableWalling = buf.readBoolean();
        this.enableVeinMiner = buf.readBoolean();
        this.enableSilkTouch = buf.readBoolean();
        this.operational = buf.readBoolean();
        this.targetDepth = buf.readInt();
        this.chuteTimer = buf.readInt();
        this.power = buf.readLong();
        this.tank.deserialize(buf);
    }

    protected int getY() {
        return this.field_145848_d - this.targetDepth - 4;
    }

    protected boolean tryDrill(int radius) {
        int y = this.getY();
        if (this.targetDepth == 0 || y == 0) {
            radius = 1;
        }
        for (int ring = 1; ring <= radius; ++ring) {
            boolean ignoreAll = true;
            float combinedHardness = 0.0f;
            BlockPos bedrockOre = null;
            this.bedrockDrilling = false;
            block1: for (int x = this.field_145851_c - ring; x <= this.field_145851_c + ring; ++x) {
                for (int z = this.field_145849_e - ring; z <= this.field_145849_e + ring; ++z) {
                    if (ring != 1 && x != this.field_145851_c - ring && x != this.field_145851_c + ring && z != this.field_145849_e - ring && z != this.field_145849_e + ring) continue;
                    Block b = this.field_145850_b.func_147439_a(x, y, z);
                    if (b == ModBlocks.ore_bedrock) {
                        combinedHardness = 6000.0f;
                        bedrockOre = new BlockPos(x, y, z);
                        this.bedrockDrilling = true;
                        this.enableCrusher = false;
                        ignoreAll = false;
                        continue block1;
                    }
                    if (b instanceof BlockDepth) {
                        this.enableDrill = false;
                    }
                    if (this.shouldIgnoreBlock(b, x, y, z)) continue;
                    ignoreAll = false;
                    combinedHardness += b.func_149712_f(this.field_145850_b, x, y, z);
                }
            }
            if (!ignoreAll) {
                ++this.ticksWorked;
                int ticksToWork = (int)Math.ceil((double)combinedHardness / this.speed);
                if (this.ticksWorked >= ticksToWork) {
                    if (bedrockOre == null) {
                        this.breakBlocks(ring);
                        this.buildWall(ring + 1, ring == radius && this.enableWalling);
                        if (ring == radius) {
                            this.mineOuterOres(ring + 1);
                        }
                        this.tryCollect(radius + 1);
                    } else {
                        this.collectBedrock(bedrockOre);
                    }
                    this.ticksWorked = 0;
                }
                return false;
            }
            this.tryCollect(radius + 1);
        }
        this.buildWall(radius + 1, this.enableWalling);
        this.ticksWorked = 0;
        return true;
    }

    protected void collectBedrock(BlockPos pos) {
        TileEntity oreTile = Compat.getTileStandard(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ());
        if (oreTile instanceof BlockBedrockOreTE.TileEntityBedrockOre) {
            int i;
            BlockBedrockOreTE.TileEntityBedrockOre ore = (BlockBedrockOreTE.TileEntityBedrockOre)oreTile;
            if (ore.resource == null) {
                return;
            }
            if (ore.tier > this.getInstalledDrill().tier) {
                return;
            }
            if (ore.acidRequirement != null) {
                if (ore.acidRequirement.type != this.tank.getTankType() || ore.acidRequirement.fill > this.tank.getFill()) {
                    return;
                }
                this.tank.setFill(this.tank.getFill() - ore.acidRequirement.fill);
            }
            ItemStack stack = ore.resource.func_77946_l();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            stacks.add(stack);
            if (stack.func_77973_b() == ModItems.bedrock_ore_base) {
                ItemBedrockOreBase.setOreAmount(stack, pos.getX(), pos.getZ(), 1.0 + (double)this.getInstalledDrill().fortune * 0.1);
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            int x = this.field_145851_c + dir.offsetX * 4;
            int y = this.field_145848_d - 3;
            int z = this.field_145849_e + dir.offsetZ * 4;
            TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
            if (tile instanceof IInventory) {
                this.supplyContainer((IInventory)tile, stacks, dir.getOpposite());
            }
            if (stack.field_77994_a <= 0) {
                return;
            }
            Block b = this.field_145850_b.func_147439_a(x, y, z);
            if (b instanceof IConveyorBelt) {
                this.supplyConveyor((IConveyorBelt)b, stacks, x, y, z);
            }
            if (stack.field_77994_a <= 0) {
                return;
            }
            for (i = 5; i < 14; ++i) {
                if (this.slots[i] == null || this.slots[i].field_77994_a >= this.slots[i].func_77976_d() || !stack.func_77969_a(this.slots[i]) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.slots[i])) continue;
                int toAdd = Math.min(this.slots[i].func_77976_d() - this.slots[i].field_77994_a, stack.field_77994_a);
                this.slots[i].field_77994_a += toAdd;
                stack.field_77994_a -= toAdd;
                this.chuteTimer = 40;
                if (stack.field_77994_a > 0) continue;
                return;
            }
            for (i = 5; i < 14; ++i) {
                if (this.slots[i] != null) continue;
                this.chuteTimer = 40;
                this.slots[i] = stack.func_77946_l();
                return;
            }
        }
    }

    protected void breakBlocks(int ring) {
        int y = this.getY();
        for (int x = this.field_145851_c - ring; x <= this.field_145851_c + ring; ++x) {
            for (int z = this.field_145849_e - ring; z <= this.field_145849_e + ring; ++z) {
                Block b;
                if (ring != 1 && x != this.field_145851_c - ring && x != this.field_145851_c + ring && z != this.field_145849_e - ring && z != this.field_145849_e + ring || this.shouldIgnoreBlock(b = this.field_145850_b.func_147439_a(x, y, z), x, y, z)) continue;
                this.tryMineAtLocation(x, y, z);
            }
        }
    }

    public void tryMineAtLocation(int x, int y, int z) {
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        if (this.enableVeinMiner && this.getInstalledDrill().vein && this.isOre(x, y, z, b)) {
            this.minX = x;
            this.minY = y;
            this.minZ = z;
            this.maxX = x;
            this.maxY = y;
            this.maxZ = z;
            this.breakRecursively(x, y, z, 10);
            this.recursionBrake.clear();
            List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1)));
            for (EntityItem item : items) {
                item.func_70107_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            }
            return;
        }
        this.breakSingleBlock(b, x, y, z);
    }

    protected boolean isOre(int x, int y, int z, Block b) {
        Item blockItem = Item.func_150898_a((Block)b);
        if (blockItem != null) {
            List<String> names = ItemStackUtil.getOreDictNames(new ItemStack(blockItem));
            for (String name : names) {
                if (!name.startsWith("ore")) continue;
                return true;
            }
        }
        return false;
    }

    protected void breakRecursively(int x, int y, int z, int depth) {
        if (depth < 0) {
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (this.recursionBrake.contains(pos)) {
            return;
        }
        this.recursionBrake.add(pos);
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int ix = x + dir.offsetX;
            int iy = y + dir.offsetY;
            int iz = z + dir.offsetZ;
            if (this.field_145850_b.func_147439_a(ix, iy, iz) != b) continue;
            this.breakRecursively(ix, iy, iz, depth - 1);
        }
        this.breakSingleBlock(b, x, y, z);
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        if (this.enableWalling) {
            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.barricade);
        }
    }

    protected void breakSingleBlock(Block b, int x, int y, int z) {
        ArrayList<ItemStack> items = b.getDrops(this.field_145850_b, x, y, z, this.field_145850_b.func_72805_g(x, y, z), this.getFortuneLevel());
        if (this.canSilkTouch()) {
            try {
                Method createStackedBlock = ReflectionHelper.findMethod(Block.class, (Object)b, (String[])new String[]{"createStackedBlock", "func_149644_j"}, (Class[])new Class[]{Integer.TYPE});
                ItemStack result = (ItemStack)createStackedBlock.invoke((Object)b, this.field_145850_b.func_72805_g(x, y, z));
                if (result != null) {
                    items.clear();
                    items.add(result.func_77946_l());
                }
            }
            catch (Exception createStackedBlock) {
                // empty catch block
            }
        }
        if (this.enableCrusher) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack stack : items) {
                ItemStack crushed = ShredderRecipes.getShredderResult(stack).func_77946_l();
                if (crushed.func_77973_b() == ModItems.scrap || crushed.func_77973_b() == ModItems.dust) {
                    list.add(stack);
                    continue;
                }
                crushed.field_77994_a *= stack.field_77994_a;
                list.add(crushed);
            }
            items = list;
        }
        if (b == ModBlocks.barricade) {
            items.clear();
        }
        for (ItemStack item : items) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, item));
        }
        this.field_145850_b.func_147480_a(x, y, z, false);
    }

    protected void buildWall(int ring, boolean wallEverything) {
        int y = this.getY();
        for (int x = this.field_145851_c - ring; x <= this.field_145851_c + ring; ++x) {
            for (int z = this.field_145849_e - ring; z <= this.field_145849_e + ring; ++z) {
                Block b = this.field_145850_b.func_147439_a(x, y, z);
                if (x == this.field_145851_c - ring || x == this.field_145851_c + ring || z == this.field_145849_e - ring || z == this.field_145849_e + ring) {
                    if (!b.isReplaceable((IBlockAccess)this.field_145850_b, x, y, z) || !wallEverything && !b.func_149688_o().func_76224_d()) continue;
                    this.field_145850_b.func_147449_b(x, y, z, ModBlocks.barricade);
                    continue;
                }
                if (!b.func_149688_o().func_76224_d()) continue;
                this.field_145850_b.func_147468_f(x, y, z);
            }
        }
    }

    protected void mineOuterOres(int ring) {
        int y = this.getY();
        for (int x = this.field_145851_c - ring; x <= this.field_145851_c + ring; ++x) {
            for (int z = this.field_145849_e - ring; z <= this.field_145849_e + ring; ++z) {
                Block b;
                if (ring != 1 && x != this.field_145851_c - ring && x != this.field_145851_c + ring && z != this.field_145849_e - ring && z != this.field_145849_e + ring || this.shouldIgnoreBlock(b = this.field_145850_b.func_147439_a(x, y, z), x, y, z) || !this.isOre(x, y, z, b)) continue;
                this.tryMineAtLocation(x, y, z);
            }
        }
    }

    protected void tryEjectBuffer() {
        Block b;
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        int x = this.field_145851_c + dir.offsetX * 4;
        int y = this.field_145848_d - 3;
        int z = this.field_145849_e + dir.offsetZ * 4;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i2 = 5; i2 < 14; ++i2) {
            ItemStack stack = this.slots[i2];
            if (stack == null) continue;
            items.add(stack.func_77946_l());
        }
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            this.supplyContainer((IInventory)tile, items, dir.getOpposite());
        }
        if ((b = this.field_145850_b.func_147439_a(x, y, z)) instanceof IConveyorBelt) {
            this.supplyConveyor((IConveyorBelt)b, items, x, y, z);
        }
        items.removeIf(i -> i == null || i.field_77994_a <= 0);
        for (int i3 = 5; i3 < 14; ++i3) {
            int index = i3 - 5;
            this.slots[i3] = items.size() > index ? ((ItemStack)items.get(index)).func_77946_l() : null;
        }
    }

    protected void tryCollect(int radius) {
        Block b;
        int yLevel = this.getY();
        List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - radius), (double)(yLevel - 1), (double)(this.field_145849_e - radius), (double)(this.field_145851_c + radius + 1), (double)(yLevel + 2), (double)(this.field_145849_e + radius + 1)));
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        int x = this.field_145851_c + dir.offsetX * 4;
        int y = this.field_145848_d - 3;
        int z = this.field_145849_e + dir.offsetZ * 4;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        items.forEach(i -> {
            if (!i.field_70128_L) {
                stacks.add(i.func_92059_d());
            }
        });
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            this.supplyContainer((IInventory)tile, stacks, dir.getOpposite());
        }
        if ((b = this.field_145850_b.func_147439_a(x, y, z)) instanceof IConveyorBelt) {
            this.supplyConveyor((IConveyorBelt)b, stacks, x, y, z);
        }
        items.removeIf(i -> i.field_70128_L || i.func_92059_d().field_77994_a <= 0);
        block0: for (EntityItem item : items) {
            int i2;
            if (item.field_70128_L) continue;
            ItemStack stack = item.func_92059_d();
            for (i2 = 5; i2 < 14; ++i2) {
                if (this.slots[i2] == null || this.slots[i2].field_77994_a >= this.slots[i2].func_77976_d() || !stack.func_77969_a(this.slots[i2]) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.slots[i2])) continue;
                int toAdd = Math.min(this.slots[i2].func_77976_d() - this.slots[i2].field_77994_a, stack.field_77994_a);
                this.slots[i2].field_77994_a += toAdd;
                stack.field_77994_a -= toAdd;
                this.chuteTimer = 40;
                if (stack.field_77994_a > 0) continue;
                item.func_70106_y();
                item.field_145804_b = 60;
                continue block0;
            }
            for (i2 = 5; i2 < 14; ++i2) {
                if (this.slots[i2] != null) continue;
                this.chuteTimer = 40;
                this.slots[i2] = stack.func_77946_l();
                item.func_70106_y();
                item.field_145804_b = 60;
                continue block0;
            }
        }
    }

    protected void supplyContainer(IInventory inv, List<ItemStack> items, ForgeDirection dir) {
        int side = dir.ordinal();
        int[] access = null;
        if (inv instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inv;
            access = InventoryUtil.masquerade(sided, dir.ordinal());
        }
        for (ItemStack item : items) {
            if (item.field_77994_a <= 0) continue;
            CraneInserter.addToInventory(inv, access, item, side);
            this.chuteTimer = 40;
        }
    }

    protected void supplyConveyor(IConveyorBelt belt, List<ItemStack> items, int x, int y, int z) {
        Random rand = this.field_145850_b.field_73012_v;
        for (ItemStack item : items) {
            if (item.field_77994_a <= 0) continue;
            Vec3 base = Vec3.func_72443_a((double)((double)x + rand.nextDouble()), (double)((double)y + 0.5), (double)((double)z + rand.nextDouble()));
            Vec3 vec = belt.getClosestSnappingPosition(this.field_145850_b, x, y, z, base);
            EntityMovingItem moving = new EntityMovingItem(this.field_145850_b);
            moving.func_70107_b(base.field_72450_a, vec.field_72448_b, base.field_72449_c);
            moving.setItemStack(item.func_77946_l());
            this.field_145850_b.func_72838_d((Entity)moving);
            item.field_77994_a = 0;
            this.chuteTimer = 40;
        }
    }

    public long getPowerConsumption() {
        return this.consumption;
    }

    public int getFortuneLevel() {
        ItemDrillbit.EnumDrillType type = this.getInstalledDrill();
        if (type != null) {
            return type.fortune;
        }
        return 0;
    }

    public boolean shouldIgnoreBlock(Block block, int x, int y, int z) {
        return block.isAir((IBlockAccess)this.field_145850_b, x, y, z) || block.func_149688_o() == ModBlocks.materialGas || block.func_149712_f(this.field_145850_b, x, y, z) < 0.0f || block.func_149688_o().func_76224_d() || block == Blocks.field_150357_h;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("drill")) {
            boolean bl = this.enableDrill = !this.enableDrill;
        }
        if (data.func_74764_b("crusher")) {
            boolean bl = this.enableCrusher = !this.enableCrusher;
        }
        if (data.func_74764_b("walling")) {
            boolean bl = this.enableWalling = !this.enableWalling;
        }
        if (data.func_74764_b("veinminer")) {
            boolean bl = this.enableVeinMiner = !this.enableVeinMiner;
        }
        if (data.func_74764_b("silktouch")) {
            this.enableSilkTouch = !this.enableSilkTouch;
        }
        this.markChanged();
    }

    public ItemDrillbit.EnumDrillType getInstalledDrill() {
        if (this.slots[4] != null && this.slots[4].func_77973_b() instanceof ItemDrillbit) {
            return (ItemDrillbit.EnumDrillType)((Object)EnumUtil.grabEnumSafely(ItemDrillbit.EnumDrillType.class, this.slots[4].func_77960_j()));
        }
        return null;
    }

    public boolean canVeinMine() {
        ItemDrillbit.EnumDrillType type = this.getInstalledDrill();
        return this.enableVeinMiner && type != null && type.vein;
    }

    public boolean canSilkTouch() {
        ItemDrillbit.EnumDrillType type = this.getInstalledDrill();
        return this.enableSilkTouch && type != null && type.silk;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.enableDrill = nbt.func_74767_n("d");
        this.enableCrusher = nbt.func_74767_n("c");
        this.enableWalling = nbt.func_74767_n("w");
        this.enableVeinMiner = nbt.func_74767_n("v");
        this.enableSilkTouch = nbt.func_74767_n("s");
        this.targetDepth = nbt.func_74762_e("t");
        this.power = nbt.func_74763_f("p");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("d", this.enableDrill);
        nbt.func_74757_a("c", this.enableCrusher);
        nbt.func_74757_a("w", this.enableWalling);
        nbt.func_74757_a("v", this.enableVeinMiner);
        nbt.func_74757_a("s", this.enableSilkTouch);
        nbt.func_74768_a("t", this.targetDepth);
        nbt.func_74772_a("p", this.power);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineExcavator(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineExcavator(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)0.0, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_excavator));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + (100 - 200 / (level + 2)) + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 100 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + (100 - 100 / (level + 1)) + "%"));
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.EFFECT, 3);
        return upgrades;
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tank;
    }
}

