/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.inventory.recipes.PressRecipes;
import com.hbm.items.machine.ItemStamp;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityConveyorPress
extends TileEntityMachineBase
implements IEnergyReceiverMK2 {
    public int usage = 100;
    public long power = 0L;
    public static final long maxPower = 50000L;
    public double speed = 0.125;
    public double press;
    public double renderPress;
    public double lastPress;
    private double syncPress;
    private int turnProgress;
    protected boolean isRetracting = false;
    private int delay;
    public ItemStack syncStack;
    AxisAlignedBB bb = null;

    public TileEntityConveyorPress() {
        super(1);
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            if (this.delay <= 0) {
                if (this.isRetracting) {
                    if (this.canRetract()) {
                        this.press -= this.speed;
                        this.power -= (long)this.usage;
                        if (this.press <= 0.0) {
                            this.press = 0.0;
                            this.isRetracting = false;
                            this.delay = 0;
                        }
                    }
                } else if (this.canExtend()) {
                    this.press += this.speed;
                    this.power -= (long)this.usage;
                    if (this.press >= 1.0) {
                        this.press = 1.0;
                        this.isRetracting = true;
                        this.delay = 5;
                        this.process();
                    }
                }
            } else {
                --this.delay;
            }
            this.networkPackNT(50);
        } else {
            this.lastPress = this.renderPress;
            if (this.turnProgress > 0) {
                this.renderPress += (this.syncPress - this.renderPress) / (double)this.turnProgress;
                --this.turnProgress;
            } else {
                this.renderPress = this.syncPress;
            }
        }
    }

    protected void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z)};
    }

    public boolean canExtend() {
        if (this.power < (long)this.usage) {
            return false;
        }
        if (this.slots[0] == null) {
            return false;
        }
        List items = this.field_145850_b.func_72872_a(EntityMovingItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 1.5), (double)(this.field_145849_e + 1)));
        if (items.isEmpty()) {
            return false;
        }
        for (EntityMovingItem item : items) {
            ItemStack stack = item.getItemStack();
            if (PressRecipes.getOutput(stack, this.slots[0]) == null || stack.field_77994_a != 1) continue;
            double d0 = 0.35;
            double d1 = 0.65;
            if (item.field_70165_t > (double)this.field_145851_c + d0 && item.field_70165_t < (double)this.field_145851_c + d1 && item.field_70161_v > (double)this.field_145849_e + d0 && item.field_70161_v < (double)this.field_145849_e + d1) {
                item.func_70107_b((double)this.field_145851_c + 0.5, item.field_70163_u, (double)this.field_145849_e + 0.5);
            }
            return true;
        }
        return false;
    }

    public void process() {
        List items = this.field_145850_b.func_72872_a(EntityMovingItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 1.5), (double)(this.field_145849_e + 1)));
        for (EntityMovingItem item : items) {
            ItemStack stack = item.getItemStack();
            ItemStack output = PressRecipes.getOutput(stack, this.slots[0]);
            if (output == null || stack.field_77994_a != 1) continue;
            item.func_70106_y();
            EntityMovingItem out = new EntityMovingItem(this.field_145850_b);
            out.func_70107_b(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            out.setItemStack(output.func_77946_l());
            this.field_145850_b.func_72838_d((Entity)out);
        }
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.pressOperate", this.getVolume(1.5f), 1.0f);
        if (this.slots[0].func_77958_k() != 0) {
            this.slots[0].func_77964_b(this.slots[0].func_77960_j() + 1);
            if (this.slots[0].func_77960_j() >= this.slots[0].func_77958_k()) {
                this.slots[0] = null;
            }
        }
    }

    public boolean canRetract() {
        return this.power >= (long)this.usage;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeDouble(this.press);
        BufferUtil.writeItemStack(buf, this.slots[0]);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.syncPress = buf.readDouble();
        this.syncStack = BufferUtil.readItemStack(buf);
        this.turnProgress = 2;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemStamp;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.press = nbt.func_74769_h("press");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74780_a("press", this.press);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

