/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.config.ClientConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public abstract class ItemRenderWeaponBase
implements IItemRenderer {
    public static final ResourceLocation flash_plume = new ResourceLocation("hbm", "textures/models/weapons/lilmac_plume.png");
    public static final ResourceLocation laser_flash = new ResourceLocation("hbm", "textures/models/weapons/laser_flash.png");
    public static float interp;
    public static HashMap<EntityLivingBase, Long> flashMap;

    public boolean isAkimbo() {
        return false;
    }

    public boolean isLeftHanded() {
        return false;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glEnable((int)2884);
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                this.setupFirstPerson(item);
                this.renderFirstPerson(item);
                break;
            }
            case EQUIPPED: {
                if (this.isLeftHanded()) break;
                this.setupThirdPerson(item);
                this.renderEquipped(item, data);
                break;
            }
            case INVENTORY: {
                this.setupInv(item);
                this.renderInv(item);
                break;
            }
            case ENTITY: {
                this.setupEntity(item);
                this.renderEntity(item);
            }
        }
        GL11.glPopMatrix();
    }

    public void renderEquipped(ItemStack stack, Object ... data) {
        this.renderOther(stack, IItemRenderer.ItemRenderType.EQUIPPED, data);
    }

    public void renderEquippedAkimbo(ItemStack stack, EntityLivingBase entity) {
        this.renderOther(stack, IItemRenderer.ItemRenderType.EQUIPPED, new Object[0]);
    }

    public void renderInv(ItemStack stack) {
        this.renderOther(stack, IItemRenderer.ItemRenderType.INVENTORY, new Object[0]);
    }

    public void renderEntity(ItemStack stack) {
        this.renderOther(stack, IItemRenderer.ItemRenderType.ENTITY, new Object[0]);
    }

    public void setPerspectiveAndRender(ItemStack stack, float interp) {
        ItemRenderWeaponBase.interp = interp;
        Minecraft mc = Minecraft.func_71410_x();
        EntityRenderer entityRenderer = mc.field_71460_t;
        float farPlaneDistance = mc.field_71474_y.field_151451_c * 16;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        Project.gluPerspective((float)this.getFOVModifier(interp, ClientConfig.GUN_MODEL_FOV.get()), (float)((float)mc.field_71443_c / (float)mc.field_71440_d), (float)0.05f, (float)(farPlaneDistance * 2.0f));
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glPushMatrix();
        if (!(mc.field_71474_y.field_74320_O != 0 || mc.field_71451_h.func_70608_bn() || mc.field_71474_y.field_74319_N || mc.field_71442_b.func_78747_a())) {
            entityRenderer.func_78463_b((double)interp);
            this.setupTransformsAndRender(stack);
            entityRenderer.func_78483_a((double)interp);
        }
        GL11.glPopMatrix();
        if (mc.field_71474_y.field_74320_O == 0 && !mc.field_71451_h.func_70608_bn()) {
            entityRenderer.field_78516_c.func_78447_b(interp);
        }
    }

    private float getFOVModifier(float interp, boolean useFOVSetting) {
        Block block;
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase entityplayer = mc.field_71451_h;
        float fov = this.getBaseFOV(entityplayer.func_70694_bm());
        if (useFOVSetting) {
            fov = mc.field_71474_y.field_74334_X;
        }
        if (entityplayer.func_110143_aJ() <= 0.0f) {
            float f2 = (float)entityplayer.field_70725_aQ + interp;
            fov /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        if ((block = ActiveRenderInfo.func_151460_a((World)mc.field_71441_e, (EntityLivingBase)entityplayer, (float)interp)).func_149688_o() == Material.field_151586_h) {
            fov = fov * 60.0f / 70.0f;
        }
        return fov;
    }

    protected float getBaseFOV(ItemStack stack) {
        return 70.0f;
    }

    public float getViewFOV(ItemStack stack, float fov) {
        return fov;
    }

    protected float getSwayMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 0.1f : 0.5f;
    }

    protected float getSwayPeriod(ItemStack stack) {
        return 0.75f;
    }

    protected float getTurnMagnitude(ItemStack stack) {
        return 2.75f;
    }

    protected void setupTransformsAndRender(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        float swayMagnitude = this.getSwayMagnitude(stack);
        float swayPeriod = this.getSwayPeriod(stack);
        float turnMagnitude = this.getTurnMagnitude(stack);
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * interp;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * interp;
        GL11.glPushMatrix();
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
        EntityPlayerSP entityplayersp = (EntityPlayerSP)player;
        float armPitch = entityplayersp.field_71164_i + (entityplayersp.field_71155_g - entityplayersp.field_71164_i) * interp;
        float armYaw = entityplayersp.field_71163_h + (entityplayersp.field_71154_f - entityplayersp.field_71163_h) * interp;
        GL11.glRotatef((float)((player.field_70125_A - armPitch) * 0.1f * turnMagnitude), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)((player.field_70177_z - armYaw) * 0.1f * turnMagnitude), (float)0.0f, (float)1.0f, (float)0.0f);
        int brightness = mc.field_71441_e.func_72802_i(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v), 0);
        int j = brightness % 65536;
        int k = brightness / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = stack.func_77973_b().func_82790_a(stack, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        if (mc.field_71451_h instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)mc.field_71451_h;
            float distanceDelta = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float distanceInterp = -(entityplayer.field_70140_Q + distanceDelta * interp);
            float camYaw = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * interp;
            float camPitch = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * interp;
            GL11.glTranslatef((float)(MathHelper.func_76126_a((float)(distanceInterp * (float)Math.PI * swayPeriod)) * camYaw * 0.5f * swayMagnitude), (float)(-Math.abs(MathHelper.func_76134_b((float)(distanceInterp * (float)Math.PI * swayPeriod)) * camYaw) * swayMagnitude), (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)(distanceInterp * (float)Math.PI * swayPeriod)) * camYaw * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(Math.abs(MathHelper.func_76134_b((float)(distanceInterp * (float)Math.PI * swayPeriod - 0.2f)) * camYaw) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)camPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.renderItem(IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON, stack, null, player);
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
    }

    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            GL11.glTranslated((double)0.0, (double)-0.484375, (double)0.0);
        } else {
            float offset = 0.8f;
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslatef((float)(1.0f * offset), (float)(-0.75f * offset), (float)(-0.5f * offset));
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        }
    }

    public void setupThirdPerson(ItemStack stack) {
        double scale = 0.125;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotatef((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)12.5f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)3.5, (double)0.0, (double)0.0);
    }

    public void setupThirdPersonAkimbo(ItemStack stack) {
        double scale = 0.125;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotatef((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)12.5f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)5.0, (double)0.0, (double)0.0);
    }

    public void setupInv(ItemStack stack) {
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3008);
        GL11.glScaled((double)1.0, (double)1.0, (double)-1.0);
        GL11.glTranslated((double)8.0, (double)8.0, (double)0.0);
        GL11.glRotated((double)225.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
    }

    public void setupEntity(ItemStack stack) {
        double scale = 0.125;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
    }

    public void setupModTable(ItemStack stack) {
        double scale = -5.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
    }

    public void renderModTable(ItemStack stack, int index) {
        this.renderOther(stack, IItemRenderer.ItemRenderType.INVENTORY, new Object[0]);
    }

    public abstract void renderFirstPerson(ItemStack var1);

    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type, Object ... data) {
    }

    public static void standardAimingTransform(ItemStack stack, double sX, double sY, double sZ, double aX, double aY, double aZ) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        double x = sX + (aX - sX) * (double)aimingProgress;
        double y = sY + (aY - sY) * (double)aimingProgress;
        double z = sZ + (aZ - sZ) * (double)aimingProgress;
        GL11.glTranslated((double)x, (double)y, (double)z);
    }

    public static void renderSmokeNodes(List<ItemGunBaseNT.SmokeNode> nodes, double scale) {
        Tessellator tess = Tessellator.field_78398_a;
        if (nodes.size() > 1) {
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2884);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDepthMask((boolean)false);
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            for (int i = 0; i < nodes.size() - 1; ++i) {
                ItemGunBaseNT.SmokeNode node = nodes.get(i);
                ItemGunBaseNT.SmokeNode past = nodes.get(i + 1);
                tess.func_78369_a(1.0f, 1.0f, 1.0f, (float)node.alpha);
                tess.func_78377_a(node.forward, node.lift, node.side);
                tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
                tess.func_78377_a(node.forward, node.lift, node.side + node.width * scale);
                tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
                tess.func_78377_a(past.forward, past.lift, past.side + past.width * scale);
                tess.func_78369_a(1.0f, 1.0f, 1.0f, (float)past.alpha);
                tess.func_78377_a(past.forward, past.lift, past.side);
                tess.func_78369_a(1.0f, 1.0f, 1.0f, (float)node.alpha);
                tess.func_78377_a(node.forward, node.lift, node.side);
                tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
                tess.func_78377_a(node.forward, node.lift, node.side - node.width * scale);
                tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
                tess.func_78377_a(past.forward, past.lift, past.side - past.width * scale);
                tess.func_78369_a(1.0f, 1.0f, 1.0f, (float)past.alpha);
                tess.func_78377_a(past.forward, past.lift, past.side);
            }
            tess.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glAlphaFunc((int)518, (float)0.1f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
        }
    }

    public static void renderMuzzleFlash(long lastShot) {
        ItemRenderWeaponBase.renderMuzzleFlash(lastShot, 75, 15.0);
    }

    public static void renderMuzzleFlash(long lastShot, int duration, double l) {
        Tessellator tess = Tessellator.field_78398_a;
        int flash = duration;
        if (System.currentTimeMillis() - lastShot < (long)flash) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2884);
            GL11.glPushMatrix();
            double fire = (double)(System.currentTimeMillis() - lastShot) / (double)flash;
            double width = 6.0 * fire;
            double length = l * fire;
            double inset = 2.0;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(flash_plume);
            tess.func_78382_b();
            tess.func_78380_c(240);
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            tess.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
            tess.func_78374_a(0.0, -width, -inset, 1.0, 1.0);
            tess.func_78374_a(0.0, width, -inset, 0.0, 1.0);
            tess.func_78374_a(0.1, width, length - inset, 0.0, 0.0);
            tess.func_78374_a(0.1, -width, length - inset, 1.0, 0.0);
            tess.func_78374_a(0.0, width, inset, 0.0, 1.0);
            tess.func_78374_a(0.0, -width, inset, 1.0, 1.0);
            tess.func_78374_a(0.1, -width, -length + inset, 1.0, 0.0);
            tess.func_78374_a(0.1, width, -length + inset, 0.0, 0.0);
            tess.func_78374_a(0.0, -inset, width, 0.0, 1.0);
            tess.func_78374_a(0.0, -inset, -width, 1.0, 1.0);
            tess.func_78374_a(0.1, length - inset, -width, 1.0, 0.0);
            tess.func_78374_a(0.1, length - inset, width, 0.0, 0.0);
            tess.func_78374_a(0.0, inset, -width, 1.0, 1.0);
            tess.func_78374_a(0.0, inset, width, 0.0, 1.0);
            tess.func_78374_a(0.1, -length + inset, width, 0.0, 0.0);
            tess.func_78374_a(0.1, -length + inset, -width, 1.0, 0.0);
            tess.func_78381_a();
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
        }
    }

    public static void renderGapFlash(long lastShot) {
        Tessellator tess = Tessellator.field_78398_a;
        int flash = 75;
        if (System.currentTimeMillis() - lastShot < (long)flash) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)2884);
            GL11.glPushMatrix();
            double fire = (double)(System.currentTimeMillis() - lastShot) / (double)flash;
            double height = 4.0 * fire;
            double length = 15.0 * fire;
            double lift = 3.0 * fire;
            double offset = 1.0 * fire;
            double lengthOffset = 0.125;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(flash_plume);
            tess.func_78382_b();
            tess.func_78380_c(240);
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            tess.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
            tess.func_78374_a(0.0, -height, -offset, 1.0, 1.0);
            tess.func_78374_a(0.0, height, -offset, 0.0, 1.0);
            tess.func_78374_a(0.0, height + lift, length - offset, 0.0, 0.0);
            tess.func_78374_a(0.0, -height + lift, length - offset, 1.0, 0.0);
            tess.func_78374_a(0.0, height, offset, 0.0, 1.0);
            tess.func_78374_a(0.0, -height, offset, 1.0, 1.0);
            tess.func_78374_a(0.0, -height + lift, -length + offset, 1.0, 0.0);
            tess.func_78374_a(0.0, height + lift, -length + offset, 0.0, 0.0);
            tess.func_78374_a(0.0, -height, -offset, 1.0, 1.0);
            tess.func_78374_a(0.0, height, -offset, 0.0, 1.0);
            tess.func_78374_a(lengthOffset, height, length - offset, 0.0, 0.0);
            tess.func_78374_a(lengthOffset, -height, length - offset, 1.0, 0.0);
            tess.func_78374_a(0.0, height, offset, 0.0, 1.0);
            tess.func_78374_a(0.0, -height, offset, 1.0, 1.0);
            tess.func_78374_a(lengthOffset, -height, -length + offset, 1.0, 0.0);
            tess.func_78374_a(lengthOffset, height, -length + offset, 0.0, 0.0);
            tess.func_78381_a();
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
        }
    }

    public static void renderLaserFlash(long lastShot, int flash, double scale, int color) {
        Tessellator tess = Tessellator.field_78398_a;
        if (System.currentTimeMillis() - lastShot < (long)flash) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2884);
            GL11.glPushMatrix();
            double fire = (double)(System.currentTimeMillis() - lastShot) / (double)flash;
            double size = 4.0 * fire * scale;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(laser_flash);
            tess.func_78382_b();
            tess.func_78380_c(240);
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            tess.func_78384_a(color, 255);
            tess.func_78374_a(0.0, -size, -size, 1.0, 1.0);
            tess.func_78374_a(0.0, size, -size, 0.0, 1.0);
            tess.func_78374_a(0.0, size, size, 0.0, 0.0);
            tess.func_78374_a(0.0, -size, size, 1.0, 0.0);
            tess.func_78381_a();
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
        }
    }

    static {
        flashMap = new HashMap();
    }
}

