/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderHenry
extends ItemRenderWeaponBase {
    public ResourceLocation texture;

    public ItemRenderHenry(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.5f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        float offset = 0.8f;
        ItemRenderHenry.standardAimingTransform(stack, -1.25f * offset, -1.0f * offset, 1.75f * offset, 0.0, -0.625, 1.0);
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        double r = -2.5 * (double)aimingProgress;
        GL11.glRotated((double)r, (double)1.0, (double)0.0, (double)0.0);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        double scale = 0.375;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] sight = HbmAnimations.getRelevantTransformation("SIGHT");
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] hammer = HbmAnimations.getRelevantTransformation("HAMMER");
        double[] lever = HbmAnimations.getRelevantTransformation("LEVER");
        double[] turn = HbmAnimations.getRelevantTransformation("TURN");
        double[] lift = HbmAnimations.getRelevantTransformation("LIFT");
        double[] twist = HbmAnimations.getRelevantTransformation("TWIST");
        double[] bullet = HbmAnimations.getRelevantTransformation("BULLET");
        double[] yeet = HbmAnimations.getRelevantTransformation("YEET");
        double[] roll = HbmAnimations.getRelevantTransformation("ROLL");
        GL11.glShadeModel((int)7425);
        GL11.glTranslated((double)(recoil[0] * 2.0), (double)recoil[1], (double)recoil[2]);
        GL11.glRotated((double)(recoil[2] * 5.0), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)turn[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)yeet[0], (double)yeet[1], (double)yeet[2]);
        GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)roll[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-4.0, (double)4.0);
        GL11.glRotated((double)lift[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)4.0, (double)-4.0);
        GL11.glTranslated((double)0.0, (double)2.0, (double)-4.0);
        GL11.glRotated((double)equip[0], (double)-1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-2.0, (double)4.0);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.0, (double)8.0);
        GL11.glRotated((double)turn[2], (double)0.0, (double)0.0, (double)-1.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        ItemRenderHenry.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)0).smokeNodes, 0.25);
        GL11.glPopMatrix();
        ResourceManager.henry.renderPart("Gun");
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.25, (double)-0.1875);
        GL11.glRotated((double)sight[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.25, (double)0.1875);
        ResourceManager.henry.renderPart("Sight");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.625, (double)-3.0);
        GL11.glRotated((double)(-30.0 + hammer[0]), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.625, (double)3.0);
        ResourceManager.henry.renderPart("Hammer");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.25, (double)-2.3125);
        GL11.glRotated((double)lever[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.25, (double)2.3125);
        ResourceManager.henry.renderPart("Lever");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)twist[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
        ResourceManager.henry.renderPart("Front");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)bullet[0], (double)bullet[1], (double)(bullet[2] - 1.0));
        ResourceManager.henry.renderPart("Bullet");
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.0, (double)8.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(90.0 * gun.shotRand), (double)1.0, (double)0.0, (double)0.0);
        ItemRenderHenry.renderMuzzleFlash(gun.lastShot[0], 75, 5.0);
        GL11.glPopMatrix();
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        double scale = 1.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glTranslated((double)0.0, (double)0.25, (double)3.0);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 1.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)0.5, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -7.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type, Object ... data) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        ResourceManager.henry.renderAll();
        GL11.glShadeModel((int)7424);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            long shot;
            EntityLivingBase ent = (EntityLivingBase)data[1];
            double shotRand = 0.0;
            if (ent == Minecraft.func_71410_x().field_71439_g) {
                ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
                shot = gun.lastShot[0];
                shotRand = gun.shotRand;
            } else {
                shot = ItemRenderWeaponBase.flashMap.getOrDefault(ent, -1L);
                if (shot < 0L) {
                    return;
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)1.0, (double)8.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(90.0 * shotRand), (double)1.0, (double)0.0, (double)0.0);
            ItemRenderHenry.renderMuzzleFlash(shot, 75, 5.0);
            GL11.glPopMatrix();
        }
    }
}

