/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.itempool;

import com.hbm.itempool.ItemPoolsC130;
import com.hbm.itempool.ItemPoolsComponent;
import com.hbm.itempool.ItemPoolsLegacy;
import com.hbm.itempool.ItemPoolsPile;
import com.hbm.itempool.ItemPoolsRedRoom;
import com.hbm.itempool.ItemPoolsSatellite;
import com.hbm.itempool.ItemPoolsSingle;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmChestContents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;

public class ItemPool {
    public static HashMap<String, ItemPool> pools = new HashMap();
    public String name;
    public WeightedRandomChestContent[] pool = new WeightedRandomChestContent[0];
    private List<WeightedRandomChestContent> buildingList = new ArrayList<WeightedRandomChestContent>();
    private static WeightedRandomChestContent[] backupPool = new WeightedRandomChestContent[]{HbmChestContents.weighted(Items.field_151025_P, 0, 1, 3, 10), HbmChestContents.weighted(Items.field_151055_y, 0, 2, 5, 10), HbmChestContents.weighted(ModItems.scrap, 0, 1, 3, 10), HbmChestContents.weighted(ModItems.dust, 0, 2, 5, 5)};

    public static void initialize() {
        ItemPoolsLegacy.init();
        ItemPoolsComponent.init();
        ItemPoolsSingle.init();
        ItemPoolsRedRoom.init();
        ItemPoolsSatellite.init();
        ItemPoolsPile.init();
        ItemPoolsC130.init();
    }

    public ItemPool() {
    }

    public ItemPool(String name) {
        this.name = name;
        pools.put(name, this);
    }

    public ItemPool add(Item item, int meta, int min, int max, int weight) {
        this.buildingList.add(new WeightedRandomChestContent(item, meta, min, max, weight));
        return this;
    }

    public ItemPool add(Block block, int meta, int min, int max, int weight) {
        this.buildingList.add(new WeightedRandomChestContent(Item.func_150898_a((Block)block), meta, min, max, weight));
        return this;
    }

    public ItemPool add(ItemStack item, int min, int max, int weight) {
        this.buildingList.add(new WeightedRandomChestContent(item, min, max, weight));
        return this;
    }

    public ItemPool build() {
        this.pool = new WeightedRandomChestContent[this.buildingList.size()];
        for (int i = 0; i < this.pool.length; ++i) {
            this.pool[i] = this.buildingList.get(i);
        }
        this.buildingList.clear();
        return this;
    }

    public static WeightedRandomChestContent[] getPool(String name) {
        ItemPool pool = pools.get(name);
        if (pool == null) {
            return backupPool;
        }
        return pool.pool;
    }

    public static ItemStack getStack(String pool, Random rand) {
        return ItemPool.getStack(ItemPool.getPool(pool), rand);
    }

    public static ItemStack getStack(WeightedRandomChestContent[] pool, Random rand) {
        WeightedRandomChestContent weighted = (WeightedRandomChestContent)WeightedRandom.func_76274_a((Random)rand, (WeightedRandom.Item[])pool);
        ItemStack stack = weighted.field_76297_b.func_77946_l();
        stack.field_77994_a = weighted.field_76295_d + rand.nextInt(weighted.field_76296_e - weighted.field_76295_d + 1);
        return stack;
    }
}

