/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

@Deprecated
public class ChemplantRecipes
extends SerializableRecipe {
    public static HashMap<Integer, ChemRecipe> indexMapping = new HashMap();
    public static List<ChemRecipe> recipes = new ArrayList<ChemRecipe>();

    @Override
    public void registerDefaults() {
        FluidStack[] fluidStackArray;
        recipes.add(new ChemRecipe(36, "COOLANT", 50).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.WATER, 1800)).outputFluids(new FluidStack(Fluids.COOLANT, 2000)));
        recipes.add(new ChemRecipe(37, "CRYOGEL", 50).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_ice)).inputFluids(new FluidStack(Fluids.COOLANT, 1800)).outputFluids(new FluidStack(Fluids.CRYOGEL, 2000)));
        ChemRecipe chemRecipe = new ChemRecipe(38, "DESH", 300).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_desh_mix));
        if (GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry) {
            FluidStack[] fluidStackArray2 = new FluidStack[1];
            fluidStackArray = fluidStackArray2;
            fluidStackArray2[0] = new FluidStack(Fluids.LIGHTOIL, 200);
        } else {
            FluidStack[] fluidStackArray3 = new FluidStack[2];
            fluidStackArray3[0] = new FluidStack(Fluids.MERCURY, 200);
            fluidStackArray = fluidStackArray3;
            fluidStackArray3[1] = new FluidStack(Fluids.LIGHTOIL, 200);
        }
        recipes.add(chemRecipe.inputFluids(fluidStackArray).outputItems(new ItemStack(ModItems.ingot_desh)));
        recipes.add(new ChemRecipe(39, "NITAN", 50).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_nitan_mix)).inputFluids(new FluidStack(Fluids.KEROSENE, 600), new FluidStack(Fluids.MERCURY, 200)).outputFluids(new FluidStack(Fluids.NITAN, 1000)));
        recipes.add(new ChemRecipe(40, "PEROXIDE", 50).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.PEROXIDE, 800)));
        recipes.add(new ChemRecipe(90, "SULFURIC_ACID", 50).inputItems(new RecipesCommon.OreDictStack(OreDictManager.S.dust())).inputFluids(new FluidStack(Fluids.PEROXIDE, 800), new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.SULFURIC_ACID, 2000)));
        recipes.add(new ChemRecipe(92, "NITRIC_ACID", 50).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.SULFURIC_ACID, 500)).outputFluids(new FluidStack(Fluids.NITRIC_ACID, 1000)));
        recipes.add(new ChemRecipe(93, "SOLVENT", 50).inputFluids(new FluidStack(Fluids.NAPHTHA, 500), new FluidStack(Fluids.AROMATICS, 500)).outputFluids(new FluidStack(Fluids.SOLVENT, 1000)));
        recipes.add(new ChemRecipe(43, "POLYMER", 100).inputItems(new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 2), new RecipesCommon.OreDictStack(OreDictManager.F.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0)).outputItems(new ItemStack(ModItems.ingot_polymer)));
        recipes.add(new ChemRecipe(81, "BAKELITE", 100).inputFluids(new FluidStack(Fluids.AROMATICS, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0), new FluidStack(Fluids.PETROLEUM, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0)).outputItems(new ItemStack(ModItems.ingot_bakelite)));
        recipes.add(new ChemRecipe(82, "RUBBER", 100).inputItems(new RecipesCommon.OreDictStack(OreDictManager.S.dust())).inputFluids(new FluidStack(Fluids.UNSATURATEDS, 500, GeneralConfig.enable528PressurizedRecipes ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_rubber)));
        recipes.add(new ChemRecipe(97, "LAMINATE", 100).inputFluids(new FluidStack(Fluids.XYLENE, 250), new FluidStack(Fluids.PHOSGENE, 250)).inputItems(new RecipesCommon.ComparableStack(ModBlocks.reinforced_glass), new RecipesCommon.OreDictStack(OreDictManager.STEEL.bolt(), 4)).outputItems(new ItemStack(ModBlocks.reinforced_laminate)));
        recipes.add(new ChemRecipe(94, "PC", 100).inputFluids(new FluidStack(Fluids.XYLENE, 500, GeneralConfig.enable528PressurizedRecipes ? 2 : 0), new FluidStack(Fluids.PHOSGENE, 500, GeneralConfig.enable528PressurizedRecipes ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_pc)));
        recipes.add(new ChemRecipe(96, "PVC", 100).inputItems(new RecipesCommon.OreDictStack(OreDictManager.CD.dust())).inputFluids(new FluidStack(Fluids.UNSATURATEDS, 250, GeneralConfig.enable528PressurizedRecipes ? 2 : 0), new FluidStack(Fluids.CHLORINE, 250, GeneralConfig.enable528PressurizedRecipes ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_pvc, 2)));
        recipes.add(new ChemRecipe(89, "DYNAMITE", 50).inputItems(new RecipesCommon.ComparableStack(Items.field_151102_aT), new RecipesCommon.OreDictStack(OreDictManager.KNO.dust()), new RecipesCommon.OreDictStack("sand")).outputItems(new ItemStack(ModItems.ball_dynamite, 2)));
        recipes.add(new ChemRecipe(83, "TNT", 150).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.AROMATICS, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0)).outputItems(new ItemStack(ModItems.ball_tnt, 4)));
        recipes.add(new ChemRecipe(95, "TATB", 50).inputItems(new RecipesCommon.ComparableStack(ModItems.ball_tnt)).inputFluids(new FluidStack(Fluids.SOURGAS, 200, 1), new FluidStack(Fluids.NITRIC_ACID, 10)).outputItems(new ItemStack(ModItems.ball_tatb)));
        recipes.add(new ChemRecipe(84, "C4", 150).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.UNSATURATEDS, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0)).outputItems(new ItemStack(ModItems.ingot_c4, 4)));
        recipes.add(new ChemRecipe(46, "YELLOWCAKE", 250).inputItems(new RecipesCommon.OreDictStack(OreDictManager.U.billet(), 2), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)).inputFluids(new FluidStack(Fluids.PEROXIDE, 500)).outputItems(new ItemStack(ModItems.powder_yellowcake)));
        recipes.add(new ChemRecipe(47, "UF6", 100).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_yellowcake), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 4)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputItems(new ItemStack(ModItems.sulfur, 2)).outputFluids(new FluidStack(Fluids.UF6, 1200)));
        recipes.add(new ChemRecipe(48, "PUF6", 150).inputItems(new RecipesCommon.OreDictStack(OreDictManager.PU.dust()), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 3)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.PUF6, 900)));
        recipes.add(new ChemRecipe(49, "SAS3", 200).inputItems(new RecipesCommon.OreDictStack(OreDictManager.SA326.dust()), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)).inputFluids(new FluidStack(Fluids.PEROXIDE, 2000)).outputFluids(new FluidStack(Fluids.SAS3, 1000)));
        recipes.add(new ChemRecipe(53, "CORDITE", 40).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 2), new RecipesCommon.OreDictStack("plankWood"), new RecipesCommon.ComparableStack(Items.field_151102_aT)).inputFluids(GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry ? new FluidStack(Fluids.HEATINGOIL, 200) : new FluidStack(Fluids.GAS, 200)).outputItems(new ItemStack(ModItems.cordite, 4)));
        recipes.add(new ChemRecipe(54, "KEVLAR", 40).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 2), new RecipesCommon.ComparableStack(Items.field_151118_aC), new RecipesCommon.OreDictStack(OreDictManager.COAL.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 100)).outputItems(new ItemStack(ModItems.plate_kevlar, 4)));
        recipes.add(new ChemRecipe(55, "CONCRETE", 100).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 1), new RecipesCommon.ComparableStack(Blocks.field_150351_n, 8), new RecipesCommon.OreDictStack("sand", 8)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputItems(new ItemStack(ModBlocks.concrete_smooth, 16)));
        recipes.add(new ChemRecipe(56, "CONCRETE_ASBESTOS", 100).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 1), new RecipesCommon.ComparableStack(Blocks.field_150351_n, 2), new RecipesCommon.OreDictStack("sand", 2), GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry ? new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 1) : new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 4)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputItems(new ItemStack(ModBlocks.concrete_asbestos, 16)));
        recipes.add(new ChemRecipe(79, "DUCRETE", 150).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 4), new RecipesCommon.ComparableStack(Blocks.field_150351_n, 2), new RecipesCommon.OreDictStack("sand", 8), new RecipesCommon.OreDictStack(OreDictManager.U238.billet(), 2)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputItems(new ItemStack(ModBlocks.ducrete_smooth, 8)));
        recipes.add(new ChemRecipe(57, "SOLID_FUEL", 200).inputItems(new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)).inputFluids(new FluidStack(Fluids.PETROLEUM, 200, GeneralConfig.enable528PressurizedRecipes ? 1 : 0), new FluidStack(Fluids.NITRIC_ACID, 100)).outputItems(new ItemStack(ModItems.rocket_fuel, 4)));
        recipes.add(new ChemRecipe(58, "ELECTROLYSIS", 150).inputFluids(new FluidStack(Fluids.WATER, 4000)).outputFluids(new FluidStack(Fluids.HYDROGEN, 400), new FluidStack(Fluids.OXYGEN, 400)));
        recipes.add(new ChemRecipe(59, "XENON", 300).inputFluids(new FluidStack(Fluids.AIR, 16000)).outputFluids(new FluidStack(Fluids.XENON, 50)));
        recipes.add(new ChemRecipe(60, "XENON_OXY", 20).inputFluids(new FluidStack(Fluids.AIR, 8000), new FluidStack(Fluids.OXYGEN, 250)).outputFluids(new FluidStack(Fluids.XENON, 50)));
        recipes.add(new ChemRecipe(62, "BALEFIRE", 100).inputItems(new RecipesCommon.ComparableStack(ModItems.egg_balefire_shard)).inputFluids(new FluidStack(Fluids.KEROSENE, 6000)).outputItems(new ItemStack(ModItems.powder_balefire)).outputFluids(new FluidStack(Fluids.BALEFIRE, 8000)));
        recipes.add(new ChemRecipe(63, "SCHRABIDIC", 100).inputItems(new RecipesCommon.ComparableStack(ModItems.pellet_charged)).inputFluids(new FluidStack(Fluids.SAS3, 8000), new FluidStack(Fluids.PEROXIDE, 6000)).outputFluids(new FluidStack(Fluids.SCHRABIDIC, 16000)));
        recipes.add(new ChemRecipe(64, "SCHRABIDATE", 150).inputItems(new RecipesCommon.OreDictStack(OreDictManager.IRON.dust())).inputFluids(new FluidStack(Fluids.SCHRABIDIC, 250)).outputItems(new ItemStack(ModItems.powder_schrabidate)));
        recipes.add(new ChemRecipe(88, "LUBRICANT", 20).inputFluids(new FluidStack(Fluids.HEATINGOIL, 500), new FluidStack(Fluids.UNSATURATEDS, 500)).outputFluids(new FluidStack(Fluids.LUBRICANT, 1000)));
        recipes.add(new ChemRecipe(70, "TEL", 40).inputItems(new RecipesCommon.OreDictStack(OreDictManager.ANY_TAR.any()), new RecipesCommon.OreDictStack(OreDictManager.PB.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 100), new FluidStack(Fluids.STEAM, 1000)).outputItems(new ItemStack(ModItems.fuel_additive)));
        recipes.add(new ChemRecipe(4, "FR_REOIL", 30).inputFluids(new FluidStack(1000, Fluids.SMEAR)).outputFluids(new FluidStack(800, Fluids.RECLAIMED)));
        recipes.add(new ChemRecipe(5, "FR_PETROIL", 30).inputFluids(new FluidStack(800, Fluids.RECLAIMED), new FluidStack(200, Fluids.LUBRICANT)).outputFluids(new FluidStack(1000, Fluids.PETROIL)));
        recipes.add(new ChemRecipe(86, "PETROIL_LEADED", 40).inputItems(new RecipesCommon.ComparableStack(ModItems.fuel_additive)).inputFluids(new FluidStack(Fluids.PETROIL, 10000)).outputFluids(new FluidStack(Fluids.PETROIL_LEADED, 12000)));
        recipes.add(new ChemRecipe(71, "GASOLINE", 40).inputFluids(new FluidStack(Fluids.NAPHTHA, 1000)).outputFluids(new FluidStack(Fluids.GASOLINE, 800)));
        recipes.add(new ChemRecipe(85, "GASOLINE_LEADED", 40).inputItems(new RecipesCommon.ComparableStack(ModItems.fuel_additive)).inputFluids(new FluidStack(Fluids.GASOLINE, 10000)).outputFluids(new FluidStack(Fluids.GASOLINE_LEADED, 12000)));
        recipes.add(new ChemRecipe(87, "COALGAS_LEADED", 40).inputItems(new RecipesCommon.ComparableStack(ModItems.fuel_additive)).inputFluids(new FluidStack(Fluids.COALGAS, 10000)).outputFluids(new FluidStack(Fluids.COALGAS_LEADED, 12000)));
        recipes.add(new ChemRecipe(72, "FRACKSOL", 20).inputItems(new RecipesCommon.OreDictStack(OreDictManager.S.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 100), new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.FRACKSOL, 1000)));
        recipes.add(new ChemRecipe(73, "HELIUM3", 200).inputItems(new RecipesCommon.ComparableStack(ModBlocks.moon_turf, 8)).outputFluids(new FluidStack(Fluids.HELIUM3, 1000)));
        recipes.add(new ChemRecipe(74, "OSMIRIDIUM_DEATH", 240).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_paleogenite), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 8), new RecipesCommon.ComparableStack(ModItems.nugget_bismuth, 4)).inputFluids(new FluidStack(Fluids.PEROXIDE, 1000, 5)).outputFluids(new FluidStack(Fluids.DEATH, 1000, 0)));
        recipes.add(new ChemRecipe(75, "ETHANOL", 50).inputItems(new RecipesCommon.ComparableStack(Items.field_151102_aT, 10)).outputFluids(new FluidStack(Fluids.ETHANOL, 1000)));
        recipes.add(new ChemRecipe(76, "METH", 30).inputItems(new RecipesCommon.ComparableStack(Items.field_151015_O), new RecipesCommon.ComparableStack(Items.field_151100_aR, 2, 3)).inputFluids(new FluidStack(Fluids.LUBRICANT, 400), new FluidStack(Fluids.PEROXIDE, 400)).outputItems(new ItemStack(ModItems.chocolate, 4)));
        recipes.add(new ChemRecipe(77, "CO2", 60).inputFluids(new FluidStack(Fluids.GAS, 1000)).outputFluids(new FluidStack(Fluids.CARBONDIOXIDE, 1000)));
        recipes.add(new ChemRecipe(78, "HEAVY_ELECTROLYSIS", 150).inputFluids(new FluidStack(Fluids.HEAVYWATER, 2000)).outputFluids(new FluidStack(Fluids.DEUTERIUM, 200), new FluidStack(Fluids.OXYGEN, 200)));
        recipes.add(new ChemRecipe(80, "EPEARL", 100).inputItems(new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 1)).inputFluids(new FluidStack(Fluids.XPJUICE, 500)).outputFluids(new FluidStack(Fluids.ENDERJUICE, 100)));
        recipes.add(new ChemRecipe(98, "SHELL_CHLORINE", 100).inputItems(new RecipesCommon.ComparableStack(ModItems.ammo_arty, 1, 0), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 1)).inputFluids(new FluidStack(Fluids.CHLORINE, 4000)).outputItems(new ItemStack(ModItems.ammo_arty, 1, 9)));
        recipes.add(new ChemRecipe(99, "SHELL_PHOSGENE", 100).inputItems(new RecipesCommon.ComparableStack(ModItems.ammo_arty, 1, 0), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 1)).inputFluids(new FluidStack(Fluids.PHOSGENE, 4000)).outputItems(new ItemStack(ModItems.ammo_arty, 1, 10)));
        recipes.add(new ChemRecipe(100, "SHELL_MUSTARD", 100).inputItems(new RecipesCommon.ComparableStack(ModItems.ammo_arty, 1, 0), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 1)).inputFluids(new FluidStack(Fluids.MUSTARDGAS, 4000)).outputItems(new ItemStack(ModItems.ammo_arty, 1, 11)));
        recipes.add(new ChemRecipe(102, "THORIUM_SALT", 60).inputFluids(new FluidStack(Fluids.THORIUM_SALT_DEPLETED, 16000)).inputItems(new RecipesCommon.OreDictStack(OreDictManager.TH232.nugget(), 2)).outputFluids(new FluidStack(Fluids.THORIUM_SALT, 16000)).outputItems(new ItemStack(ModItems.nugget_u233, 1), new ItemStack(ModItems.nuclear_waste_tiny, 1)));
        recipes.add(new ChemRecipe(103, "MEAT_PROCESSING", 200).inputItems(new RecipesCommon.OreDictStack("glyphidMeat", 3)).inputFluids(new FluidStack(Fluids.SULFURIC_ACID, 1000)).outputItems(new ItemStack(ModItems.sulfur, 4), new ItemStack(ModItems.niter, 3)).outputFluids(new FluidStack(Fluids.SALIENT, 250)));
        recipes.add(new ChemRecipe(104, "RUSTY_DECO_STEEL", 100).inputItems(new RecipesCommon.ComparableStack(ModBlocks.deco_steel, 8)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputItems(new ItemStack(ModBlocks.deco_rusty_steel, 8)));
    }

    @Override
    public String getFileName() {
        return "hbmChemplant.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        int id = obj.get("id").getAsInt();
        String name = obj.get("name").getAsString();
        int duration = obj.get("duration").getAsInt();
        recipes.add(new ChemRecipe(id, name, duration).inputFluids(ChemplantRecipes.readFluidArray((JsonArray)obj.get("fluidInput"))).inputItems(ChemplantRecipes.readAStackArray((JsonArray)obj.get("itemInput"))).outputFluids(ChemplantRecipes.readFluidArray((JsonArray)obj.get("fluidOutput"))).outputItems(ChemplantRecipes.readItemStackArray((JsonArray)obj.get("itemOutput"))));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        try {
            ChemRecipe chem = (ChemRecipe)recipe;
            writer.name("id").value((long)chem.id);
            writer.name("name").value(chem.name);
            writer.name("duration").value((long)chem.duration);
            writer.name("fluidInput").beginArray();
            for (FluidStack fluidStack : chem.inputFluids) {
                if (fluidStack == null) continue;
                ChemplantRecipes.writeFluidStack(fluidStack, writer);
            }
            writer.endArray();
            writer.name("itemInput").beginArray();
            for (RecipesCommon.AStack aStack : chem.inputs) {
                if (aStack == null) continue;
                ChemplantRecipes.writeAStack(aStack, writer);
            }
            writer.endArray();
            writer.name("fluidOutput").beginArray();
            for (FluidStack fluidStack : chem.outputFluids) {
                if (fluidStack == null) continue;
                ChemplantRecipes.writeFluidStack(fluidStack, writer);
            }
            writer.endArray();
            writer.name("itemOutput").beginArray();
            for (ItemStack itemStack : chem.outputs) {
                if (itemStack == null) continue;
                ChemplantRecipes.writeItemStack(itemStack, writer);
            }
            writer.endArray();
        }
        catch (Exception ex) {
            MainRegistry.logger.error((Object)ex);
            ex.printStackTrace();
        }
    }

    @Override
    public String getComment() {
        return "Rules: All in- and output arrays need to be present, even if empty. IDs need to be unique, but not sequential. It's safe if you add your own recipes starting with ID 1000. Template order depends on the order of the recipes in this JSON file. The 'name' field is responsible for the texture being loaded for the template. Custom dynamic texture generation is not yet implemented, you will have to throw the texture into the JAR manually.";
    }

    @Override
    public void deleteRecipes() {
        indexMapping.clear();
        recipes.clear();
    }

    @Deprecated
    public static class ChemRecipe {
        public int listing;
        private int id;
        public String name;
        public RecipesCommon.AStack[] inputs;
        public FluidStack[] inputFluids;
        public ItemStack[] outputs;
        public FluidStack[] outputFluids;
        private int duration;

        public ChemRecipe(int index, String name, int duration) {
            this.id = index;
            this.name = name;
            this.duration = duration;
            this.listing = recipes.size();
            this.inputs = new RecipesCommon.AStack[4];
            this.outputs = new ItemStack[4];
            this.inputFluids = new FluidStack[2];
            this.outputFluids = new FluidStack[2];
            if (indexMapping.containsKey(this.id)) {
                throw new IllegalStateException("Chemical plant recipe " + name + " has been registered with duplicate id " + this.id + " used by " + ChemplantRecipes.indexMapping.get((Object)Integer.valueOf((int)this.id)).name + "!");
            }
            indexMapping.put(this.id, this);
        }

        public ChemRecipe inputItems(RecipesCommon.AStack ... in) {
            for (int i = 0; i < in.length; ++i) {
                this.inputs[i] = in[i];
            }
            return this;
        }

        public ChemRecipe inputFluids(FluidStack ... in) {
            for (int i = 0; i < in.length; ++i) {
                this.inputFluids[i] = in[i];
            }
            return this;
        }

        public ChemRecipe outputItems(ItemStack ... out) {
            for (int i = 0; i < out.length; ++i) {
                this.outputs[i] = out[i];
            }
            return this;
        }

        public ChemRecipe outputFluids(FluidStack ... out) {
            for (int i = 0; i < out.length; ++i) {
                this.outputFluids[i] = out[i];
            }
            return this;
        }

        public int getId() {
            return this.id;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

