#ifndef _XOMS_API_STRUCT_H_
#define _XOMS_API_STRUCT_H_

#include "xtp_api_data_type.h"


//=====================ͻ˽ӿڶ=================================
///¶
struct XTPOrderInsertInfo
{
    ///XTPϵͳIDûдXTPϵͳΨһ
    uint64_t                order_xtp_id;
    ///ãɿͻԶ
    uint32_t	            order_client_id;
    ///Լ ͻ󲻴ո'\0'β
    char                    ticker[XTP_TICKER_LEN];
    ///г
    XTP_MARKET_TYPE         market;
    ///۸
    double                  price;
    ///ֶֹۣΣ
    double                  stop_price;
    ///(ƱλΪɣعλΪ)
    int64_t                 quantity;
    ///۸
    XTP_PRICE_TYPE          price_type;
    ///
    XTP_SIDE_TYPE           side;
	///ҵ
	XTP_BUSINESS_TYPE       business_type;

	XTPOrderInsertInfo()
	{
		business_type = XTP_BUSINESS_TYPE_CASH;
	}
 };


///ʧӦϢ
struct XTPOrderCancelInfo
{
    ///XTPID
    uint64_t                 order_cancel_xtp_id;
    ///ԭʼXTPID
    uint64_t                 order_xtp_id;
};


///Ӧṹ
struct XTPOrderInfo
{
    ///XTPϵͳIDXTPϵͳΨһ
	uint64_t                order_xtp_id;
	///ãûԶ
	uint32_t	            order_client_id;
    ///ãûԶ壨δʹã
    uint32_t                order_cancel_client_id;
    ///XTPϵͳеidXTPϵͳΨһ
    uint64_t                order_cancel_xtp_id;
	///Լ
	char                    ticker[XTP_TICKER_LEN];
	///г
	XTP_MARKET_TYPE         market;
	///۸
	double                  price;
	///˶ı
	int64_t                 quantity;
	///۸
	XTP_PRICE_TYPE          price_type;
	///
	XTP_SIDE_TYPE           side;
	///ҵ
	XTP_BUSINESS_TYPE       business_type;
	///ɽΪ˶ۼƳɽ
	int64_t                 qty_traded;
	///ʣɹʱʾ
	int64_t                 qty_left;
	///ίʱ䣬ʽΪYYYYMMDDHHMMSSsss
	int64_t                 insert_time;
	///޸ʱ䣬ʽΪYYYYMMDDHHMMSSsss
	int64_t                 update_time;
	///ʱ䣬ʽΪYYYYMMDDHHMMSSsss
	int64_t                 cancel_time;
	///ɽΪ˶ĳɽܽ
	double                  trade_amount;
	///ر OMSɵĵţͬorder_xtp_idΪ̵ĵ
	char                    order_local_id[XTP_LOCAL_ORDER_LEN];
	///״̬Ӧûвֳɽ״̬ͣڲѯУвֳɽ״̬
	XTP_ORDER_STATUS_TYPE   order_status;
	///ύ״̬OMSڲʹãû
	XTP_ORDER_SUBMIT_STATUS_TYPE   order_submit_status;
	///
	TXTPOrderTypeType       order_type;

	XTPOrderInfo()
	{
		business_type = XTP_BUSINESS_TYPE_CASH;
	}
};



///ɽṹ
struct XTPTradeReport
{
    ///XTPϵͳID˳ɽرصĶIDXTPϵͳΨһ
    uint64_t                 order_xtp_id;
    ///
    uint32_t                 order_client_id;
    ///Լ
    char                     ticker[XTP_TICKER_LEN];
    ///г
    XTP_MARKET_TYPE          market;
    ///ţXTPID󣬸ֶʵʺorder_xtp_idظӿʱ
    uint64_t                 local_order_id;
    ///ɽţΨһϽÿʽΨһ2ʳɽرӵͬexec_idΪ˱ʽԳɽ
    char                    exec_id[XTP_EXEC_ID_LEN];
    ///۸񣬴˴γɽļ۸
    double                   price;
    ///˴γɽۼ
    int64_t                  quantity;
    ///ɽʱ䣬ʽΪYYYYMMDDHHMMSSsss
    int64_t                  trade_time;
    ///ɽ˴γɽܽ = price*quantity
    double                   trade_amount;
    ///ɽ --ر¼ţÿΨһ,report_index+marketֶοΨһʶʾɽر
    uint64_t                 report_index;
    /// --ţϽΪգдֶ
    char                     order_exch_id[XTP_ORDER_EXCH_LEN];
    ///ɽ  --ɽرеִ
    TXTPTradeTypeType        trade_type;
    ///
    XTP_SIDE_TYPE            side;
	///ҵ
	XTP_BUSINESS_TYPE        business_type;
    ///Ա 
    char                     branch_pbu[XTP_BRANCH_PBU_LEN];

	XTPTradeReport()
	{
		business_type = XTP_BUSINESS_TYPE_CASH;
	}
};


//////////////////////////////////////////////////////////////////////////
///ѯ
//////////////////////////////////////////////////////////////////////////
///ѯ-ѯ
struct XTPQueryOrderReq
{
    ///֤ȯ룬ΪգΪգĬϲѯʱڵгɽر
    char      ticker[XTP_TICKER_LEN];
    ///ʽΪYYYYMMDDHHMMSSsssΪ0Ĭϵǰ0
    int64_t   begin_time;
    ///ʽΪYYYYMMDDHHMMSSsssΪ0Ĭϵǰʱ
    int64_t   end_time;  
};

///ѯӦṹ
typedef XTPOrderInfo XTPQueryOrderRsp;


//////////////////////////////////////////////////////////////////////////
///ɽرѯ
//////////////////////////////////////////////////////////////////////////
///ѯɽ-ִбŲѯֶΣ
struct XTPQueryReportByExecIdReq
{
    ///XTPϵͳID
    uint64_t  order_xtp_id;  
    ///ɽִб
    char  exec_id[XTP_EXEC_ID_LEN];
};

///ѯɽر-ѯ
struct XTPQueryTraderReq
{
    ///֤ȯ룬ΪգΪգĬϲѯʱڵгɽر
    char      ticker[XTP_TICKER_LEN];
    ///ʼʱ䣬ʽΪYYYYMMDDHHMMSSsssΪ0Ĭϵǰ0
    int64_t   begin_time; 
    ///ʱ䣬ʽΪYYYYMMDDHHMMSSsssΪ0Ĭϵǰʱ
    int64_t   end_time;  
};

///ɽرѯӦṹ
typedef XTPTradeReport  XTPQueryTradeRsp;



//////////////////////////////////////////////////////////////////////////
///˻ʽѯӦṹ
//////////////////////////////////////////////////////////////////////////
struct XTPQueryAssetRsp
{
	///ʲ(=ʽ + ֤ȯʲĿǰΪ0+ Ԥ۵ʽ)
	double total_asset;
    ///ʽ
    double buying_power;
	///֤ȯʲֶΣĿǰΪ0
	double security_asset;
    ///ۼɽ֤ȯռʽ
    double fund_buy_amount;
    ///ۼɽ׷
    double fund_buy_fee;
    ///ۼɽ֤ȯʽ
    double fund_sell_amount;
    ///ۼɽ׷
    double fund_sell_fee;
	///XTPϵͳԤ۵ʽ𣨰ƱʱԤ۵Ľʽ+Ԥѣ
	double withholding_amount;
};



//////////////////////////////////////////////////////////////////////////
///ѯƱֲ
//////////////////////////////////////////////////////////////////////////
struct XTPQueryStkPositionRsp
{
    ///֤ȯ
    char                ticker[XTP_TICKER_LEN]; 
    ///֤ȯ
    char                ticker_name[XTP_TICKER_NAME_LEN]; 
    ///г
    XTP_MARKET_TYPE     market;
    ///ǰֲ
    int64_t             total_qty; 
    ///ùɷ
    int64_t             sellable_qty; 
    ///ɱ
    double              avg_price;           
    ///ӯֶΣ
    double              unrealized_pnl;        
};



/////////////////////////////////////////////////////////////////////////
///ʽתˮ֪ͨ
/////////////////////////////////////////////////////////////////////////
struct XTPFundTransferNotice
{
    ///ʽת
    uint64_t	            serial_id;
    ///ת
    XTP_FUND_TRANSFER_TYPE	transfer_type;
    ///
    double	                amount;
    /// 
    XTP_FUND_OPER_STATUS    oper_status;
    ///ʱ
    uint64_t	            transfer_time;
};





/////////////////////////////////////////////////////////////////////////
///ʽתˮѯӦ
/////////////////////////////////////////////////////////////////////////
struct XTPQueryFundTransferLogReq {
    ///ʽת
    uint64_t	serial_id;

};

/////////////////////////////////////////////////////////////////////////
///ʽתˮ¼ṹ
/////////////////////////////////////////////////////////////////////////
typedef XTPFundTransferNotice XTPFundTransferLog;








#endif //_XOMS_API_STRUCT_H_

