//˵

//API
#include "xtp_trader_api.h"

//ϵͳ
#ifdef WIN32
#include "stdafx.h"
#endif
#include <string>
#include <queue>

//Boost
#define BOOST_PYTHON_STATIC_LIB
#include <boost/python/module.hpp>	//pythonװ
#include <boost/python/def.hpp>		//pythonװ
#include <boost/python/dict.hpp>	//pythonװ
#include <boost/python/list.hpp>	//pythonװ
#include <boost/python/object.hpp>	//pythonװ
#include <boost/python.hpp>			//pythonװ
#include <boost/thread.hpp>			//е̹߳
#include <boost/bind.hpp>			//е̹߳


//ռ
using namespace std;
using namespace boost::python;
using namespace boost;


//
#define ONDISCONNECTED 1
#define ONERROR 2
#define ONORDEREVENT 3
#define ONTRADEEVENT 4
#define ONCANCELORDERERROR 5
#define ONQUERYORDER 6
#define ONQUERYTRADE 7
#define ONQUERYPOSITION 8
#define ONQUERYASSET 9


///-------------------------------------------------------------------------------------
///APIеĲ
///-------------------------------------------------------------------------------------

//GILȫ򻯻ȡã
//ڰC++̻߳GILӶֹpython
class PyLock
{
private:
	PyGILState_STATE gil_state;

public:
	//ĳдöʱGIL
	PyLock()
	{
		gil_state = PyGILState_Ensure();
	}

	//ĳɺٸöʱGIL
	~PyLock()
	{
		PyGILState_Release(gil_state);
	}
};


//ṹ
struct Task
{
	int task_name;		//صƶӦĳ
	void *task_data;	//ݽṹ
	void *task_error;	//ṹ
	int task_id;		//id
	bool task_last;		//ǷΪ󷵻
	uint64_t addtional_int;		//ֶ
};


///̰߳ȫĶ
template<typename Data>

class ConcurrentQueue
{
private:
	queue<Data> the_queue;								//׼
	mutable mutex the_mutex;							//boost
	condition_variable the_condition_variable;			//boost

public:

	//µ
	void push(Data const& data)
	{
		mutex::scoped_lock lock(the_mutex);				//ȡ
		the_queue.push(data);							//д
		lock.unlock();									//ͷ
		the_condition_variable.notify_one();			//֪ͨȴ߳
	}

	//ǷΪ
	bool empty() const
	{
		mutex::scoped_lock lock(the_mutex);
		return the_queue.empty();
	}

	//ȡ
	Data wait_and_pop()
	{
		mutex::scoped_lock lock(the_mutex);

		while (the_queue.empty())						//Ϊʱ
		{
			the_condition_variable.wait(lock);			//ȴ֪ͨ
		}

		Data popped_value = the_queue.front();			//ȡеһ
		the_queue.pop();								//ɾ
		return popped_value;							//ظ
	}

};


//ֵлȡĳֵӦֵṹֵ
void getInt(dict d, string key, int *value);

void getUint64(dict d, string key, uint64_t *value);

void getUint32(dict d, string key, uint32_t *value);

void getInt64(dict d, string key, int64_t *value);


//ֵлȡĳֵӦĸֵṹֵ
void getDouble(dict d, string key, double* value);


//ֵлȡĳֵӦֵַṹֵ
void getChar(dict d, string key, char* value);


//ֵлȡĳֵӦֵַṹֵ
void getStr(dict d, string key, char* value);


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class TraderApi : public XTP::API::TraderSpi
{
private:
	XTP::API::TraderApi* api;			//API
	thread *task_thread;				//ָ߳루pythonݣ
	ConcurrentQueue<Task*> task_queue;	//

public:
	TraderApi()
	{
		function0<void> f = boost::bind(&TraderApi::processTask, this);
		thread t(f);
		this->task_thread = &t;
	};

	~TraderApi()
	{
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	///ͻ˵ĳ뽻׺̨ͨӶϿʱ÷á
	///@param reason ԭӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ûlogoutµĶߣᴥ˺apiԶ߷ʱûѡڴ˺еLoginµ¼session_idʱûյݸ֮ǰ
	virtual void OnDisconnected(uint64_t session_id, int reason);

	///Ӧ
	///@param error_info ӦʱľĴʹϢ,error_infoΪգerror_info.error_idΪ0ʱûд
	///@remark ˺ֻڷʱŻãһû
	virtual void OnError(XTPRI *error_info);

	///֪ͨ
	///@param order_info ӦϢûͨorder_info.order_xtp_idͨGetClientIDByXTPID() == client_idԼĶorder_info.qty_leftֶڶΪδɽɡȫɡϵ״̬ʱʾ˶ûгɽڲȫ״̬ʱʾ˶order_info.order_cancel_xtp_idΪӦĳIDΪ0ʱʾ˵ɹ
	///@param error_info ܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark ÿζ״̬ʱᱻãҪٷأϢʱᴥߣڶδɽȫɽȫֳѾܾЩ״̬ʱӦڲֳɽɶĳɽرȷϡе¼˴ûĿͻ˶յûĶӦ
	virtual void OnOrderEvent(XTPOrderInfo *order_info, XTPRI *error_info);

	///ɽ֪ͨ
	///@param trade_info ɽرľϢûͨtrade_info.order_xtp_idͨGetClientIDByXTPID() == client_idԼĶϽexec_idΨһʶһʳɽ2ʳɽرӵͬexec_idΪ˱ʽԳɽˡexec_idΨһģʱ޴жϻơreport_index+marketֶοΨһʶʾɽر
	///@remark гɽʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûĳɽرضΪ״̬ҪûͨɽرĳɽȷOnOrderEvent()Ͳ״̬
	virtual void OnTradeEvent(XTPTradeReport *trade_info);

	///Ӧ
	///@param cancel_info Ϣorder_cancel_xtp_idʹorder_xtp_id
	///@param error_info ܾ߷ʱʹϢҪٷأϢʱᴥߣerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ӧֻڳʱص
	virtual void OnCancelOrderError(XTPOrderCancelInfo *cancel_info, XTPRI *error_info);

	///ѯӦ
	///@param order_info ѯı
	///@param error_info ѯʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥ
	virtual void OnQueryOrder(XTPQueryOrderRsp *order_info, XTPRI *error_info, int request_id, bool is_last);

	///ѯɽӦ
	///@param trade_info ѯĳɽر
	///@param error_info ѯɽرʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥ
	virtual void OnQueryTrade(XTPQueryTradeRsp *trade_info, XTPRI *error_info, int request_id, bool is_last);

	///ѯͶֲ߳Ӧ
	///@param position ѯĳֲ
	///@param error_info ѯ˻ֲַʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@remark ûܳжƱһѯܶӦӦҪٷأϢʱᴥ
	virtual void OnQueryPosition(XTPQueryStkPositionRsp *position, XTPRI *error_info, int request_id, bool is_last);

	///ѯʽ˻ӦҪٷأϢʱᴥ
	///@param asset ѯʽ˻
	///@param error_info ѯʽ˻ʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryAsset(XTPQueryAssetRsp *asset, XTPRI *error_info, int request_id, bool is_last);

	//-------------------------------------------------------------------------------------
	//task
	//-------------------------------------------------------------------------------------

	void processTask();

	void processDisconnected(Task *task);

	void processError(Task *task);

	void processOrderEvent(Task *task);

	void processTradeEvent(Task *task);

	void processCancelOrderError(Task *task);

	void processQueryOrder(Task *task);

	void processQueryTrade(Task *task);

	void processQueryPosition(Task *task);

	void processQueryAsset(Task *task);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//reqidid
	//lastǷΪ󷵻
	//-------------------------------------------------------------------------------------

	virtual void onDisconnected(uint64_t session, int reason) {};

	virtual void onError(dict data) {};

	virtual void onOrderEvent(dict data, dict error) {};

	virtual void onTradeEvent(dict data) {};

	virtual void onCancelOrderError(dict data, dict error) {};

	virtual void onQueryOrder(dict data, dict error, int reqid, bool last) {};

	virtual void onQueryTrade(dict data, dict error, int reqid, bool last) {};

	virtual void onQueryPosition(dict data, dict error, int reqid, bool last) {};

	virtual void onQueryAsset(dict data, dict error, int reqid, bool last) {};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createTraderApi(uint8_t clientid, string path);

	void release();

	int exit();

	string getTradingDay();

	dict getApiLastError();

	string getApiVersion();

	uint8_t getClientIDByXTPID(uint64_t orderid);

	string getAccountByXTPID(uint64_t orderid);

	void subscribePublicTopic(int tpye);

	void setSoftwareKey(string key);

	void setSoftwareVersion(string version);

	uint64_t login(string ip, int port, string user, string password, int socktype);

	int logout(uint64_t sessionid);

	uint64_t insertOrder(dict req, uint64_t sessionid);

	uint64_t cancelOrder(uint64_t orderid, uint64_t sessionid);

	int queryOrderByXTPID(uint64_t orderid, uint64_t sessionid, int reqid);

	int queryOrders(dict req, uint64_t sessionid, int reqid);

	int queryTradesByXTPID(uint64_t orderid, uint64_t sessionid, int reqid);

	int queryTrades(dict req, uint64_t sessionid, int reqid);

	int queryPosition(string ticker, uint64_t sessionid, int reqid);

	int queryAsset(uint64_t sessionid, int reqid);
};
