/////////////////////////////////////////////////////////////////////////
///@author ̩֤ȯɷ޹˾
///@file xquote_api_struct.h
///@brief ݽṹ
/////////////////////////////////////////////////////////////////////////
#ifndef _XQUOTE_API_STRUCT_H_
#define _XQUOTE_API_STRUCT_H_

#include <stdint.h>
#include "xtp_api_data_type.h"

#pragma pack(8)

///ָĺԼ
typedef struct XTPSpecificTickerStruct
{
    ///
    XTP_EXCHANGE_TYPE exchange_id;
    ///Լ루Ϣ"600000"ո'\0'β
	char	ticker[XTP_TICKER_LEN];
} XTPST;


///
typedef struct XTPMarketDataStruct
{
    // 
    ///
    XTP_EXCHANGE_TYPE exchange_id;
    ///Լ루Ϣո'\0'β
    char	ticker[XTP_TICKER_LEN];

    // Ʊȼ۸
	///¼
	double	last_price;
	///
	double	pre_close_price;
	///
	double	open_price;
	///߼
	double	high_price;
	///ͼ
	double	low_price;
    ///
    double	close_price;

    // ڻ
    ///ֲĿǰδд
    double	pre_open_interest;
    ///ֲĿǰδд
	double	open_interest;
    ///ϴνۣĿǰδд
    double	pre_settlement_price;
    ///νۣĿǰδд
	double	settlement_price;

	///ۣͣĿǰδд
	double	upper_limit_price;
	///ۣͣĿǰδд
	double	lower_limit_price;
	///ʵȣĿǰδд
	double	pre_delta;
	///ʵȣĿǰδд
	double	curr_delta;

    /// ʱ࣬ʽΪYYYYMMDDHHMMSSsss
    int64_t data_time;

    // 
    ///Ϊܳɽλɣ뽻һ£
    int64_t	qty;
    ///ɽΪܳɽλԪ뽻һ£
    double	turnover;
    ///վ=(turnover/qty)
    double	avg_price;

    // 
    ///ʮ
    double bid[10];
    ///ʮ
    double	ask[10];
    ///ʮ
    int64_t	bid_qty[10];
    ///ʮ
    int64_t	ask_qty[10];

    // ݣĿǰδд
    ///ɽ
    int64_t trades_count;
    ///ǰ״̬˵
    char ticker_status[8];
    ///ί
    int64_t total_bid_qty;
    ///ί
    int64_t total_ask_qty;
    ///Ȩƽί۸
    double ma_bid_price;
    ///Ȩƽί۸
    double ma_ask_price;
    ///ծȯȨƽί۸
    double ma_bond_bid_price;
    ///ծȯȨƽί۸
    double ma_bond_ask_price;
    ///ծȯ
    double yield_to_maturity;
    ///ETFֵֵ
    double iopv;
    ///ETF깺
    int32_t etf_buy_count;
    ///ETFر
    int32_t etf_sell_count;
    ///ETF깺
    double etf_buy_qty;
    ///ETF깺
    double etf_buy_money;
    ///ETF
    double etf_sell_qty;
    ///ETFؽ
    double etf_sell_money;
    ///Ȩִ֤е
    double total_warrant_exec_qty;
    ///Ȩ֤ͣ۸Ԫ
    double warrant_lower_price;
    ///Ȩ֤ͣ۸Ԫ
    double warrant_upper_price;
    ///볷
    int32_t cancel_buy_count;
    ///
    int32_t cancel_sell_count;
    ///볷
    double cancel_buy_qty;
    ///
    double cancel_sell_qty;
    ///볷
    double cancel_buy_money;
    ///
    double cancel_sell_money;
    ///ܱ
    int64_t total_buy_count;
    ///ܱ
    int64_t total_sell_count;
    ///ίгɽȴʱ
    int32_t duration_after_buy;
    ///ίгɽȴʱ
    int32_t duration_after_sell;
    ///ίмλ
    int32_t num_bid_orders;
    ///ίмλ
    int32_t num_ask_orders;
    ///ɽʱ䣨UA3113
    int32_t exec_time;
    ///б־UA103/UA104
    char is_market_closed[4];
    ///ԼֲUA103
    double total_position;
    ///ӯ1UA103
    double pe_ratio1;
    ///ӯ2UA103
    double pe_ratio2;
} XTPMD;


///Ʊ龲̬Ϣ
typedef struct XTPQuoteStaticInfo {
    ///
    XTP_EXCHANGE_TYPE exchange_id;
    ///Լ루Ϣո'\0'β
    char    ticker[XTP_TICKER_LEN];
    /// Լ
    char    ticker_name[XTP_TICKER_NAME_LEN];
    /// Լ
	XTP_TICKER_TYPE ticker_type;
    ///
    double  pre_close_price;
    ///ͣ
    double  upper_limit_price;
    ///ͣ
    double  lower_limit_price;
	///С䶯λ
	double  price_tick;
    /// ԼС()
    int32_t  buy_qty_unit;
    /// ԼС()
	int32_t sell_qty_unit;
} XTPQSI;


///
typedef struct OrderBookStruct {
    ///
    XTP_EXCHANGE_TYPE exchange_id;
    ///Լ루Ϣո'\0'β
    char    ticker[XTP_TICKER_LEN];

    // 
    ///ʮ
    double bid[10];
    ///ʮ
    double  ask[10];
    ///ʮ
    int64_t bid_qty[10];
    ///ʮ
    int64_t ask_qty[10];
    /// ʱ
    int64_t data_time;
} XTPOB;

#pragma pack()

#endif
