//˵

//ϵͳ
#include "stdafx.h"
#include <string>
#include <queue>

//Boost
#define BOOST_PYTHON_STATIC_LIB
#include <boost/python/module.hpp>	//pythonװ
#include <boost/python/def.hpp>		//pythonװ
#include <boost/python/dict.hpp>	//pythonװ
#include <boost/python/object.hpp>	//pythonװ
#include <boost/python.hpp>			//pythonװ
#include <boost/thread.hpp>			//е̹߳
#include <boost/bind.hpp>			//е̹߳
#include <boost/any.hpp>			//еʵ

//API
#include "DFITCMdApi.h"

//ռ
using namespace std;
using namespace boost::python;
using namespace boost;
using namespace DFITCXSPEEDMDAPI;

//
#define ONFRONTCONNECTED 1
#define ONFRONTDISCONNECTED 2
#define ONRSPUSERLOGIN 3
#define ONRSPUSERLOGOUT 4
#define ONRSPERROR 5
#define ONRSPSUBMARKETDATA 6
#define ONRSPUNSUBMARKETDATA 7
#define ONRSPSUBFORQUOTERSP 8
#define ONRSPUNSUBFORQUOTERSP 9
#define ONMARKETDATA 10
#define ONCUSTOMMARKETDATA 11
#define ONRTNFORQUOTERSP 12
#define ONRSPTRADINGDAY 13
#define EXIT 0


///-------------------------------------------------------------------------------------
///APIеĲ
///-------------------------------------------------------------------------------------

//GILȫ򻯻ȡã
//ڰC++̻߳GILӶֹpython
class PyLock
{
private:
	PyGILState_STATE gil_state;

public:
	//ĳдöʱGIL
	PyLock()
	{
		gil_state = PyGILState_Ensure();
	}

	//ĳɺٸöʱGIL
	~PyLock()
	{
		PyGILState_Release(gil_state);
	}
};


//ṹ
struct Task
{
	int task_name;		//صƶӦĳ
	any task_data;		//ݽṹ
	any task_error;		//ṹ
	int task_id;		//id
	bool task_last;		//ǷΪ󷵻
};


///̰߳ȫĶ
template<typename Data>

class ConcurrentQueue
{
private:
	queue<Data> the_queue;								//׼
	mutable mutex the_mutex;							//boost
	condition_variable the_condition_variable;			//boost

public:

	//µ
	void push(Data const& data)
	{
		mutex::scoped_lock lock(the_mutex);				//ȡ
		the_queue.push(data);							//д
		lock.unlock();									//ͷ
		the_condition_variable.notify_one();			//֪ͨȴ߳
	}

	//ǷΪ
	bool empty() const
	{
		mutex::scoped_lock lock(the_mutex);
		return the_queue.empty();
	}

	//ȡ
	Data wait_and_pop()
	{
		mutex::scoped_lock lock(the_mutex);

		while (the_queue.empty())						//Ϊʱ
		{
			the_condition_variable.wait(lock);			//ȴ֪ͨ
		}

		Data popped_value = the_queue.front();			//ȡеһ
		the_queue.pop();								//ɾ
		return popped_value;							//ظ
	}

};


//ֵлȡĳֵӦֵṹֵ
void getInt(dict d, string key, int* value);


//ֵлȡĳֵӦĸֵṹֵ
void getDouble(dict d, string key, double* value);


//ֵлȡĳֵӦĵֵַṹֵ
void getChar(dict d, string key, char* value);


//ֵлȡĳֵӦֵַṹֵ
void getString(dict d, string key, char* value);


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class MdApi : public DFITCMdSpi
{
private:
	DFITCMdApi* api;			//API
	thread *task_thread;				//ָ߳루pythonݣ
	ConcurrentQueue<Task> task_queue;	//

public:
	MdApi()
	{
		function0<void> f = boost::bind(&MdApi::processTask, this);
		thread t(f);
		this->task_thread = &t;
	};

	~MdApi()
	{
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

		/**
		* Ӧ
		*/
		virtual void OnFrontConnected();

		/**
		* ӲӦ
		*/
		virtual void OnFrontDisconnected(int nReason);

		/**
		* ½Ӧ:û¼ǰûӦʱ˷ᱻã֪ͨû¼Ƿɹ
		* @param pRspUserLogin:û¼Ϣṹַ
		* @param pRspInfo:ʧܣشϢַýṹдϢ
		*/
		virtual void OnRspUserLogin(struct DFITCUserLoginInfoRtnField * pRspUserLogin, struct DFITCErrorRtnField * pRspInfo);

		/**
		* ǳӦ:û˳ǰûӦ˷ᱻã֪ͨû˳״̬
		* @param pRspUsrLogout:û˳Ϣṹַ
		* @param pRspInfo:ʧܣشϢַ
		*/
		virtual void OnRspUserLogout(struct DFITCUserLogoutInfoRtnField * pRspUsrLogout, struct DFITCErrorRtnField * pRspInfo);

		/**
		* Ӧ
		* @param pRspInfo:Ϣַ
		*/
		virtual void OnRspError(struct DFITCErrorRtnField *pRspInfo);

		/**
		* 鶩Ӧ:û鶩ĸ÷ᱻá
		* @param pSpecificInstrument:ָԼӦṹýṹԼϢ
		* @param pRspInfo:Ϣ󣬸ýṹдϢ
		*/
		virtual void OnRspSubMarketData(struct DFITCSpecificInstrumentField * pSpecificInstrument, struct DFITCErrorRtnField * pRspInfo);

		/**
		* ȡӦ:û˶÷ᱻá
		* @param pSpecificInstrument:ָԼӦṹýṹԼϢ
		* @param pRspInfo:Ϣ󣬸ýṹдϢ
		*/
		virtual void OnRspUnSubMarketData(struct DFITCSpecificInstrumentField * pSpecificInstrument, struct DFITCErrorRtnField * pRspInfo);

		/**
		* ѯӦ
		* @param pSpecificInstrument:ָԼӦṹýṹԼϢ
		* @param pRspInfo:Ϣ󣬸ýṹдϢ
		*/
		virtual void OnRspSubForQuoteRsp(struct DFITCSpecificInstrumentField * pSpecificInstrument, struct DFITCErrorRtnField * pRspInfo);

		/**
		* ȡѯӦ
		* @param pSpecificInstrument:ָԼӦṹýṹԼϢ
		* @param pRspInfo:Ϣ󣬸ýṹдϢ
		*/
		virtual void OnRspUnSubForQuoteRsp(struct DFITCSpecificInstrumentField * pSpecificInstrument, struct DFITCErrorRtnField * pRspInfo);

		/**
		* ϢӦ:ɹ鷵ʱ÷ᱻá
		* @param pMarketDataField:ָϢṹָ룬ṹаϢ
		*/
		virtual void OnMarketData(struct DFITCDepthMarketDataField * pMarketDataField);

		/**
		* ԶϢӦ:ɹ鷵ʱ÷ᱻá
		* @param pMarketDataField:ָϢṹָ룬ṹаϢ
		*/
		virtual void OnCustomMarketData(struct DFITCCustomMarketDataField * pMarketDataField);

		/**
		* ѯ֪ͨ
		* @param pForQuoteField:ָѯϢṹָ룬ṹаѯϢ
		*/
		virtual void OnRtnForQuoteRsp(struct DFITCQuoteSubscribeRtnField * pForQuoteField);

		/**
		* ȷӦ:ڽսϢ
		* @param pTradingDayRtnData: ؽȷӦṹĵַ
		*/
		virtual void OnRspTradingDay(struct DFITCTradingDayRtnField * pTradingDayRtnData);


	//-------------------------------------------------------------------------------------
	//task
	//-------------------------------------------------------------------------------------

	void processTask();

	void processFrontConnected(Task task);

	void processFrontDisconnected(Task task);

	void processRspUserLogin(Task task);

	void processRspUserLogout(Task task);

	void processRspError(Task task);

	void processRspSubMarketData(Task task);

	void processRspUnSubMarketData(Task task);

	void processRspSubForQuoteRsp(Task task);

	void processRspUnSubForQuoteRsp(Task task);

	void processMarketData(Task task);

	void processCustomMarketData(Task task);

	void processRtnForQuoteRsp(Task task);

	void processRspTradingDay(Task task);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//idid
	//lastǷΪ󷵻
	//i
	//-------------------------------------------------------------------------------------

	virtual void onFrontConnected(){};

	virtual void onFrontDisconnected(int i){};

	virtual void onRspUserLogin(dict data, dict error) {};

	virtual void onRspUserLogout(dict data, dict error) {};

	virtual void onRspError(dict error) {};

	virtual void onRspSubMarketData(dict data, dict error) {};

	virtual void onRspUnSubMarketData(dict data, dict error) {};

	virtual void onRspSubForQuoteRsp(dict data, dict error) {};

	virtual void onRspUnSubForQuoteRsp(dict data, dict error) {};

	virtual void onMarketData(dict data) {};

	virtual void onCustomMarketData(dict data) {};

	virtual void onRtnForQuoteRsp(dict data) {};

	virtual void onRspTradingDay(dict data) {};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createDFITCMdApi();

	void release();

	void init(string pszSvrAddr);

	int exit();
	
	int subscribeMarketData(string instrumentID, int nRequestID);

	int unSubscribeMarketData(string instrumentID, int nRequestID);

	int subscribeForQuoteRsp(string instrumentID, int nRequestID);

	int unSubscribeForQuoteRsp(string instrumentID, int nRequestID);

	int reqUserLogin(dict req);

	int reqUserLogout(dict req);

	int reqTradingDay(dict req);
};
