//˵

//ϵͳ
#ifdef WIN32
#include "stdafx.h"
#endif
#include <string>
#include <queue>
#include <vector>

//Boost
#define BOOST_PYTHON_STATIC_LIB
#include <boost/python/module.hpp>		//pythonװ
#include <boost/python/def.hpp>			//pythonװ
#include <boost/python/dict.hpp>		//pythonװ
#include <boost/python/list.hpp>		//pythonװ
#include <boost/python/object.hpp>		//pythonװ
#include <boost/python.hpp>				//pythonװ
#include <boost/thread.hpp>				//е̹߳
#include <boost/bind.hpp>				//е̹߳
#include <boost/any.hpp>				//еʵ
#include <boost/algorithm/string.hpp>	//ַ

//API
#include "ShZdTradeLib.h"

//ռ
using namespace std;
using namespace boost::python;
using namespace boost;

//
#define ONRECEIVETRADEINFO 1
#define ONRECEIVEMARKETINFO 2
#define ONRECEIVEERRORINFO 3


///-------------------------------------------------------------------------------------
///APIеĲ
///-------------------------------------------------------------------------------------

//GILȫ򻯻ȡã
//ڰC++̻߳GILӶֹpython
class PyLock
{
private:
	PyGILState_STATE gil_state;

public:
	//ĳдöʱGIL
	PyLock()
	{
		gil_state = PyGILState_Ensure();
	}

	//ĳɺٸöʱGIL
	~PyLock()
	{
		PyGILState_Release(gil_state);
	}
};


//ṹ
struct Task
{
	int task_name;			//صƶӦĳ
	void* task_data;		//ݽṹָ
	string task_errmsg;		//ַ
	int task_errcode;		//
};


///̰߳ȫĶ
template<typename Data>

class ConcurrentQueue
{
private:
	queue<Data> the_queue;								//׼
	mutable mutex the_mutex;							//boost
	condition_variable the_condition_variable;			//boost

public:

	//µ
	void push(Data const& data)
	{
		mutex::scoped_lock lock(the_mutex);				//ȡ
		the_queue.push(data);							//д
		lock.unlock();									//ͷ
		the_condition_variable.notify_one();			//֪ͨȴ߳
	}

	//ǷΪ
	bool empty() const
	{
		mutex::scoped_lock lock(the_mutex);
		return the_queue.empty();
	}

	//ȡ
	Data wait_and_pop()
	{
		mutex::scoped_lock lock(the_mutex);

		while (the_queue.empty())						//Ϊʱ
		{
			the_condition_variable.wait(lock);			//ȴ֪ͨ
		}

		Data popped_value = the_queue.front();			//ȡеһ
		the_queue.pop();								//ɾ
		return popped_value;							//ظ
	}

};


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class ShzdApi : public IShZdTradeOutLib
{
private:
	IShZdTradeInLib *api;				//API
	thread *task_thread;				//ָ߳루pythonݣ
	ConcurrentQueue<Task*> task_queue;	//

public:
	ShzdApi()
	{
		function0<void> f = boost::bind(&ShzdApi::processTask, this);
		thread t(f);
		this->task_thread = &t;
	};

	~ShzdApi()
	{
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	virtual int OnReceiveTradeInfo(const CShZdMessage * re);

	virtual int OnReceiveMarketInfo(const CShZdMessage * re);
	
	virtual int OnReceiveErrorInfo(int errorCode, const char* re);

	//-------------------------------------------------------------------------------------
	//task
	//-------------------------------------------------------------------------------------

	void processTask();

	void processTradeInfo(Task *task);

	void processMarketInfo(Task *task);

	void processErrorInfo(Task *task);


	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//idid
	//lastǷΪ󷵻
	//i
	//-------------------------------------------------------------------------------------

	virtual void onReceiveTradeInfo(dict data){};

	virtual void onReceiveMarketInfo(dict data){};

	virtual void onReceiveErrorInfo(int errcode, string errmsg){};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void release();

	int initShZdServer();

	int registerFront(string address, int port);

	int registerMarket(string address, int port);

	int shzdSendInfoToTrade(dict data);

	int shzdSendInfoToMarket(dict data);

};
