# encoding: UTF-8

defineDict = {}
typedefDict = {}

#//////////////////////////////////////////////////////////////////////
#@company shanghai liber information Technology Co.,Ltd
#@file SecurityFtdcUserApiDataType.h
#@brief 定义业务数据类型
#//////////////////////////////////////////////////////////////////////



#//////////////////////////////////////////////////////////////////////
#TFtdcErrorIDType是一个错误代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcErrorIDType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcErrorMsgType是一个错误信息类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcErrorMsgType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcExchangeIDType是一个交易所代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcExchangeIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcExchangeNameType是一个交易所名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcExchangeNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcExchangePropertyType是一个交易所属性类型
#//////////////////////////////////////////////////////////////////////
#正常
defineDict["SECURITY_FTDC_EXP_Normal"] = '0'
#根据成交生成报单
defineDict["SECURITY_FTDC_EXP_GenOrderByTrade"] = '1'

typedefDict["TSecurityFtdcExchangePropertyType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcExchangeConnectStatusType是一个交易所连接状态类型
#//////////////////////////////////////////////////////////////////////
#没有任何连接
defineDict["SECURITY_FTDC_ECS_NoConnection"] = '1'
#已经发出合约查询请求
defineDict["SECURITY_FTDC_ECS_QryInstrumentSent"] = '2'
#已经获取信息
defineDict["SECURITY_FTDC_ECS_GotInformation"] = '9'

typedefDict["TSecurityFtdcExchangeConnectStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcDateType是一个日期类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcDateType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTimeType是一个时间类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTimeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcInstrumentIDType是一个合约代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcInstrumentIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcProductNameType是一个产品名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcProductNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcProductClassType是一个产品类型类型
#//////////////////////////////////////////////////////////////////////
#期货
defineDict["SECURITY_FTDC_PC_Futures"] = '1'
#期权
defineDict["SECURITY_FTDC_PC_Options"] = '2'
#组合
defineDict["SECURITY_FTDC_PC_Combination"] = '3'
#即期
defineDict["SECURITY_FTDC_PC_Spot"] = '4'
#期转现
defineDict["SECURITY_FTDC_PC_EFP"] = '5'
#证券A股
defineDict["SECURITY_FTDC_PC_StockA"] = '6'
#证券B股
defineDict["SECURITY_FTDC_PC_StockB"] = '7'
#ETF
defineDict["SECURITY_FTDC_PC_ETF"] = '8'
#ETF申赎
defineDict["SECURITY_FTDC_PC_ETFPurRed"] = '9'

typedefDict["TSecurityFtdcProductClassType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVolumeMultipleType是一个合约数量乘数类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVolumeMultipleType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcPriceType是一个价格类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcPriceType"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcVolumeType是一个数量类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVolumeType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcPositionTypeType是一个持仓类型类型
#//////////////////////////////////////////////////////////////////////
#净持仓
defineDict["SECURITY_FTDC_PT_Net"] = '1'
#综合持仓
defineDict["SECURITY_FTDC_PT_Gross"] = '2'

typedefDict["TSecurityFtdcPositionTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPositionDateTypeType是一个持仓日期类型类型
#//////////////////////////////////////////////////////////////////////
#使用历史持仓
defineDict["SECURITY_FTDC_PDT_UseHistory"] = '1'
#不使用历史持仓
defineDict["SECURITY_FTDC_PDT_NoUseHistory"] = '2'

typedefDict["TSecurityFtdcPositionDateTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcExchangeInstIDType是一个合约在交易所的代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcExchangeInstIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcYearType是一个年份类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcYearType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcMonthType是一个月份类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcMonthType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcInstLifePhaseType是一个合约生命周期状态类型
#//////////////////////////////////////////////////////////////////////
#未上市
defineDict["SECURITY_FTDC_IP_NotStart"] = '0'
#上市
defineDict["SECURITY_FTDC_IP_Started"] = '1'
#停牌
defineDict["SECURITY_FTDC_IP_Pause"] = '2'
#到期
defineDict["SECURITY_FTDC_IP_Expired"] = '3'

typedefDict["TSecurityFtdcInstLifePhaseType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBoolType是一个布尔型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBoolType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcRightModelIDType是一个股票权限模版代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcRightModelIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcRightModelNameType是一个股票权限模版名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcRightModelNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPosTradeTypeType是一个持仓交易类型类型
#//////////////////////////////////////////////////////////////////////
#今日新增持仓能卖出
defineDict["SECURITY_FTDC_PTT_CanSelTodayPos"] = '1'
#今日新增持仓不能卖出
defineDict["SECURITY_FTDC_PTT_CannotSellTodayPos"] = '2'

typedefDict["TSecurityFtdcPosTradeTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTraderIDType是一个交易所交易员代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTraderIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcParticipantIDType是一个会员代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcParticipantIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPasswordType是一个密码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcPasswordType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBrokerIDType是一个经纪公司代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBrokerIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderLocalIDType是一个本地报单编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcOrderLocalIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBrokerAbbrType是一个经纪公司简称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBrokerAbbrType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBrokerNameType是一个经纪公司名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBrokerNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcInvestorIDType是一个投资者代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcInvestorIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPartyNameType是一个参与人名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcPartyNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcIdCardTypeType是一个证件类型类型
#//////////////////////////////////////////////////////////////////////
#组织机构代码
defineDict["SECURITY_FTDC_ICT_EID"] = '0'
#身份证
defineDict["SECURITY_FTDC_ICT_IDCard"] = '1'
#军官证
defineDict["SECURITY_FTDC_ICT_OfficerIDCard"] = '2'
#警官证
defineDict["SECURITY_FTDC_ICT_PoliceIDCard"] = '3'
#士兵证
defineDict["SECURITY_FTDC_ICT_SoldierIDCard"] = '4'
#户口簿
defineDict["SECURITY_FTDC_ICT_HouseholdRegister"] = '5'
#护照
defineDict["SECURITY_FTDC_ICT_Passport"] = '6'
#台胞证
defineDict["SECURITY_FTDC_ICT_TaiwanCompatriotIDCard"] = '7'
#回乡证
defineDict["SECURITY_FTDC_ICT_HomeComingCard"] = '8'
#营业执照号
defineDict["SECURITY_FTDC_ICT_LicenseNo"] = '9'
#税务登记号
defineDict["SECURITY_FTDC_ICT_TaxNo"] = 'A'
#其他证件
defineDict["SECURITY_FTDC_ICT_OtherCard"] = 'x'

typedefDict["TSecurityFtdcIdCardTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcIdentifiedCardNoType是一个证件号码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcIdentifiedCardNoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcClientIDType是一个交易编码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcClientIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcAccountIDType是一个投资者帐号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcAccountIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcClientTypeType是一个交易编码类型类型
#//////////////////////////////////////////////////////////////////////
#普通
defineDict["SECURITY_FTDC_CLT_Normal"] = '1'
#信用交易
defineDict["SECURITY_FTDC_CLT_Credit"] = '2'
#衍生品账户
defineDict["SECURITY_FTDC_CLT_Derive"] = '3'
#其他类型
defineDict["SECURITY_FTDC_CLT_Other"] = '4'

typedefDict["TSecurityFtdcClientTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcInvestorGroupNameType是一个投资者分组名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcInvestorGroupNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcUserIDType是一个用户代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcUserIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcUserNameType是一个用户名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcUserNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFunctionCodeType是一个功能代码类型
#//////////////////////////////////////////////////////////////////////
#强制用户登出
defineDict["SECURITY_FTDC_FC_ForceUserLogout"] = '2'
#变更管理用户口令
defineDict["SECURITY_FTDC_FC_UserPasswordUpdate"] = '3'
#变更经纪公司口令
defineDict["SECURITY_FTDC_FC_BrokerPasswordUpdate"] = '4'
#变更投资者口令
defineDict["SECURITY_FTDC_FC_InvestorPasswordUpdate"] = '5'
#报单插入
defineDict["SECURITY_FTDC_FC_OrderInsert"] = '6'
#报单操作
defineDict["SECURITY_FTDC_FC_OrderAction"] = '7'
#同步系统数据
defineDict["SECURITY_FTDC_FC_SyncSystemData"] = '8'
#同步经纪公司数据
defineDict["SECURITY_FTDC_FC_SyncBrokerData"] = '9'
#超级查询
defineDict["SECURITY_FTDC_FC_SuperQuery"] = 'B'
#报单插入
defineDict["SECURITY_FTDC_FC_ParkedOrderInsert"] = 'C'
#报单操作
defineDict["SECURITY_FTDC_FC_ParkedOrderAction"] = 'D'
#同步动态令牌
defineDict["SECURITY_FTDC_FC_SyncOTP"] = 'E'
#未知单操作
defineDict["SECURITY_FTDC_FC_UnkownOrderAction"] = 'F'
#转托管
defineDict["SECURITY_FTDC_FC_DepositoryTransfer"] = 'G'
#余券划转
defineDict["SECURITY_FTDC_FC_ExcessStockTransfer"] = 'H'

typedefDict["TSecurityFtdcFunctionCodeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcUserTypeType是一个用户类型类型
#//////////////////////////////////////////////////////////////////////
#投资者
defineDict["SECURITY_FTDC_UT_Investor"] = '0'
#操作员
defineDict["SECURITY_FTDC_UT_Operator"] = '1'
#管理员
defineDict["SECURITY_FTDC_UT_SuperUser"] = '2'

typedefDict["TSecurityFtdcUserTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBrokerFunctionCodeType是一个经纪公司功能代码类型
#//////////////////////////////////////////////////////////////////////
#强制用户登出
defineDict["SECURITY_FTDC_BFC_ForceUserLogout"] = '1'
#变更用户口令
defineDict["SECURITY_FTDC_BFC_UserPasswordUpdate"] = '2'
#同步经纪公司数据
defineDict["SECURITY_FTDC_BFC_SyncBrokerData"] = '3'
#报单插入
defineDict["SECURITY_FTDC_BFC_OrderInsert"] = '5'
#报单操作
defineDict["SECURITY_FTDC_BFC_OrderAction"] = '6'
#全部查询
defineDict["SECURITY_FTDC_BFC_AllQuery"] = '7'
#未知单操作
defineDict["SECURITY_FTDC_BFC_UnkownOrderAction"] = '8'
#转托管
defineDict["SECURITY_FTDC_BFC_DepositoryTransfer"] = '9'
#余券划转
defineDict["SECURITY_FTDC_BFC_ExcessStockTransfer"] = 'A'
#资金内转
defineDict["SECURITY_FTDC_BFC_FundInterTransfer"] = 'B'
#系统功能：登入/登出/修改密码等
defineDict["SECURITY_FTDC_BFC_log"] = 'a'
#基本查询：查询基础数据，如合约，交易所等常量
defineDict["SECURITY_FTDC_BFC_BaseQry"] = 'b'
#交易查询：如查成交，委托
defineDict["SECURITY_FTDC_BFC_TradeQry"] = 'c'
#交易功能：报单，撤单
defineDict["SECURITY_FTDC_BFC_Trade"] = 'd'
#转账
defineDict["SECURITY_FTDC_BFC_Virement"] = 'e'
#查询/管理：查询会话，踢人等
defineDict["SECURITY_FTDC_BFC_Session"] = 'g'
#同步动态令牌
defineDict["SECURITY_FTDC_BFC_SyncOTP"] = 'E'

typedefDict["TSecurityFtdcBrokerFunctionCodeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCurrencyCodeType是一个币种类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCurrencyCodeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcMoneyType是一个资金类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcMoneyType"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcRatioType是一个比率类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcRatioType"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcAccountTypeType是一个账户类型类型
#//////////////////////////////////////////////////////////////////////
#普通账户
defineDict["SECURITY_FTDC_AcT_Normal"] = '1'
#信用账户
defineDict["SECURITY_FTDC_AcT_Credit"] = '2'
#衍生品账户
defineDict["SECURITY_FTDC_AcT_Derive"] = '3'
#其他类型
defineDict["SECURITY_FTDC_AcT_Other"] = '4'

typedefDict["TSecurityFtdcAccountTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcDepartmentRangeType是一个投资者范围类型
#//////////////////////////////////////////////////////////////////////
#所有
defineDict["SECURITY_FTDC_DR_All"] = '1'
#组织架构
defineDict["SECURITY_FTDC_DR_Group"] = '2'
#单一投资者
defineDict["SECURITY_FTDC_DR_Single"] = '3'

typedefDict["TSecurityFtdcDepartmentRangeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcUserRightTypeType是一个客户权限类型类型
#//////////////////////////////////////////////////////////////////////
#登录
defineDict["SECURITY_FTDC_URT_Logon"] = '1'
#银期转帐
defineDict["SECURITY_FTDC_URT_Transfer"] = '2'
#邮寄结算单
defineDict["SECURITY_FTDC_URT_EMail"] = '3'
#传真结算单
defineDict["SECURITY_FTDC_URT_Fax"] = '4'
#条件单
defineDict["SECURITY_FTDC_URT_ConditionOrder"] = '5'

typedefDict["TSecurityFtdcUserRightTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcProductInfoType是一个产品信息类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcProductInfoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcAuthCodeType是一个客户端认证码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcAuthCodeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcLargeVolumeType是一个大额数量类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcLargeVolumeType"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcMillisecType是一个时间（毫秒）类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcMillisecType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcHedgeFlagType是一个投机套保标志类型
#//////////////////////////////////////////////////////////////////////
#投机
defineDict["SECURITY_FTDC_HF_Speculation"] = '1'
#套保
defineDict["SECURITY_FTDC_HF_Hedge"] = '3'

typedefDict["TSecurityFtdcHedgeFlagType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcDirectionType是一个买卖方向类型
#//////////////////////////////////////////////////////////////////////
#买
defineDict["SECURITY_FTDC_D_Buy"] = '0'
#卖
defineDict["SECURITY_FTDC_D_Sell"] = '1'
#ETF申购
defineDict["SECURITY_FTDC_D_ETFPur"] = '2'
#ETF赎回
defineDict["SECURITY_FTDC_D_ETFRed"] = '3'
#现金替代，只用作回报
defineDict["SECURITY_FTDC_D_CashIn"] = '4'
#债券入库
defineDict["SECURITY_FTDC_D_PledgeBondIn"] = '5'
#债券出库
defineDict["SECURITY_FTDC_D_PledgeBondOut"] = '6'
#配股
defineDict["SECURITY_FTDC_D_Rationed"] = '7'
#转托管
defineDict["SECURITY_FTDC_D_DepositoryTransfer"] = '8'
#信用账户配股
defineDict["SECURITY_FTDC_D_CreditRationed"] = '9'
#担保品买入
defineDict["SECURITY_FTDC_D_BuyCollateral"] = 'A'
#担保品卖出
defineDict["SECURITY_FTDC_D_SellCollateral"] = 'B'
#担保品转入
defineDict["SECURITY_FTDC_D_CollateralTransferIn"] = 'C'
#担保品转出
defineDict["SECURITY_FTDC_D_CollateralTransferOut"] = 'D'
#融资买入
defineDict["SECURITY_FTDC_D_MarginTrade"] = 'E'
#融券卖出
defineDict["SECURITY_FTDC_D_ShortSell"] = 'F'
#卖券还款
defineDict["SECURITY_FTDC_D_RepayMargin"] = 'G'
#买券还券
defineDict["SECURITY_FTDC_D_RepayStock"] = 'H'
#直接还款
defineDict["SECURITY_FTDC_D_DirectRepayMargin"] = 'I'
#直接还券
defineDict["SECURITY_FTDC_D_DirectRepayStock"] = 'J'
#余券划转
defineDict["SECURITY_FTDC_D_ExcessStockTransfer"] = 'K'
#OF申购
defineDict["SECURITY_FTDC_D_OFPur"] = 'L'
#OF赎回
defineDict["SECURITY_FTDC_D_OFRed"] = 'M'
#SF拆分
defineDict["SECURITY_FTDC_D_SFSplit"] = 'N'
#SF合并
defineDict["SECURITY_FTDC_D_SFMerge"] = 'O'
#备兑
defineDict["SECURITY_FTDC_D_Covered"] = 'P'
#证券冻结(开)/解冻(平)
defineDict["SECURITY_FTDC_D_Freeze"] = 'Q'
#行权
defineDict["SECURITY_FTDC_D_Execute"] = 'R'

typedefDict["TSecurityFtdcDirectionType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeIDType是一个成交编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTradeIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeTypeType是一个成交类型类型
#//////////////////////////////////////////////////////////////////////
#普通成交
defineDict["SECURITY_FTDC_TRDT_Common"] = '0'
#期权执行
defineDict["SECURITY_FTDC_TRDT_OptionsExecution"] = '1'
#OTC成交
defineDict["SECURITY_FTDC_TRDT_OTC"] = '2'
#期转现衍生成交
defineDict["SECURITY_FTDC_TRDT_EFPDerived"] = '3'
#组合衍生成交
defineDict["SECURITY_FTDC_TRDT_CombinationDerived"] = '4'
#ETF申购
defineDict["SECURITY_FTDC_TRDT_EFTPurchase"] = '5'
#ETF赎回
defineDict["SECURITY_FTDC_TRDT_EFTRedem"] = '6'

typedefDict["TSecurityFtdcTradeTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCreationredemptionStatusType是一个基金当天申购赎回状态类型
#//////////////////////////////////////////////////////////////////////
#不允许申购赎回
defineDict["SECURITY_FTDC_CDS_Forbidden"] = '0'
#表示允许申购和赎回
defineDict["SECURITY_FTDC_CDS_Allow"] = '1'
#允许申购、不允许赎回
defineDict["SECURITY_FTDC_CDS_OnlyPurchase"] = '2'
#不允许申购、允许赎回
defineDict["SECURITY_FTDC_CDS_OnlyRedeem"] = '3'

typedefDict["TSecurityFtdcCreationredemptionStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcETFCurrenceReplaceStatusType是一个ETF现金替代标志类型
#//////////////////////////////////////////////////////////////////////
#禁止现金替代
defineDict["SECURITY_FTDC_ETFCRS_Forbidden"] = '0'
#可以现金替代
defineDict["SECURITY_FTDC_ETFCRS_Allow"] = '1'
#必须现金替代
defineDict["SECURITY_FTDC_ETFCRS_Force"] = '2'

typedefDict["TSecurityFtdcETFCurrenceReplaceStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcInterestType是一个利息类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcInterestType"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcRepurchaseMaxTimesType是一个正回购放大倍数类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcRepurchaseMaxTimesType"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcCapitalStockTypeType是一个股本类型类型
#//////////////////////////////////////////////////////////////////////
#总通股本
defineDict["SECURITY_FTDC_CPTSTOCK_TOTALSTOCK"] = '1'
#流通股本
defineDict["SECURITY_FTDC_CPTSTOCK_CIRCULATION"] = '2'

typedefDict["TSecurityFtdcCapitalStockTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcMarginPriceTypeType是一个保证金价格类型类型
#//////////////////////////////////////////////////////////////////////
#昨结算价
defineDict["SECURITY_FTDC_MPT_PreSettlementPrice"] = '1'
#最新价
defineDict["SECURITY_FTDC_MPT_SettlementPrice"] = '2'
#成交均价
defineDict["SECURITY_FTDC_MPT_AveragePrice"] = '3'
#开仓价
defineDict["SECURITY_FTDC_MPT_OpenPrice"] = '4'

typedefDict["TSecurityFtdcMarginPriceTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcAlgorithmType是一个盈亏算法类型
#//////////////////////////////////////////////////////////////////////
#浮盈浮亏都计算
defineDict["SECURITY_FTDC_AG_All"] = '1'
#浮盈不计，浮亏计
defineDict["SECURITY_FTDC_AG_OnlyLost"] = '2'
#浮盈计，浮亏不计
defineDict["SECURITY_FTDC_AG_OnlyGain"] = '3'
#浮盈浮亏都不计算
defineDict["SECURITY_FTDC_AG_None"] = '4'

typedefDict["TSecurityFtdcAlgorithmType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcIncludeCloseProfitType是一个是否包含平仓盈利类型
#//////////////////////////////////////////////////////////////////////
#包含平仓盈利
defineDict["SECURITY_FTDC_ICP_Include"] = '0'
#不包含平仓盈利
defineDict["SECURITY_FTDC_ICP_NotInclude"] = '2'

typedefDict["TSecurityFtdcIncludeCloseProfitType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcAllWithoutTradeType是一个是否受可提比例限制类型
#//////////////////////////////////////////////////////////////////////
#不受可提比例限制
defineDict["SECURITY_FTDC_AWT_Enable"] = '0'
#受可提比例限制
defineDict["SECURITY_FTDC_AWT_Disable"] = '2'
#无仓不受可提比例限制
defineDict["SECURITY_FTDC_AWT_NoHoldEnable"] = '3'

typedefDict["TSecurityFtdcAllWithoutTradeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcHandlePositionAlgoIDType是一个持仓处理算法编号类型
#//////////////////////////////////////////////////////////////////////
#基本
defineDict["SECURITY_FTDC_HPA_Base"] = '1'
#非交易
defineDict["SECURITY_FTDC_HPA_NoneTrade"] = '4'
#证券
defineDict["SECURITY_FTDC_HPA_Stock"] = '5'

typedefDict["TSecurityFtdcHandlePositionAlgoIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeParamIDType是一个交易系统参数代码类型
#//////////////////////////////////////////////////////////////////////
#系统加密算法
defineDict["SECURITY_FTDC_TPID_EncryptionStandard"] = 'E'
#用户最大会话数
defineDict["SECURITY_FTDC_TPID_SingleUserSessionMaxNum"] = 'S'
#最大连续登录失败数
defineDict["SECURITY_FTDC_TPID_LoginFailMaxNum"] = 'L'
#是否强制认证
defineDict["SECURITY_FTDC_TPID_IsAuthForce"] = 'A'
#是否生成用户事件
defineDict["SECURITY_FTDC_TPID_GenUserEvent"] = 'G'
#起始报单本地编号
defineDict["SECURITY_FTDC_TPID_StartOrderLocalID"] = 'O'
#融资融券买券还券算法
defineDict["SECURITY_FTDC_TPID_RepayStockAlgo"] = 'R'
#衍生品账户资金提取线
defineDict["SECURITY_FTDC_TPID_DeriveWithdrawRatio"] = 'D'

typedefDict["TSecurityFtdcTradeParamIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcSettlementParamValueType是一个参数代码值类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcSettlementParamValueType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcMemoType是一个备注类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcMemoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPriorityType是一个优先级类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcPriorityType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderRefType是一个报单引用类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcOrderRefType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcMarketIDType是一个市场代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcMarketIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcMacAddressType是一个Mac地址类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcMacAddressType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcInstrumentNameType是一个合约名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcInstrumentNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderSysIDType是一个报单编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcOrderSysIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcIPAddressType是一个IP地址类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcIPAddressType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcIPPortType是一个IP端口类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcIPPortType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcProtocolInfoType是一个协议信息类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcProtocolInfoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcDepositSeqNoType是一个出入金流水号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcDepositSeqNoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcSystemNameType是一个系统名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcSystemNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcInvestorRangeType是一个投资者范围类型
#//////////////////////////////////////////////////////////////////////
#所有
defineDict["SECURITY_FTDC_IR_All"] = '1'
#投资者组
defineDict["SECURITY_FTDC_IR_Group"] = '2'
#单一投资者
defineDict["SECURITY_FTDC_IR_Single"] = '3'

typedefDict["TSecurityFtdcInvestorRangeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcDataSyncStatusType是一个数据同步状态类型
#//////////////////////////////////////////////////////////////////////
#未同步
defineDict["SECURITY_FTDC_DS_Asynchronous"] = '1'
#同步中
defineDict["SECURITY_FTDC_DS_Synchronizing"] = '2'
#已同步
defineDict["SECURITY_FTDC_DS_Synchronized"] = '3'

typedefDict["TSecurityFtdcDataSyncStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTraderConnectStatusType是一个交易所交易员连接状态类型
#//////////////////////////////////////////////////////////////////////
#没有任何连接
defineDict["SECURITY_FTDC_TCS_NotConnected"] = '1'
#已经连接
defineDict["SECURITY_FTDC_TCS_Connected"] = '2'
#已经发出合约查询请求
defineDict["SECURITY_FTDC_TCS_QryInstrumentSent"] = '3'
#订阅私有流
defineDict["SECURITY_FTDC_TCS_SubPrivateFlow"] = '4'

typedefDict["TSecurityFtdcTraderConnectStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderActionStatusType是一个报单操作状态类型
#//////////////////////////////////////////////////////////////////////
#已经提交
defineDict["SECURITY_FTDC_OAS_Submitted"] = 'a'
#已经接受
defineDict["SECURITY_FTDC_OAS_Accepted"] = 'b'
#已经被拒绝
defineDict["SECURITY_FTDC_OAS_Rejected"] = 'c'

typedefDict["TSecurityFtdcOrderActionStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderStatusType是一个报单状态类型
#//////////////////////////////////////////////////////////////////////
#全部成交
defineDict["SECURITY_FTDC_OST_AllTraded"] = '0'
#部分成交还在队列中
defineDict["SECURITY_FTDC_OST_PartTradedQueueing"] = '1'
#部分成交不在队列中
defineDict["SECURITY_FTDC_OST_PartTradedNotQueueing"] = '2'
#未成交还在队列中
defineDict["SECURITY_FTDC_OST_NoTradeQueueing"] = '3'
#未成交不在队列中
defineDict["SECURITY_FTDC_OST_NoTradeNotQueueing"] = '4'
#撤单
defineDict["SECURITY_FTDC_OST_Canceled"] = '5'
#未知
defineDict["SECURITY_FTDC_OST_Unknown"] = 'a'
#尚未触发
defineDict["SECURITY_FTDC_OST_NotTouched"] = 'b'
#已触发
defineDict["SECURITY_FTDC_OST_Touched"] = 'c'

typedefDict["TSecurityFtdcOrderStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderSubmitStatusType是一个报单提交状态类型
#//////////////////////////////////////////////////////////////////////
#已经提交
defineDict["SECURITY_FTDC_OSS_InsertSubmitted"] = '0'
#撤单已经提交
defineDict["SECURITY_FTDC_OSS_CancelSubmitted"] = '1'
#修改已经提交
defineDict["SECURITY_FTDC_OSS_ModifySubmitted"] = '2'
#已经接受
defineDict["SECURITY_FTDC_OSS_Accepted"] = '3'
#报单已经被拒绝
defineDict["SECURITY_FTDC_OSS_InsertRejected"] = '4'
#撤单已经被拒绝
defineDict["SECURITY_FTDC_OSS_CancelRejected"] = '5'
#改单已经被拒绝
defineDict["SECURITY_FTDC_OSS_ModifyRejected"] = '6'

typedefDict["TSecurityFtdcOrderSubmitStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPositionDateType是一个持仓日期类型
#//////////////////////////////////////////////////////////////////////
#今日持仓
defineDict["SECURITY_FTDC_PSD_Today"] = '1'
#历史持仓
defineDict["SECURITY_FTDC_PSD_History"] = '2'

typedefDict["TSecurityFtdcPositionDateType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradingRoleType是一个交易角色类型
#//////////////////////////////////////////////////////////////////////
#代理
defineDict["SECURITY_FTDC_ER_Broker"] = '1'
#自营
defineDict["SECURITY_FTDC_ER_Host"] = '2'
#做市商
defineDict["SECURITY_FTDC_ER_Maker"] = '3'

typedefDict["TSecurityFtdcTradingRoleType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPosiDirectionType是一个持仓多空方向类型
#//////////////////////////////////////////////////////////////////////
#净
defineDict["SECURITY_FTDC_PD_Net"] = '1'
#多头
defineDict["SECURITY_FTDC_PD_Long"] = '2'
#空头
defineDict["SECURITY_FTDC_PD_Short"] = '3'
#备兑
defineDict["SECURITY_FTDC_PD_Covered"] = '4'

typedefDict["TSecurityFtdcPosiDirectionType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderPriceTypeType是一个报单价格条件类型
#//////////////////////////////////////////////////////////////////////
#即时成交剩余撤销市价单
defineDict["SECURITY_FTDC_OPT_AnyPrice"] = '1'
#限价
defineDict["SECURITY_FTDC_OPT_LimitPrice"] = '2'
#最优五档即时成交剩余撤销市价单
defineDict["SECURITY_FTDC_OPT_BestPrice"] = '3'
#最优五档即时成交剩余转限价市价单
defineDict["SECURITY_FTDC_OPT_BestLimitPrice"] = '4'
#全部成交或撤销市价单
defineDict["SECURITY_FTDC_OPT_AllPrice"] = '5'
#本方最优价格市价单
defineDict["SECURITY_FTDC_OPT_ForwardBestPrice"] = '6'
#对方最优价格市价单
defineDict["SECURITY_FTDC_OPT_ReverseBestPrice"] = '7'
#即时成交剩余转限价市价单
defineDict["SECURITY_FTDC_OPT_Any2LimitPrice"] = '8'
#全部成交或撤销限价单
defineDict["SECURITY_FTDC_OPT_AllLimitPrice"] = '9'
#激活A股网络密码服务代码
defineDict["SECURITY_FTDC_OPT_ActiveANetPassSvrCode"] = 'G'
#注销A股网络密码服务代码
defineDict["SECURITY_FTDC_OPT_InactiveANetPassSvrCode"] = 'H'
#激活B股网络密码服务代码
defineDict["SECURITY_FTDC_OPT_ActiveBNetPassSvrCode"] = 'I'
#注销B股网络密码服务代码
defineDict["SECURITY_FTDC_OPT_InactiveBNetPassSvrCode"] = 'J'
#回购注销
defineDict["SECURITY_FTDC_OPT_Repurchase"] = 'K'
#指定撤销
defineDict["SECURITY_FTDC_OPT_DesignatedCancel"] = 'L'
#指定登记
defineDict["SECURITY_FTDC_OPT_Designated"] = 'M'
#证券参与申购
defineDict["SECURITY_FTDC_OPT_SubscribingShares"] = 'N'
#证券参与配股
defineDict["SECURITY_FTDC_OPT_Split"] = 'O'
#要约收购登记
defineDict["SECURITY_FTDC_OPT_TenderOffer"] = 'P'
#要约收购撤销
defineDict["SECURITY_FTDC_OPT_TenderOfferCancel"] = 'Q'
#证券投票
defineDict["SECURITY_FTDC_OPT_Ballot"] = 'R'
#可转债转换登记
defineDict["SECURITY_FTDC_OPT_ConvertibleBondsConvet"] = 'S'
#可转债回售登记
defineDict["SECURITY_FTDC_OPT_ConvertibleBondsRepurchase"] = 'T'
#权证行权
defineDict["SECURITY_FTDC_OPT_Exercise"] = 'U'
#开放式基金申购
defineDict["SECURITY_FTDC_OPT_PurchasingFunds"] = 'V'
#开放式基金赎回
defineDict["SECURITY_FTDC_OPT_RedemingFunds"] = 'W'
#开放式基金认购
defineDict["SECURITY_FTDC_OPT_SubscribingFunds"] = 'X'
#开放式基金转托管转出
defineDict["SECURITY_FTDC_OPT_LOFIssue"] = 'Y'
#开放式基金设置分红方式
defineDict["SECURITY_FTDC_OPT_LOFSetBonusType"] = 'Z'
#开放式基金转换为其他基金
defineDict["SECURITY_FTDC_OPT_LOFConvert"] = 'a'
#债券入库
defineDict["SECURITY_FTDC_OPT_DebentureStockIn"] = 'b'
#债券出库
defineDict["SECURITY_FTDC_OPT_DebentureStockOut"] = 'c'
#ETF申购
defineDict["SECURITY_FTDC_OPT_PurchasesETF"] = 'd'
#ETF赎回
defineDict["SECURITY_FTDC_OPT_RedeemETF"] = 'e'

typedefDict["TSecurityFtdcOrderPriceTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOffsetFlagType是一个开平标志类型
#//////////////////////////////////////////////////////////////////////
#开仓
defineDict["SECURITY_FTDC_OF_Open"] = '0'
#平仓
defineDict["SECURITY_FTDC_OF_Close"] = '1'
#强平
defineDict["SECURITY_FTDC_OF_ForceClose"] = '2'
#平今
defineDict["SECURITY_FTDC_OF_CloseToday"] = '3'
#平昨
defineDict["SECURITY_FTDC_OF_CloseYesterday"] = '4'
#强减
defineDict["SECURITY_FTDC_OF_ForceOff"] = '5'
#本地强平
defineDict["SECURITY_FTDC_OF_LocalForceClose"] = '6'

typedefDict["TSecurityFtdcOffsetFlagType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcForceCloseReasonType是一个强平原因类型
#//////////////////////////////////////////////////////////////////////
#非强平
defineDict["SECURITY_FTDC_FCC_NotForceClose"] = '0'
#资金不足
defineDict["SECURITY_FTDC_FCC_LackDeposit"] = '1'
#客户超仓
defineDict["SECURITY_FTDC_FCC_ClientOverPositionLimit"] = '2'
#会员超仓
defineDict["SECURITY_FTDC_FCC_MemberOverPositionLimit"] = '3'
#持仓非整数倍
defineDict["SECURITY_FTDC_FCC_NotMultiple"] = '4'
#违规
defineDict["SECURITY_FTDC_FCC_Violation"] = '5'
#其它
defineDict["SECURITY_FTDC_FCC_Other"] = '6'
#自然人临近交割
defineDict["SECURITY_FTDC_FCC_PersonDeliv"] = '7'

typedefDict["TSecurityFtdcForceCloseReasonType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderTypeType是一个报单类型类型
#//////////////////////////////////////////////////////////////////////
#正常
defineDict["SECURITY_FTDC_ORDT_Normal"] = '0'
#报价衍生
defineDict["SECURITY_FTDC_ORDT_DeriveFromQuote"] = '1'
#组合衍生
defineDict["SECURITY_FTDC_ORDT_DeriveFromCombination"] = '2'
#组合报单
defineDict["SECURITY_FTDC_ORDT_Combination"] = '3'
#条件单
defineDict["SECURITY_FTDC_ORDT_ConditionalOrder"] = '4'
#互换单
defineDict["SECURITY_FTDC_ORDT_Swap"] = '5'

typedefDict["TSecurityFtdcOrderTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTimeConditionType是一个有效期类型类型
#//////////////////////////////////////////////////////////////////////
#立即完成，否则撤销
defineDict["SECURITY_FTDC_TC_IOC"] = '1'
#本节有效
defineDict["SECURITY_FTDC_TC_GFS"] = '2'
#当日有效
defineDict["SECURITY_FTDC_TC_GFD"] = '3'
#指定日期前有效
defineDict["SECURITY_FTDC_TC_GTD"] = '4'
#撤销前有效
defineDict["SECURITY_FTDC_TC_GTC"] = '5'
#集合竞价有效
defineDict["SECURITY_FTDC_TC_GFA"] = '6'

typedefDict["TSecurityFtdcTimeConditionType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVolumeConditionType是一个成交量类型类型
#//////////////////////////////////////////////////////////////////////
#任何数量
defineDict["SECURITY_FTDC_VC_AV"] = '1'
#最小数量
defineDict["SECURITY_FTDC_VC_MV"] = '2'
#全部数量
defineDict["SECURITY_FTDC_VC_CV"] = '3'

typedefDict["TSecurityFtdcVolumeConditionType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcContingentConditionType是一个触发条件类型
#//////////////////////////////////////////////////////////////////////
#立即
defineDict["SECURITY_FTDC_CC_Immediately"] = '1'
#止损
defineDict["SECURITY_FTDC_CC_Touch"] = '2'
#止赢
defineDict["SECURITY_FTDC_CC_TouchProfit"] = '3'
#预埋单
defineDict["SECURITY_FTDC_CC_ParkedOrder"] = '4'
#最新价大于条件价
defineDict["SECURITY_FTDC_CC_LastPriceGreaterThanStopPrice"] = '5'
#最新价大于等于条件价
defineDict["SECURITY_FTDC_CC_LastPriceGreaterEqualStopPrice"] = '6'
#最新价小于条件价
defineDict["SECURITY_FTDC_CC_LastPriceLesserThanStopPrice"] = '7'
#最新价小于等于条件价
defineDict["SECURITY_FTDC_CC_LastPriceLesserEqualStopPrice"] = '8'
#卖一价大于条件价
defineDict["SECURITY_FTDC_CC_AskPriceGreaterThanStopPrice"] = '9'
#卖一价大于等于条件价
defineDict["SECURITY_FTDC_CC_AskPriceGreaterEqualStopPrice"] = 'A'
#卖一价小于条件价
defineDict["SECURITY_FTDC_CC_AskPriceLesserThanStopPrice"] = 'B'
#卖一价小于等于条件价
defineDict["SECURITY_FTDC_CC_AskPriceLesserEqualStopPrice"] = 'C'
#买一价大于条件价
defineDict["SECURITY_FTDC_CC_BidPriceGreaterThanStopPrice"] = 'D'
#买一价大于等于条件价
defineDict["SECURITY_FTDC_CC_BidPriceGreaterEqualStopPrice"] = 'E'
#买一价小于条件价
defineDict["SECURITY_FTDC_CC_BidPriceLesserThanStopPrice"] = 'F'
#买一价小于等于条件价
defineDict["SECURITY_FTDC_CC_BidPriceLesserEqualStopPrice"] = 'H'

typedefDict["TSecurityFtdcContingentConditionType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcActionFlagType是一个操作标志类型
#//////////////////////////////////////////////////////////////////////
#删除
defineDict["SECURITY_FTDC_AF_Delete"] = '0'
#修改
defineDict["SECURITY_FTDC_AF_Modify"] = '3'

typedefDict["TSecurityFtdcActionFlagType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradingRightType是一个交易权限类型
#//////////////////////////////////////////////////////////////////////
#可以交易
defineDict["SECURITY_FTDC_TR_Allow"] = '0'
#不能交易
defineDict["SECURITY_FTDC_TR_Forbidden"] = '2'

typedefDict["TSecurityFtdcTradingRightType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderSourceType是一个报单来源类型
#//////////////////////////////////////////////////////////////////////
#来自参与者
defineDict["SECURITY_FTDC_OSRC_Participant"] = '0'
#来自管理员
defineDict["SECURITY_FTDC_OSRC_Administrator"] = '1'

typedefDict["TSecurityFtdcOrderSourceType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPriceSourceType是一个成交价来源类型
#//////////////////////////////////////////////////////////////////////
#前成交价
defineDict["SECURITY_FTDC_PSRC_LastPrice"] = '0'
#买委托价
defineDict["SECURITY_FTDC_PSRC_Buy"] = '1'
#卖委托价
defineDict["SECURITY_FTDC_PSRC_Sell"] = '2'

typedefDict["TSecurityFtdcPriceSourceType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOrderActionRefType是一个报单操作引用类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcOrderActionRefType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcFrontIDType是一个前置编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcFrontIDType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcSessionIDType是一个会话编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcSessionIDType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcInstallIDType是一个安装编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcInstallIDType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcSequenceNoType是一个序号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcSequenceNoType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcRequestIDType是一个请求编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcRequestIDType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcCombOffsetFlagType是一个组合开平标志类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCombOffsetFlagType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCombHedgeFlagType是一个组合投机套保标志类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCombHedgeFlagType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcSequenceSeriesType是一个序列系列号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcSequenceSeriesType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcCommPhaseNoType是一个通讯时段编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCommPhaseNoType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcUserEventTypeType是一个用户事件类型类型
#//////////////////////////////////////////////////////////////////////
#登录
defineDict["SECURITY_FTDC_UET_Login"] = '1'
#登出
defineDict["SECURITY_FTDC_UET_Logout"] = '2'
#交易成功
defineDict["SECURITY_FTDC_UET_Trading"] = '3'
#交易失败
defineDict["SECURITY_FTDC_UET_TradingError"] = '4'
#修改密码
defineDict["SECURITY_FTDC_UET_UpdatePassword"] = '5'
#客户端认证
defineDict["SECURITY_FTDC_UET_Authenticate"] = '6'
#其他
defineDict["SECURITY_FTDC_UET_Other"] = '9'

typedefDict["TSecurityFtdcUserEventTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcUserEventInfoType是一个用户事件信息类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcUserEventInfoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOTPTypeType是一个动态令牌类型类型
#//////////////////////////////////////////////////////////////////////
#无动态令牌
defineDict["SECURITY_FTDC_OTP_NONE"] = '0'
#时间令牌
defineDict["SECURITY_FTDC_OTP_TOTP"] = '1'

typedefDict["TSecurityFtdcOTPTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeSourceType是一个成交来源类型
#//////////////////////////////////////////////////////////////////////
#来自交易所普通回报
defineDict["SECURITY_FTDC_TSRC_NORMAL"] = '0'
#来自查询
defineDict["SECURITY_FTDC_TSRC_QUERY"] = '1'

typedefDict["TSecurityFtdcTradeSourceType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBranchIDType是一个营业部编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBranchIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcStockPriceType是一个证券交易价格类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcStockPriceType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcRightModelIDType是一个股票权限模版代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcRightModelIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcSerialNumberType是一个序列号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcSerialNumberType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcInstrumentRangeType是一个股票权限分类类型
#//////////////////////////////////////////////////////////////////////
#所有
defineDict["SECURITY_FTDC_INR_All"] = '1'
#产品
defineDict["SECURITY_FTDC_INR_Product"] = '2'
#股票权限模版
defineDict["SECURITY_FTDC_INR_Model"] = '3'
#股票
defineDict["SECURITY_FTDC_INR_Stock"] = '4'
#市场
defineDict["SECURITY_FTDC_INR_Market"] = '5'

typedefDict["TSecurityFtdcInstrumentRangeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBusinessUnitType是一个业务单元类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBusinessUnitType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOTPVendorsIDType是一个动态令牌提供商类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcOTPVendorsIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcLastDriftType是一个上次OTP漂移值类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcLastDriftType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcLastSuccessType是一个上次OTP成功值类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcLastSuccessType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcAuthKeyType是一个令牌密钥类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcAuthKeyType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcUserSessionHashType是一个用户会话Hash值类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcUserSessionHashType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcStockTradeTypeType是一个证券交易类型类型
#//////////////////////////////////////////////////////////////////////
#可交易证券
defineDict["SECURITY_FTDC_STT_Stock"] = '0'
#买入网络密码服务
defineDict["SECURITY_FTDC_STT_BuyNetService"] = '1'
#回购注销
defineDict["SECURITY_FTDC_STT_CancelRepurchase"] = '2'
#指定撤销
defineDict["SECURITY_FTDC_STT_CancelRegister"] = '3'
#指定登记
defineDict["SECURITY_FTDC_STT_Register"] = '4'
#买入发行申购
defineDict["SECURITY_FTDC_STT_PurchaseIssue"] = '5'
#卖出配股
defineDict["SECURITY_FTDC_STT_Allotment"] = '6'
#卖出要约收购
defineDict["SECURITY_FTDC_STT_SellTender"] = '7'
#买入要约收购
defineDict["SECURITY_FTDC_STT_BuyTender"] = '8'
#网上投票
defineDict["SECURITY_FTDC_STT_NetVote"] = '9'
#卖出可转债回售
defineDict["SECURITY_FTDC_STT_SellConvertibleBonds"] = 'a'
#权证行权代码
defineDict["SECURITY_FTDC_STT_OptionExecute"] = 'b'
#开放式基金申购
defineDict["SECURITY_FTDC_STT_PurchaseOF"] = 'c'
#开放式基金赎回
defineDict["SECURITY_FTDC_STT_RedeemOF"] = 'd'
#开放式基金认购
defineDict["SECURITY_FTDC_STT_SubscribeOF"] = 'e'
#开放式基金转托管转出
defineDict["SECURITY_FTDC_STT_OFCustodianTranfer"] = 'f'
#开放式基金分红设置
defineDict["SECURITY_FTDC_STT_OFDividendConfig"] = 'g'
#开放式基金转成其他基金
defineDict["SECURITY_FTDC_STT_OFTransfer"] = 'h'
#债券入库
defineDict["SECURITY_FTDC_STT_BondsIn"] = 'i'
#债券出库
defineDict["SECURITY_FTDC_STT_BondsOut"] = 'j'
#EFT申购
defineDict["SECURITY_FTDC_STT_PurchaseETF"] = 'k'
#EFT赎回
defineDict["SECURITY_FTDC_STT_RedeemETF"] = 'l'
#可转债回售登记
defineDict["SECURITY_FTDC_STT_ConvertibleRegister"] = 'm'

typedefDict["TSecurityFtdcStockTradeTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcHandleTradingAccountAlgoIDType是一个资金处理算法编号类型
#//////////////////////////////////////////////////////////////////////
#基本
defineDict["SECURITY_FTDC_HTAA_Base"] = '1'

typedefDict["TSecurityFtdcHandleTradingAccountAlgoIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcStockWthType是一个股票使用流水号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcStockWthType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcStockSeqType是一个股票使用流水号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcStockSeqType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcWTFSType是一个委托方式类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcWTFSType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcWTLBType是一个委托类别类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcWTLBType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcWTRQType是一个委托日期类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcWTRQType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcINTEGERType是一个一般整型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcINTEGERType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcINT3Type是一个三位数整型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcINT3Type"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcINT6Type是一个六位数整型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcINT6Type"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcINT12Type是一个十二位数整型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcINT12Type"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR1Type是一个一字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR1Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR2Type是一个二字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR2Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR3Type是一个三字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR3Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR4Type是一个四字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR4Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR5Type是一个五字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR5Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR6Type是一个六字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR6Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR8Type是一个八字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR8Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR10Type是一个十字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR10Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR11Type是一个十一字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR11Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR12Type是一个十二字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR12Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR13Type是一个十三字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR13Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR14Type是一个十四字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR14Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR16Type是一个十六字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR16Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR19Type是一个十九字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR19Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR20Type是一个二十字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR20Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR21Type是一个二十一字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR21Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR23Type是一个二十三字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR23Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR30Type是一个三十字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR30Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR32Type是一个三十二字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR32Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR50Type是一个五十字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR50Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR64Type是一个六十四字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR64Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCHAR65Type是一个六十五字节CHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCHAR65Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR4Type是一个四字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR4Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR6Type是一个六字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR6Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR8Type是一个八字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR8Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR10Type是一个十字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR10Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR12Type是一个十二字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR12Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR16Type是一个十六字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR16Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR20Type是一个二十字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR20Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR30Type是一个三十字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR30Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR50Type是一个五十字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR50Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR60Type是一个六十字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR60Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR65Type是一个六十五字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR65Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR80Type是一个八十字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR80Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR84Type是一个八十四字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR84Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR255Type是一个二五五字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR255Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcVCHAR1024Type是一个一零二四字节VCHAR类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcVCHAR1024Type"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcREAL8P3Type是一个八点三实型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcREAL8P3Type"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcREAL9P3Type是一个九点三实型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcREAL9P3Type"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcREAL9P6Type是一个九点六实型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcREAL9P6Type"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcREAL10P4Type是一个十点四实型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcREAL10P4Type"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcREAL16P2Type是一个十六点二实型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcREAL16P2Type"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcREAL16P8Type是一个十六点八实型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcREAL16P8Type"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcREAL22P2Type是一个二十二点二实型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcREAL22P2Type"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcCommandNoType是一个DB命令序号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCommandNoType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcCommandTypeType是一个DB命令类型类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCommandTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcSettlementGroupIDType是一个结算组代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcSettlementGroupIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFieldNameType是一个字段名类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcFieldNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFieldContentType是一个字段内容类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcFieldContentType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBankIDType是一个银行代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBankIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBankNameType是一个银行名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBankNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBankBrchIDType是一个银行分中心代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBankBrchIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcLiberSerialType是一个Liber系统流水号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcLiberSerialType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcRoleIDType是一个角色编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcRoleIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcRoleNameType是一个角色名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcRoleNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcDescriptionType是一个描述类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcDescriptionType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFunctionIDType是一个功能代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcFunctionIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBillNoType是一个票据号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBillNoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFundIOTypeType是一个出入金类型类型
#//////////////////////////////////////////////////////////////////////
#出入金
defineDict["SECURITY_FTDC_FIOT_FundIO"] = '1'
#银期转帐
defineDict["SECURITY_FTDC_FIOT_Transfer"] = '2'

typedefDict["TSecurityFtdcFundIOTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFundTypeType是一个资金类型类型
#//////////////////////////////////////////////////////////////////////
#银行存款
defineDict["SECURITY_FTDC_FT_Deposite"] = '1'
#分项资金
defineDict["SECURITY_FTDC_FT_ItemFund"] = '2'
#公司调整
defineDict["SECURITY_FTDC_FT_Company"] = '3'

typedefDict["TSecurityFtdcFundTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFundDirectionType是一个出入金方向类型
#//////////////////////////////////////////////////////////////////////
#入金
defineDict["SECURITY_FTDC_FD_In"] = '1'
#出金
defineDict["SECURITY_FTDC_FD_Out"] = '2'

typedefDict["TSecurityFtdcFundDirectionType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBankFlagType是一个银行统一标识类型类型
#//////////////////////////////////////////////////////////////////////
#工商银行
defineDict["SECURITY_FTDC_BF_ICBC"] = '1'
#农业银行
defineDict["SECURITY_FTDC_BF_ABC"] = '2'
#中国银行
defineDict["SECURITY_FTDC_BF_BC"] = '3'
#建设银行
defineDict["SECURITY_FTDC_BF_CBC"] = '4'
#交通银行
defineDict["SECURITY_FTDC_BF_BOC"] = '5'
#其他银行
defineDict["SECURITY_FTDC_BF_Other"] = 'Z'

typedefDict["TSecurityFtdcBankFlagType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOperationMemoType是一个操作摘要类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcOperationMemoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFundStatusType是一个资金状态类型
#//////////////////////////////////////////////////////////////////////
#已录入
defineDict["SECURITY_FTDC_FS_Record"] = '1'
#已复核
defineDict["SECURITY_FTDC_FS_Check"] = '2'
#已冲销
defineDict["SECURITY_FTDC_FS_Charge"] = '3'

typedefDict["TSecurityFtdcFundStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFundProjectIDType是一个资金项目编号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcFundProjectIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOperatorIDType是一个操作员代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcOperatorIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCounterIDType是一个计数器代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCounterIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFunctionNameType是一个功能名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcFunctionNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeCodeType是一个交易代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTradeCodeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBrokerBranchIDType是一个经纪公司分支机构代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBrokerBranchIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeDateType是一个交易日期类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTradeDateType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeTimeType是一个交易时间类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTradeTimeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBankSerialType是一个银行流水号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBankSerialType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcSerialType是一个流水号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcSerialType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcLastFragmentType是一个最后分片标志类型
#//////////////////////////////////////////////////////////////////////
#是最后分片
defineDict["SECURITY_FTDC_LF_Yes"] = '0'
#不是最后分片
defineDict["SECURITY_FTDC_LF_No"] = '1'

typedefDict["TSecurityFtdcLastFragmentType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcIndividualNameType是一个个人姓名类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcIndividualNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCustTypeType是一个客户类型类型
#//////////////////////////////////////////////////////////////////////
#自然人
defineDict["SECURITY_FTDC_CUSTT_Person"] = '0'
#机构户
defineDict["SECURITY_FTDC_CUSTT_Institution"] = '1'

typedefDict["TSecurityFtdcCustTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBankAccountType是一个银行账户类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBankAccountType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcYesNoIndicatorType是一个是或否标识类型
#//////////////////////////////////////////////////////////////////////
#是
defineDict["SECURITY_FTDC_YNI_Yes"] = '0'
#否
defineDict["SECURITY_FTDC_YNI_No"] = '1'

typedefDict["TSecurityFtdcYesNoIndicatorType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeAmountType是一个交易金额（元）类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTradeAmountType"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcCustFeeType是一个应收客户费用（元）类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcCustFeeType"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcBrokerFeeType是一个应收经纪公司费用（元）类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBrokerFeeType"] = "float"

#//////////////////////////////////////////////////////////////////////
#TFtdcFeePayFlagType是一个费用支付标志类型
#//////////////////////////////////////////////////////////////////////
#由受益方支付费用
defineDict["SECURITY_FTDC_FPF_BEN"] = '0'
#由发送方支付费用
defineDict["SECURITY_FTDC_FPF_OUR"] = '1'
#由发送方支付发起的费用，受益方支付接受的费用
defineDict["SECURITY_FTDC_FPF_SHA"] = '2'

typedefDict["TSecurityFtdcFeePayFlagType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcAddInfoType是一个附加信息类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcAddInfoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcDigestType是一个摘要类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcDigestType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBankAccTypeType是一个银行帐号类型类型
#//////////////////////////////////////////////////////////////////////
#银行存折
defineDict["SECURITY_FTDC_BAT_BankBook"] = '1'
#储蓄卡
defineDict["SECURITY_FTDC_BAT_SavingCard"] = '2'
#信用卡
defineDict["SECURITY_FTDC_BAT_CreditCard"] = '3'

typedefDict["TSecurityFtdcBankAccTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcDeviceIDType是一个渠道标志类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcDeviceIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPwdFlagType是一个密码核对标志类型
#//////////////////////////////////////////////////////////////////////
#不核对
defineDict["SECURITY_FTDC_BPWDF_NoCheck"] = '0'
#明文核对
defineDict["SECURITY_FTDC_BPWDF_BlankCheck"] = '1'
#密文核对
defineDict["SECURITY_FTDC_BPWDF_EncryptCheck"] = '2'

typedefDict["TSecurityFtdcPwdFlagType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcBankCodingForBrokerType是一个银行对经纪公司的编码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcBankCodingForBrokerType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOperNoType是一个交易柜员类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcOperNoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTIDType是一个交易ID类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTIDType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcTransferStatusType是一个转账交易状态类型
#//////////////////////////////////////////////////////////////////////
#正常
defineDict["SECURITY_FTDC_TRFS_Normal"] = '0'
#被冲正
defineDict["SECURITY_FTDC_TRFS_Repealed"] = '1'

typedefDict["TSecurityFtdcTransferStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcPlateSerialType是一个平台流水号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcPlateSerialType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcAvailabilityFlagType是一个有效标志类型
#//////////////////////////////////////////////////////////////////////
#未确认
defineDict["SECURITY_FTDC_AVAF_Invalid"] = '0'
#有效
defineDict["SECURITY_FTDC_AVAF_Valid"] = '1'
#冲正
defineDict["SECURITY_FTDC_AVAF_Repeal"] = '2'

typedefDict["TSecurityFtdcAvailabilityFlagType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcOperatorCodeType是一个操作员类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcOperatorCodeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcRepayStockAlgoType是一个买券还券算法类型
#//////////////////////////////////////////////////////////////////////
#默认算法
defineDict["SECURITY_FTDC_RSA_Original"] = '0'
#按还券比例计算
defineDict["SECURITY_FTDC_RSA_Ratio"] = '1'
#Min[1,2]
defineDict["SECURITY_FTDC_RSA_Min"] = '2'

typedefDict["TSecurityFtdcRepayStockAlgoType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeSpanType是一个交易时间段类型类型
#//////////////////////////////////////////////////////////////////////
#普通业务
defineDict["SECURITY_FTDC_TS_Common"] = '1'
#个股期权
defineDict["SECURITY_FTDC_TS_Options"] = '2'

typedefDict["TSecurityFtdcTradeSpanType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcSettleSystemTypeType是一个所属结算系统类型类型
#//////////////////////////////////////////////////////////////////////
#顶点系统
defineDict["SECURITY_FTDC_SST_Aboss"] = '1'
#恒生系统
defineDict["SECURITY_FTDC_SST_HS"] = '2'

typedefDict["TSecurityFtdcSettleSystemTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcLogLevelType是一个日志级别类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcLogLevelType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcProcessNameType是一个存储过程名称类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcProcessNameType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTemplateIDType是一个模板代码类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTemplateIDType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcTradeIndexType是一个成交序号类型
#//////////////////////////////////////////////////////////////////////
typedefDict["TSecurityFtdcTradeIndexType"] = "int"

#//////////////////////////////////////////////////////////////////////
#TFtdcSplitMergeStatusType是一个基金当天拆分合并状态类型
#//////////////////////////////////////////////////////////////////////
#表示允许拆分和合并
defineDict["SECURITY_FTDC_SMS_Allow"] = '0'
#允许拆分、不允许合并
defineDict["SECURITY_FTDC_SMS_OnlySplit"] = '1'
#不允许拆分、允许合并
defineDict["SECURITY_FTDC_SMS_OnlyMerge"] = '2'
#不允许拆分和合并
defineDict["SECURITY_FTDC_SMS_Forbidden"] = '3'

typedefDict["TSecurityFtdcSplitMergeStatusType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcFundInterTransferTypeType是一个资金内转类型类型
#//////////////////////////////////////////////////////////////////////
#转入
defineDict["SECURITY_FTDC_FITT_TransferIn"] = '0'
#转出
defineDict["SECURITY_FTDC_FITT_TransferOut"] = '1'

typedefDict["TSecurityFtdcFundInterTransferTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcInstrumentTypeType是一个合约类型类型
#//////////////////////////////////////////////////////////////////////
#普通
defineDict["SECURITY_FTDC_IT_Normal"] = '0'
#看涨期权
defineDict["SECURITY_FTDC_IT_CallOptions"] = '1'
#看跌期权
defineDict["SECURITY_FTDC_IT_PutOptions"] = '2'

typedefDict["TSecurityFtdcInstrumentTypeType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcInvestorLevelType是一个投资者期权交易等级类型
#//////////////////////////////////////////////////////////////////////
#一级
defineDict["SECURITY_FTDC_IL_Level_1"] = '0'
#二级
defineDict["SECURITY_FTDC_IL_Level_2"] = '1'
#三级
defineDict["SECURITY_FTDC_IL_Level_3"] = '2'

typedefDict["TSecurityFtdcInvestorLevelType"] = "string"

#//////////////////////////////////////////////////////////////////////
#TFtdcCloseDirectionType是一个平仓方向类型
#//////////////////////////////////////////////////////////////////////
#买平仓
defineDict["SECURITY_FTDC_CD_CloseBuy"] = '!'
#卖平仓
defineDict["SECURITY_FTDC_CD_CloseSell"] = '@'
#备兑平仓
defineDict["SECURITY_FTDC_CD_CloseCover"] = '#'

typedefDict["TSecurityFtdcCloseDirectionType"] = "string"

