#ifndef __KSOTPTRADERAPI_H_INCLUDED_
#define __KSOTPTRADERAPI_H_INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "KSOTPUserApiStruct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_OTP_TRADER_API_EXPORT
#define OTP_TRADER_API_EXPORT __declspec(dllexport)
#else
#define OTP_TRADER_API_EXPORT __declspec(dllimport)
#endif
#else
#ifdef WIN32
#define OTP_TRADER_API_EXPORT 
#else
#define OTP_TRADER_API_EXPORT __attribute__((visibility("default")))
#endif

#endif

namespace KingstarAPI
{

class CKSOTPTraderSpi
{
public:
	///ͻ뽻׺̨ͨʱδ¼ǰ÷.
	virtual void OnFrontConnected(){};

	///ͻ뽻׺̨ͨӶϿʱ÷.
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	///        0x2004 Ͽ
	virtual void OnFrontDisconnected(int nReason){};

	///¼Ӧ
	virtual void OnRspUserLogin(CKSOTPRspUserLoginField *pRspUserLogin, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ǳӦ
	virtual void OnRspUserLogout(CKSOTPUserLogoutField *pUserLogout, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ûӦ
	virtual void OnRspUserPasswordUpdate(CKSOTPUserPasswordUpdateField *pUserPasswordUpdate, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ʽ˻Ӧ
	virtual void OnRspTradingAccountPasswordUpdate(CKSOTPTradingAccountPasswordUpdateField *pTradingAccountPasswordUpdate, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspOrderInsert(CKSOTPInputOrderField *pInputOrder, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspOrderAction(CKSOTPInputOrderActionField *pInputOrderAction, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryOrder(CKSOTPOrderField *pOrder, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯɽӦ
	virtual void OnRspQryTrade(CKSOTPTradeField *pTrade, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯͶֲ߳Ӧ
	virtual void OnRspQryInvestorPosition(CKSOTPInvestorPositionField *pInvestorPosition, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯʽ˻Ӧ
	virtual void OnRspQryTradingAccount(CKSOTPTradingAccountField *pTradingAccount, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯͶӦ
	virtual void OnRspQryInvestor(CKSOTPInvestorField *pInvestor, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯԼ˺Ӧ
	virtual void OnRspQryTradingCode(CKSOTPTradingCodeField *pTradingCode, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryExchange(CKSOTPExchangeField *pExchange, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯԼӦ
	virtual void OnRspQryInstrument(CKSOTPInstrumentField *pInstrument, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯͶֲ߳ϸӦ
	virtual void OnRspQryInvestorPositionDetail(CKSOTPInvestorPositionDetailField *pInvestorPositionDetail, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯ֪ͨӦ
	virtual void OnRspQryTradingNotice(CKSOTPTradingNoticeField *pTradingNotice, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ִ¼Ӧ
	virtual void OnRspExecOrderInsert(CKSOTPInputExecOrderField *pInputExecOrder, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspLockInsert(CKSOTPInputLockField *pInputLock, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ִӦ
	virtual void OnRspExecOrderAction(CKSOTPInputExecOrderActionField *pInputExecOrderAction, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯִӦ
	virtual void OnRspQryExecOrder(CKSOTPExecOrderField *pExecOrder, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryExecOrderVolume(CKSOTPExecOrderVolumeField *pExecOrderVolume, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryLock(CKSOTPLockField *pLock, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯ֤ȯλӦ
	virtual void OnRspQryLockPosition(CKSOTPLockPositionField *pLockPosition, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯȯϢӦ
	virtual void OnRspQryUnderlyingStockInfo(CKSOTPUnderlyingStockInfoField *pUnderlyingStockInfo, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///ѯȨӦ
	virtual void OnRspQryOTPInsCommRate(CKSOTPOTPInsCommRateField *pOTPInsCommRate, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///ѯȨԼ֤Ӧ
	virtual void OnRspQryInstrumentMarginRate(CKSOTPInstrumentMarginRateField *pInstrumentMarginRate, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///ѯȨָϢӦ
	virtual void OnRspQryOTPAssignment(CKSOTPOTPAssignmentField *pOTPAssignment, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryDepthMarketData(CKSOTPDepthMarketDataField *pDepthMarketData, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ʽת֤ȯӦ
	virtual void OnRspFromBankToStockByStock(CKSOTPReqTransferField *pReqTransfer, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///֤ȯʽת֤ȯ֪ͨ
	virtual void OnRtnFromBankToStockByStock(CKSOTPRspTransferField *pRspTransfer) {};

	///֤ȯ֤ȯʽתӦ
	virtual void OnRspFromStockToBankByStock(CKSOTPReqTransferField *pReqTransfer, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///֤ȯ֤ȯʽת֪ͨ
	virtual void OnRtnFromStockToBankByStock(CKSOTPRspTransferField *pRspTransfer) {};

	///֤ȯѯ֪ͨ
	virtual void OnRtnQueryBankBalanceByStock(CKSOTPNotifyQueryAccountField *pNotifyQueryAccount) {};

	///ѯǩԼӦ
	virtual void OnRspQryContractBank(CKSOTPContractBankField *pContractBank, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///֤ȯѯӦ
	virtual void OnRspQueryBankAccountMoneyByStock(CKSOTPReqQueryAccountField *pReqQueryAccount, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯתˮӦ
	virtual void OnRspQryTransferSerial(CKSOTPTransferSerialField *pTransferSerial, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯϢȷӦ
	virtual void OnRspQrySettlementInfoConfirm(CKSOTPSettlementInfoConfirmField *pSettlementInfoConfirm, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ͷ߽ȷӦ
	virtual void OnRspSettlementInfoConfirm(CKSOTPSettlementInfoConfirmField *pSettlementInfoConfirm, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯͶ߽Ӧ
	virtual void OnRspQrySettlementInfo(CKSOTPSettlementInfoField *pSettlementInfo, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯͻ׼Ӧ
	virtual void OnRspQryInvestorTradeLevel(CKSOTPInvestorTradeLevelField *pInvestorTradeLevel, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯ޹Ӧ
	virtual void OnRspQryPurchaseLimitAmt(CKSOTPPurchaseLimitAmtField *pPurchaseLimitAmt, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯ޲ֶӦ
	virtual void OnRspQryPositionLimitVol(CKSOTPPositionLimitVolField *pPositionLimitVol, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯʷӦ
	virtual void OnRspQryHistoryOrder(CKSOTPHistoryOrderField *pHistoryOrder, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯʷɽӦ
	virtual void OnRspQryHistoryTrade(CKSOTPHistoryTradeField *pHistoryTrade, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯʷȨָϸӦ
	virtual void OnRspQryHistoryAssignment(CKSOTPHistoryAssignmentField *pHistoryAssignment, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯȨϸӦ
	virtual void OnRspQryDelivDetail(CKSOTPDelivDetailField *pDelivDetail, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ԶȨִвӦ
	virtual void OnRspAutoExecOrderAction(CKSOTPAutoExecOrderActionField *pAutoExecOrderAction, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspCombActionInsert(CKSOTPInputCombActionField *pInputCombAction, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯϳֲϸӦ
	virtual void OnRspQryInvestorCombinePosition(CKSOTPInvestorPositionCombineDetailField *pInvestorPositionCombineDetail, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ɿϿɲӦ
	virtual void OnRspQryCombActionVolume(CKSOTPCombActionVolumeField *pCombActionVolume, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ͻÿճӦ
	virtual void OnRspFundOutCreditApply(CKSOTPInputFundOutCreditApplyField *pFundOutCreditApply, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ͻÿճȲѯӦ
	virtual void OnRspQryFundOutCredit(CKSOTPRspQryFundOutCreditField *pRspQryFundOutCredit, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ͻÿճѯӦ
	virtual void OnRspQryFundOutCreditApply(CKSOTPRspQryFundOutCreditApplyField *pRspQryFundOutCreditApply, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspError(CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///֪ͨ
	virtual void OnRtnOrder(CKSOTPOrderField *pOrder) {};

	///ɽ֪ͨ
	virtual void OnRtnTrade(CKSOTPTradeField *pTrade) {};

	///ִ֪ͨ
	virtual void OnRtnExecOrder(CKSOTPExecOrderField *pExecOrder) {};

	///֪ͨ
	virtual void OnRtnLock(CKSOTPLockField *pLock) {};

	///Լ״̬֪ͨ
	virtual void OnRtnInstrumentStatus(CKSOTPInstrumentStatusField *pInstrumentStatus) {};

	///֪ͨ
	virtual void OnRtnTradingNotice(CKSOTPTradingNoticeInfoField *pTradingNoticeInfo) {};

	///ϲί֪ͨ
	virtual void OnRtnCombAction(CKSOTPCombActionField *pCombAction) {};
};

class OTP_TRADER_API_EXPORT CKSOTPTraderApi
{
public:
	///TraderApi
	///@return UserApi
	///@param pszFlowPath ϢļĿ¼ĬΪǰĿ¼
	static CKSOTPTraderApi *CreateOTPTraderApi(const char *pszFlowPath = "");

	///ɾӿڶ
	///@remark ʹñӿڶʱ,øúɾӿڶ
	virtual void Release() = 0;

	///ʼ
	///@remark ʼл,ֻеú,ӿڲſʼ
	virtual void Init() = 0;

	///ȡǰ
	///@return ȡĽ
	///@remark ֻе¼ɹ,ܵõȷĽ
	virtual const char *GetTradingDay() = 0;

	///עǰûַ
	///@param pszFrontAddressǰûַ.
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001. 
	///@remark tcpЭ飬127.0.0.1ַ.17001˿ں.
	virtual void RegisterFront(char *pszFrontAddress) = 0;

	///עصӿ
	///@param pSpi Իصӿʵ
	virtual void RegisterSpi(CKSOTPTraderSpi *pSpi) = 0;

	///˽.
	///@param nResumeType ˽شʽ  
	///        THOST_TERT_RESTART:ӱտʼش
	///        THOST_TERT_RESUME:ϴյ
	///        THOST_TERT_QUICK:ֻ͵¼˽
	///@remark ÷ҪInitǰ.򲻻յ˽.
	virtual void SubscribePrivateTopic(KSOTP_TE_RESUME_TYPE nResumeType) = 0;

	///Ĺ.
	///@param nResumeType شʽ  
	///        THOST_TERT_RESTART:ӱտʼش
	///        THOST_TERT_RESUME:ϴյ
	///        THOST_TERT_QUICK:ֻ͵¼󹫹
	///@remark ÷ҪInitǰ.򲻻յ.
	virtual void SubscribePublicTopic(KSOTP_TE_RESUME_TYPE nResumeType) = 0;

	///û¼
	virtual int ReqUserLogin(CKSOTPReqUserLoginField *pReqUserLoginField, int nRequestID) = 0;

	///ǳ
	virtual int ReqUserLogout(CKSOTPUserLogoutField *pUserLogout, int nRequestID) = 0;

	///û
	virtual int ReqUserPasswordUpdate(CKSOTPUserPasswordUpdateField *pUserPasswordUpdate, int nRequestID) = 0;

	///ʽ˻
	virtual int ReqTradingAccountPasswordUpdate(CKSOTPTradingAccountPasswordUpdateField *pTradingAccountPasswordUpdate, int nRequestID) = 0;

	///¼
	virtual int ReqOrderInsert(CKSOTPInputOrderField *pInputOrder, int nRequestID) = 0;

	///
	virtual int ReqOrderAction(CKSOTPInputOrderActionField *pInputOrderAction, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryOrder(CKSOTPQryOrderField *pQryOrder, int nRequestID) = 0;

	///ѯɽ
	virtual int ReqQryTrade(CKSOTPQryTradeField *pQryTrade, int nRequestID) = 0;

	///ѯͶֲ߳
	virtual int ReqQryInvestorPosition(CKSOTPQryInvestorPositionField *pQryInvestorPosition, int nRequestID) = 0;

	///ѯʽ˻
	virtual int ReqQryTradingAccount(CKSOTPQryTradingAccountField *pQryTradingAccount, int nRequestID) = 0;

	///ѯͶ
	virtual int ReqQryInvestor(CKSOTPQryInvestorField *pQryInvestor, int nRequestID) = 0;

	///ѯԼ˺
	virtual int ReqQryTradingCode(CKSOTPQryTradingCodeField *pQryTradingCode, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryExchange(CKSOTPQryExchangeField *pQryExchange, int nRequestID) = 0;

	///ѯԼ
	virtual int ReqQryInstrument(CKSOTPQryInstrumentField *pQryInstrument, int nRequestID) = 0;

	///ѯͶֲ߳ϸ
	virtual int ReqQryInvestorPositionDetail(CKSOTPQryInvestorPositionDetailField *pQryInvestorPositionDetail, int nRequestID) = 0;

	///ѯ֪ͨ
	virtual int ReqQryTradingNotice(CKSOTPQryTradingNoticeField *pQryTradingNotice, int nRequestID) = 0;

	///ִ¼
	virtual int ReqExecOrderInsert(CKSOTPInputExecOrderField *pInputExecOrder, int nRequestID) = 0;

	///ִ
	virtual int ReqExecOrderAction(CKSOTPInputExecOrderActionField *pInputExecOrderAction, int nRequestID) = 0;

	///
	virtual int ReqLockInsert(CKSOTPInputLockField *pInputLock, int nRequestID) = 0;

	///ѯִ
	virtual int ReqQryExecOrder(CKSOTPQryExecOrderField *pQryExecOrder, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryExecOrderVolume(CKSOTPQryExecOrderVolumeField *pQryExecOrderVolume, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryLock(CKSOTPQryLockField *pQryLock, int nRequestID) = 0;

	///ѯ֤ȯλ
	virtual int ReqQryLockPosition(CKSOTPQryLockPositionField *pQryLockPosition, int nRequestID) = 0;

	///ѯȯϢ
	virtual int ReqQryUnderlyingStockInfo(CKSOTPQryUnderlyingStockInfoField *pQryOTPOrderParams, int nRequestID) = 0;

	///ѯȨ
	virtual int ReqQryOTPInsCommRate(CKSOTPQryOTPInsCommRateField *pQryOTPInsCommRate, int nRequestID) = 0;

	///ѯȨԼ֤
	virtual int ReqQryInstrumentMarginRate(CKSOTPQryInstrumentMarginRateField *pQryInstrumentMarginRate, int nRequestID) = 0;

	///ѯȨָϢ
	virtual int ReqQryOTPAssignment(CKSOTPQryOTPAssignmentField *pQryOTPAssignment, int nRequestID) = 0;

	///ѯ 
	virtual int ReqQryDepthMarketData(CKSOTPQryDepthMarketDataField *pQryOTPDepthMarketData, int nRequestID) = 0;

	///ʽת
	virtual int ReqFromBankToStockByStock(CKSOTPReqTransferField *pReqTransfer, int nRequestID) = 0;

	///֤ȯʽת
	virtual int ReqFromStockToBankByStock(CKSOTPReqTransferField *pReqTransfer, int nRequestID) = 0;

	///ѯǩԼ
	virtual int ReqQryContractBank(CKSOTPQryContractBankField *pQryContractBank, int nRequestID) = 0;

	///ѯ
	virtual int ReqQueryBankAccountMoneyByStock(CKSOTPReqQueryAccountField *pReqQueryAccount, int nRequestID) = 0;

	///ѯתˮ
	virtual int ReqQryTransferSerial(CKSOTPQryTransferSerialField *pQryTransferSerial, int nRequestID) = 0;

	///ѯϢȷ
	virtual int ReqQrySettlementInfoConfirm(CKSOTPQrySettlementInfoConfirmField *pQrySettlementInfoConfirm, int nRequestID) = 0;

	///Ͷ߽ȷ
	virtual int ReqSettlementInfoConfirm(CKSOTPSettlementInfoConfirmField *pSettlementInfoConfirm, int nRequestID) = 0;

	///ѯͶ߽
	virtual int ReqQrySettlementInfo(CKSOTPQrySettlementInfoField *pQrySettlementInfo, int nRequestID) = 0;

	///ѯͻ׼
	virtual int ReqQryInvestorTradeLevel(CKSOTPQryInvestorTradeLevelField *pQryInvestorTradeLevel, int nRequestID) = 0;

	///ѯ޹
	virtual int ReqQryPurchaseLimitAmt(CKSOTPQryPurchaseLimitAmtField *pQryPurchaseLimitAmt, int nRequestID) = 0;

	///ѯ޲ֶ
	virtual int ReqQryPositionLimitVol(CKSOTPQryPositionLimitVolField *pQryPositionLimitVol, int nRequestID) = 0;

	///ѯʷ
	virtual int ReqQryHistoryOrder(CKSOTPQryHistoryOrderField *pQryHistoryOrder, int nRequestID) = 0;

	///ѯʷɽ
	virtual int ReqQryHistoryTrade(CKSOTPQryHistoryTradeField *pQryHistoryTrade, int nRequestID) = 0;

	///ѯʷȨָϸ
	virtual int ReqQryHistoryAssignment(CKSOTPQryHistoryAssignmentField *pQryHistoryAssignment, int nRequestID) = 0;

	///ѯȨϸ
	virtual int ReqQryDelivDetail(CKSOTPQryDelivDetailField *pQryDelivDetail, int nRequestID) = 0;

	///ԶȨִв
	virtual int ReqAutoExecOrderAction(CKSOTPAutoExecOrderActionField *pAutoExecOrderAction, int nRequestID) = 0;

	///ϲί
	virtual int ReqCombActionInsert(CKSOTPInputCombActionField *pInputCombAction, int nRequestID) = 0;

	///ѯϳֲϸ
	virtual int ReqQryInvestorCombinePosition(CKSOTPQryInvestorPositionCombineDetailField *pQryInvestorCombinePosition, int nRequestID) = 0;

	///ѯɿϿɲ
	virtual int ReqQryCombActionVolume(CKSOTPQryCombActionVolumeField *pQryCombActionVolume, int nRequestID) = 0;

	///ͻÿճ
	virtual int ReqFundOutCreditApply(CKSOTPInputFundOutCreditApplyField *pFundOutCreditApply, int nRequestID) = 0;

	///ͻÿճȲѯ
	virtual int ReqQryFundOutCredit(CKSOTPQryFundOutCreditField *pQryFundOutCredit, int nRequestID) = 0;

	///ͻÿճѯ
	virtual int ReqQryFundOutCreditApply(CKSOTPQryFundOutCreditApplyField *pQryFundOutCreditApply, int nRequestID) = 0;

protected:
	~CKSOTPTraderApi(){};
};

}	// end of namespace KingstarAPI
#endif