//˵
/*
CTP APIкʽתصĺ̫࣬
ͬʱҲѾдĿͻ֧Щܣ
Pythonװʱѡֻֽ֧׹
*/


//ϵͳ
#include "stdafx.h"
#include <string>
#include <queue>

//Boost
#define BOOST_PYTHON_STATIC_LIB
#include <boost/python/module.hpp>	//pythonװ
#include <boost/python/def.hpp>		//pythonװ
#include <boost/python/dict.hpp>	//pythonװ
#include <boost/python/object.hpp>	//pythonװ 
#include <boost/python.hpp>			//pythonװ
#include <boost/thread.hpp>			//е̹߳
#include <boost/bind.hpp>			//е̹߳
#include <boost/any.hpp>			//еʵ

//API
#include "GoldTradeApi.h"
#include "Constant.h"

//ռ
using namespace std;
using namespace boost::python;
using namespace boost;

//
#define ONFRONTCONNECTED 1
#define ONFRONTDISCONNECTED 2
#define ONRSPUSERLOGIN 3
#define ONRSPUSERLOGOUT 4
#define ONNTYMKTSTATUS 5
#define ONRSPQRYINSTRUMENT 6
#define ONRTNDEPTHMARKETDATA 7
#define ONRSPORDERINSERT 8
#define ONERRRTNORDERINSERT 9
#define ONRTNORDER 10
#define ONFORCELOGOUT 11
#define ONRSPORDERACTION 12
#define ONERRRTNORDERACTION 13
#define ONRTNTRADE 14
#define ONRSPQRYTRADINGACCOUNT 15
#define ONRSPQRYORDER 16
#define ONRSPQRYTRADE 17
#define ONRSPQRYINVESTORPOSITION 18
#define ONRSPQRYCLIENTSTORAGE 19
#define ONRSPSUBMARKETDATA 20


///-------------------------------------------------------------------------------------
///APIеĲ
///-------------------------------------------------------------------------------------

//GILȫ򻯻ȡã
//ڰC++̻߳GILӶֹpython
class PyLock
{
private:
	PyGILState_STATE gil_state;

public:
	//ĳдöʱGIL
	PyLock()
	{
		gil_state = PyGILState_Ensure();
	}

	//ĳɺٸöʱGIL
	~PyLock()
	{
		PyGILState_Release(gil_state);
	}
};


//ṹ
struct Task
{
	int task_name;		//صƶӦĳ
	any task_data;		//ݽṹ
	any task_error;		//ṹ
	int task_id;		//id
	bool task_last;		//ǷΪ󷵻
};


///̰߳ȫĶ
template<typename Data>

class ConcurrentQueue
{
private:
	queue<Data> the_queue;								//׼
	mutable mutex the_mutex;							//boost
	condition_variable the_condition_variable;			//boost

public:

	//µ
	void push(Data const& data)
	{
		mutex::scoped_lock lock(the_mutex);				//ȡ
		the_queue.push(data);							//д
		lock.unlock();									//ͷ
		the_condition_variable.notify_one();			//֪ͨȴ߳
	}

	//ǷΪ
	bool empty() const
	{
		mutex::scoped_lock lock(the_mutex);
		return the_queue.empty();
	}

	//ȡ
	Data wait_and_pop()
	{
		mutex::scoped_lock lock(the_mutex);

		while (the_queue.empty())						//Ϊʱ
		{
			the_condition_variable.wait(lock);			//ȴ֪ͨ
		}

		Data popped_value = the_queue.front();			//ȡеһ
		the_queue.pop();								//ɾ
		return popped_value;							//ظ
	}

};


//ֵлȡĳֵӦֵṹֵ
void getInt(dict d, string key, int* value);


//ֵлȡĳֵӦĸֵṹֵ
void getDouble(dict d, string key, double* value);


//ֵлȡĳֵӦֵַṹֵ
void getChar(dict d, string key, char* value);



///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class TdApi : public CGoldTradeSpi
{
private:
	CGoldTradeApi* api;			//API
	thread *task_thread;				//ָ߳루pythonݣ
	ConcurrentQueue<Task> task_queue;	//

public:
	TdApi()
	{
		function0<void> f = boost::bind(&TdApi::processTask, this);
		thread t(f);
		this->task_thread = &t;
	};

	~TdApi()
	{
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	//ӽ֪ͨ
	virtual void OnFrontConnected();

	//ӶϿ
	virtual void OnFrontDisconnected(int nReason);

	///¼Ӧ
	virtual void OnRspUserLogin(CThostFtdcRspUserLoginField *pRspUserLogin, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	///ǳӦ
	virtual void OnRspUserLogout(CThostFtdcUserLogoutField *pUserLogout, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	//г״̬֪ͨ
	virtual void OnNtyMktStatus(const CThostFtdcMarketStatusField *pfldMktStatus);

	///ѯԼӦ
	virtual void OnRspQryInstrument(CThostFtdcInstrumentField *pInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	///֪ͨ
	virtual void OnRtnDepthMarketData(CThostFtdcDepthMarketDataField *pDepthMarketData);

	///¼Ӧ(ϵͳ
	virtual void OnRspOrderInsert(CThostFtdcInputOrderField *pInputOrder, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	///¼ر(
	virtual void OnErrRtnOrderInsert(CThostFtdcInputOrderField *pInputOrder, CThostFtdcRspInfoField *pRspInfo);

	///֪ͨ
	//virtual void OnRtnOrder(CThostFtdcOrderField *pOrder); //
	virtual void OnRtnOrder(CThostFtdcOrderRtnField *pOrder);

	//ǿ֪ͨ
	virtual void OnForceLogout(CThostFtdcUserLogoutField *pLogout);

	//Ӧ
	///Ӧ(ϵͳذ˴ʹϢ)
	virtual void OnRspOrderAction(CThostFtdcInputOrderActionField *pInputOrderAction, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	///ر()
	virtual void OnErrRtnOrderAction(CThostFtdcOrderActionField *pOrderAction, CThostFtdcRspInfoField *pRspInfo);

	///ɽ֪ͨ
	virtual void OnRtnTrade(CThostFtdcTradeField *pTrade);

	///ѯʽ˻Ӧ
	virtual void OnRspQryTradingAccount(CThostFtdcTradingAccountField *pTradingAccount, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	///ѯӦ
	virtual void OnRspQryOrder(CThostFtdcOrderField *pOrder, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	///ѯɽӦ
	virtual void OnRspQryTrade(CThostFtdcTradeField *pTrade, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	///ѯͶֲ߳Ӧ
	virtual void OnRspQryInvestorPosition(CThostFtdcInvestorPositionField *pInvestorPosition, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	//ѯͻӦ
	virtual void OnRspQryClientStorage(CThostFtdcStorageField *pStorage, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	///Ӧ
	virtual void OnRspSubMarketData(CThostFtdcSpecificInstrumentField *pSpecificInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	//-------------------------------------------------------------------------------------
	//task
	//-------------------------------------------------------------------------------------

	void processTask();

	void processFrontConnected(Task task);

	void processFrontDisconnected(Task task);

	void processRspUserLogin(Task task);

	void processRspUserLogout(Task task);

	void processNtyMktStatus(Task task);

	void processRspQryInstrument(Task task);

	void processRtnDepthMarketData(Task task);

	void processRspOrderInsert(Task task);

	void processErrRtnOrderInsert(Task task);

	void processRtnOrder(Task task);

	void processForceLogout(Task task);

	void processRspOrderAction(Task task);

	void processErrRtnOrderAction(Task task);

	void processRtnTrade(Task task);

	void processRspQryTradingAccount(Task task);

	void processRspQryOrder(Task task);

	void processRspQryTrade(Task task);

	void processRspQryInvestorPosition(Task task);

	void processRspQryClientStorage(Task task);

	void processRspSubMarketData(Task task);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//idid
	//lastǷΪ󷵻
	//i
	//-------------------------------------------------------------------------------------

	virtual void onFrontConnected(){};

	virtual void onFrontDisconnected(int i){};

	virtual void onRspUserLogin(dict data, dict error, int id, bool last) {};

	virtual void onRspUserLogout(dict data, dict error, int id, bool last) {};

	virtual void onNtyMktStatus(dict data) {};

	virtual void onRspQryInstrument(dict data, dict error, int id, bool last) {};

	virtual void onRtnDepthMarketData(dict data) {};

	virtual void onForceLogout(dict data) {};

	virtual void onRspOrderInsert(dict data, dict error, int id, bool last) {};

	virtual void onErrRtnOrderInsert(dict data, dict error) {};

	virtual void onRtnOrder(dict data) {};

	virtual void onRspOrderAction(dict data, dict error, int id, bool last) {};

	virtual void onErrRtnOrderAction(dict data, dict error) {};

	virtual void onRtnTrade(dict data) {};

	virtual void onRspQryTradingAccount(dict data, dict error, int id, bool last) {};

	virtual void onRspQryOrder(dict data, dict error, int id, bool last) {};

	virtual void onRspQryTrade(dict data, dict error, int id, bool last) {};

	virtual void onRspQryInvestorPosition(dict data, dict error, int id, bool last) {};

	virtual void onRspQryClientStorage(dict data, dict error, int id, bool last) {};

	virtual void onRspSubMarketData(dict data, dict error, int id, bool last) {};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createGoldTraderApi();

	void release();

	int init(bool flag);

	void join();

	int exit();

	void registerFront(string pszFrontAddress);

	int reqUserLogin(dict req, int nRequestID);

	int reqUserLogout(dict req, int nRequestID);

	int reqUserReLogin();

	int subscribeMarketData(string instrumentID);

	int unSubscribeMarketData(string instrumentID);

	int reqQryInstrument(dict req, int nRequestID);

	int reqOrderInsert(dict req, int nRequestID);

	int reqOrderAction(dict req, int nRequestID);

	int reqQryInvestorPosition(dict req, int nRequestID);

	int reqQryTradingAccount(dict req, int nRequestID);

	int reqQryTrade(dict req, int nRequestID);

	int reqQryOrder(dict req, int nRequestID);

	int reqQryStorage(dict req, int nRequestID);
};

