/////////////////////////////////////////////////////////////////////////
///@system ǰϵͳ
///@company ϺڻϢ޹˾
///@file USTPFtdcMduserApi.h
///@brief ˿ͻ˽ӿ
///@history 
///20130520	һ	ļ
/////////////////////////////////////////////////////////////////////////

#if !defined(USTP_FTDCMDUSERAPI_H)
#define USTP_FTDCMDUSERAPI_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "USTPFtdcUserApiStruct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_MDUSER_API_EXPORT
#define MDUSER_API_EXPORT __declspec(dllexport)
#else
#define MDUSER_API_EXPORT __declspec(dllimport)
#endif
#else
#define MDUSER_API_EXPORT 
#endif

class CUstpFtdcMduserSpi
{
public:
	///ͻ뽻׺̨ͨʱδ¼ǰ÷á
	virtual void OnFrontConnected(){};
	
	///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	virtual void OnFrontDisconnected(int nReason){};
		
	///ʱ档ʱδյʱ÷á
	///@param nTimeLapse ϴνձĵʱ
	virtual void OnHeartBeatWarning(int nTimeLapse){};
	
	///Ļصʼ֪ͨAPIյһĺȵñȻǸĻصǱĻص֪ͨ
	///@param nTopicID 루˽ȣ
	///@param nSequenceNo 
	virtual void OnPackageStart(int nTopicID, int nSequenceNo){};
	
	///Ļص֪ͨAPIյһĺȵñĻصʼ֪ͨȻǸĻصñ
	///@param nTopicID 루˽ȣ
	///@param nSequenceNo 
	virtual void OnPackageEnd(int nTopicID, int nSequenceNo){};


	///Ӧ
	virtual void OnRspError(CUstpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ǰϵͳû¼Ӧ
	virtual void OnRspUserLogin(CUstpFtdcRspUserLoginField *pRspUserLogin, CUstpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û˳Ӧ
	virtual void OnRspUserLogout(CUstpFtdcRspUserLogoutField *pRspUserLogout, CUstpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspSubscribeTopic(CUstpFtdcDisseminationField *pDissemination, CUstpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryTopic(CUstpFtdcDisseminationField *pDissemination, CUstpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///֪ͨ
	virtual void OnRtnDepthMarketData(CUstpFtdcDepthMarketDataField *pDepthMarketData) {};

	///ĺԼϢ
	virtual void OnRspSubMarketData(CUstpFtdcSpecificInstrumentField *pSpecificInstrument, CUstpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///˶ԼϢ
	virtual void OnRspUnSubMarketData(CUstpFtdcSpecificInstrumentField *pSpecificInstrument, CUstpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
};

class MDUSER_API_EXPORT CUstpFtdcMduserApi
{
public:
	///MduserApi
	///@param pszFlowPath ϢļĿ¼ĬΪǰĿ¼
	///@return UserApi
	static CUstpFtdcMduserApi *CreateFtdcMduserApi(const char *pszFlowPath = "");
	
	///ȡϵͳ汾
	///@param nMajorVersion 汾
	///@param nMinorVersion Ӱ汾
	///@return ϵͳʶַ
	static const char *GetVersion(int &nMajorVersion, int &nMinorVersion);
	
	///ɾӿڶ
	///@remark ʹñӿڶʱ,øúɾӿڶ
	virtual void Release() = 0;
	
	///ʼ
	///@remark ʼл,ֻеú,ӿڲſʼ
	virtual void Init() = 0;
	
	///ȴӿ߳̽
	///@return ߳˳
	virtual int Join() = 0;
	
	///ȡǰ
	///@retrun ȡĽ
	///@remark ֻе¼ɹ,ܵõȷĽ
	virtual const char *GetTradingDay() = 0;
	
	///עǰûַ
	///@param pszFrontAddressǰûַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
	///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
	virtual void RegisterFront(char *pszFrontAddress) = 0;
	
	///עַַ
	///@param pszNsAddressַַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:12001 
	///@remark tcpЭ飬127.0.0.1ַ12001˿ںš
	///@remark RegisterFrontRegisterNameServer
	virtual void RegisterNameServer(char *pszNsAddress) = 0;
	
	///עصӿ
	///@param pSpi Իصӿʵ
	virtual void RegisterSpi(CUstpFtdcMduserSpi *pSpi) = 0;
	
	///֤
	///@param pszCertFileName û֤ļ
	///@param pszKeyFileName û˽Կļ
	///@param pszCaFileName CA֤ļ
	///@param pszKeyFilePassword û˽Կļ
	///@return 0 ɹ
	///@return -1 CA֤ʧ
	///@return -2 û֤ʧ
	///@return -3 û˽Կʧ	
	///@return -4 û֤Уʧ
	virtual int RegisterCertificateFile(const char *pszCertFileName, const char *pszKeyFileName, 
		const char *pszCaFileName, const char *pszKeyFilePassword) = 0;

	///г顣
	///@param nTopicID г  
	///@param nResumeType гشʽ  
	///        USTP_TERT_RESTART:ӱտʼش
	///        USTP_TERT_RESUME:ϴյ(ǶȫԼʱ֧ģʽ)
	///        USTP_TERT_QUICK:ȴ͵ǰ,ٴ͵¼г
	///@remark ÷ҪInitǰá򲻻յ˽ݡ
	virtual void SubscribeMarketDataTopic(int nTopicID, USTP_TE_RESUME_TYPE nResumeType) = 0;

	///ĺԼ顣
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int SubMarketData(char *ppInstrumentID[], int nCount)=0;

	///˶Լ顣
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int UnSubMarketData(char *ppInstrumentID[], int nCount)=0;		
	
	///ʱʱ䡣
	///@param timeout ʱʱ()  
	virtual void SetHeartbeatTimeout(unsigned int timeout) = 0;


	///ǰϵͳû¼
	virtual int ReqUserLogin(CUstpFtdcReqUserLoginField *pReqUserLogin, int nRequestID) = 0;

	///û˳
	virtual int ReqUserLogout(CUstpFtdcReqUserLogoutField *pReqUserLogout, int nRequestID) = 0;

	///
	virtual int ReqSubscribeTopic(CUstpFtdcDisseminationField *pDissemination, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryTopic(CUstpFtdcDisseminationField *pDissemination, int nRequestID) = 0;

	///ĺԼϢ
	virtual int ReqSubMarketData(CUstpFtdcSpecificInstrumentField *pSpecificInstrument, int nRequestID) = 0;

	///˶ԼϢ
	virtual int ReqUnSubMarketData(CUstpFtdcSpecificInstrumentField *pSpecificInstrument, int nRequestID) = 0;
protected:
	~CUstpFtdcMduserApi(){};
};

#endif
