export const preferenceConfig = {
  app: {
    /**
     * 应用标题
     */
    title: 'Naive UI Pro',
    /**
     * 路由过渡动画名称
     */
    transitionName: 'fade-slide',
    /**
     * 权限模式
     */
    accessMode: 'frontend',
    /**
     * 语言
     */
    lang: 'zh-CN', // en-US
  },
  layout: {
    /**
     * 布局模式
     */
    mode: 'vertical',
    /**
     * 是否显示顶栏
     */
    showNav: true,
    /**
     * 是否显示 logo
     */
    showLogo: true,
    /**
     * 是否显示侧边栏
     */
    showSidebar: true,
    /**
     * 是否显示标签栏
     */
    showTabbar: true,
    /**
     * 是否显示底部
     */
    showFooter: false,
    /**
     * 顶栏是否固定
     */
    navFixed: true,
    /**
     * 侧边栏是否折叠
     */
    collapsed: false,
    /**
     * 顶栏高度
     */
    navHeight: 50,
    /**
     * 侧边栏宽度
     */
    sidebarWidth: 224,
    /**
     * 底部高度
     */
    footerHeight: 32,
    /**
     * 底部是否固定
     */
    footerFixed: true,
    /**
     * 标签栏高度
     */
    tabbarHeight: 38,
    /**
     * 标签页主题
     */
    tabsMode: 'chrome',
    /**
     * 标签页是否持久化
     */
    tabsPersist: true,
    /**
     * 关闭标签页后是否重置缓存
     */
    resetCacheAfterCloseTab: true,
    /**
     * 侧边栏折叠后的宽度
     */
    sidebarCollapsedWidth: 58,
    /**
     * 侧边栏折叠后是否显示菜单名
     */
    sidebarCollapsedShowMenuTitle: true,
    /**
     * 当展示菜单标题时，侧边栏折叠后的宽度
     */
    sidebarCollapsedWidthWhenShowMenuTitle: 80,
    /**
     * 是否开启侧边栏菜单分组
     */
    sidebarMenuGroup: false,
    /**
     * 是否开启侧边栏菜单分割线
     */
    sidebarMenuDivider: false,
  },
  theme: {
    /**
     * 主题模式
     */
    mode: 'auto',
    /**
     * 主题主色
     */
    primaryColor: '#1677ff',
    /**
     * 是否为灰色模式
     */
    grayscale: false,
    /**
     * 是否为色弱模式
     */
    colorWeakness: false,
  },
}
