## 简介

[`naive-ui-pro`](https://github.com/Zheng-Changfu/naive-ui-pro) 完全免费，基于 vue3、vite、 pro-naive-ui、typescript 的中后台解决方案，和市面上**所有开源 admin 的架构设计都不同**，我们创新了基于路由的插件化架构，提供了 admin 中所需要的全部插件，让 admin 像搭积木一样慢慢堆起来，同时还基于 naive-ui 封装了大量的组件，并将这些组件放到了 [pro-naive-ui](https://naive-ui.pro-components.cn/) 组件库中，它也是完全开源，相信不管是从架构设计还是其他方面，都能帮助到你！

## 特性

- 前沿的架构设计，你不必担心看不懂功能代码，因为它是用插件搭积木堆起来的，每一块功能都被插件单独实现。
- 强大的布局组件，支持 `7` 种布局，同时也完美支持移动端。
- 强大的无头菜单能力，让你可以轻松实现个性化的菜单。
- 强大的 [pro-naive-ui](https://naive-ui.pro-components.cn/) 组件库支持，此外我们还在系统中提供了封装高级组件的代码示例。
- 底层可移植，无论是目前的这套架构设计还是 `pro-naive-ui`，他们底层代码都与组件库无关，这意味着你可以花点时间把他们迁移到其他的组件库中。
- 宽松的代码规范，我们只提供了 simple-git-hooks，让其只在 commit 时格式化代码。
- 支持多语言切换。
- 包含了 `14+` 插件，权限插件、多页签插件、嵌套路由插件，应有尽有。

## 预览

- [admin 预览地址](https://naive-ui-pro.pro-components.cn)

## 文档

- [组件库文档地址](https://naive-ui.pro-components.cn/)
- [admin 文档地址](https://docs-naive-ui-pro.pro-components.cn/)

## 示例图片

![](/public/naive-ui-pro-1.png)
![](/public/naive-ui-pro-2.png)
![](/public/naive-ui-pro-3.png)
![](/public/naive-ui-pro-4.png)
![](/public/naive-ui-pro-5.png)
![](/public/naive-ui-pro-6.png)

## 使用

**克隆项目**

```bash
# github
git clone https://github.com/Zheng-Changfu/naive-ui-pro.git
```

**安装依赖**

```bash
pnpm i
```

**启动**

```bash
pnpm dev
```

**构建**

```bash
pnpm build
```

## 贡献者

感谢以下贡献者做出的贡献。

<a href="https://github.com/Zheng-Changfu/naive-ui-pro/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=Zheng-Changfu/naive-ui-pro" />
</a>

## 交流

`naive-ui-pro` 是完全开源免费的项目，帮助开发者进行中大型管理系统开发，同时提供微信交流群，使用上出现问题欢迎在群内提问。

<div>
  <div style="margin-bottom: 8px">添加微信邀请进微信群</div>
  <img src="/public/wechat.jpg" style="width: 200px" />
</div>

## 开源协议

本项目遵照 [MIT](./LICENSE) 开源协议发布，严禁将其用于任何非法用途，作者不对因此带来的任何风险与后果承担法律责任。
