@tool
class_name StoryTalkRef extends Resource

@export var file_path: String:
	get:
		return _file_path
	set(new_file_path):
		_file_path = new_file_path
		_refresh_file()

@export var talk_name: String

var _file_path: String
var _file: StoryFile


static func by_file(story_file: StoryFile, talk_name: String) -> StoryTalkRef:
	var ref := StoryTalkRef.new()
	ref._file_path = story_file.resource_path
	ref._file = story_file
	ref.talk_name = talk_name
	return ref


func get_talk_lines(fallback_locale: String = "") -> Array:
	return get_talk_lines_translation(TranslationServer.get_locale(), fallback_locale)


func get_talk_lines_translation(locale: String, fallback_locale: String = "") -> Array:
	if _file == null:
		push_error("StoryTalkRef: file %s not found" % file_path)
		return []
	var talk_index := _file.find_talk_index(talk_name)
	if talk_index < 0:
		push_error("StoryTalkRef: talk %s not found at file %s" % [talk_name, file_path])
		return []
	return _file.get_talk_lines_translation(talk_index, locale, fallback_locale)


func _refresh_file() -> void:
	_file = null # reset
	if file_path != "":
		_file = load(file_path)
