@tool
class_name StoryNoteRef extends Resource

@export var file_path: String:
	get:
		return _file_path
	set(new_file_path):
		_file_path = new_file_path
		_refresh_file()

@export var note_name: String

var _file_path: String
var _file: StoryFile


static func by_file(story_file: StoryFile, note_name: String) -> StoryNoteRef:
	var ref := StoryNoteRef.new()
	ref._file_path = story_file.resource_path
	ref._file = story_file
	ref.note_name = note_name
	return ref


func get_note_title() -> String:
	return get_note_title_translation(TranslationServer.get_locale())


func get_note_content() -> String:
	return get_note_content_translation(TranslationServer.get_locale())


func get_note_title_translation(locale: String) -> String:
	return _get_note_lines_translation(locale)[0]


func get_note_content_translation(locale: String) -> String:
	return " ".join(_get_note_lines_translation(locale).slice(1))


func _get_note_lines_translation(locale: String) -> Array:
	if _file == null:
		push_error("StoryNoteRef: file %s not found" % file_path)
		return ["", ""]
	var note_index := _file.find_note_index(note_name)
	if note_index < 0:
		push_error("StoryNoteRef: note %s not found at file %s" % [note_name, file_path])
		return ["", ""]
	var lines := _file.get_note_lines_translation(note_index, locale)
	if lines.size() < 2:
		lines = Array(lines)
		lines.append("")
		if lines.size() < 2:
			lines.append("")
	return lines


func _refresh_file() -> void:
	_file = null # reset
	if file_path != "":
		_file = load(file_path)
