@tool
class_name StoryFileSaver extends ResourceFormatSaver


func _get_recognized_extensions(resource: Resource) -> PackedStringArray:
	return [StoryFile.EXTENSION] if resource is StoryFile else []


func _recognize(resource: Resource) -> bool:
	return resource is StoryFile


func _recognize_path(resource: Resource, path: String) -> bool:
	return resource is StoryFile && StoryFile.is_path(path)


func _save(resource: Resource, path: String, _flags: int) -> Error:
	if resource is StoryFile:
		return resource._save(path)
	return Error.ERR_FILE_UNRECOGNIZED


func _set_uid(path: String, uid: int) -> Error:
	print_verbose("StorySaver set uid: ", path, " ", uid)
	return Error.OK
