@tool
extends EditorPlugin

const Main := preload("main.tscn")
const Icon := preload("plugin.svg")

var _main: Control = null
var _story_file_loader: StoryFileLoader = null
var _story_file_saver: StoryFileSaver = null
var _story_note_selector: StoryNoteSelector = null
var _story_talk_selector: StoryTalkSelector = null


func _enter_tree() -> void:
	if !_main:
		_main = Main.instantiate()
		_main.visible = false
		EditorInterface.get_editor_main_screen().add_child(_main)

	if !_story_file_loader:
		_story_file_loader = StoryFileLoader.new()
		ResourceLoader.add_resource_format_loader(_story_file_loader)

	if !_story_file_loader:
		_story_file_saver = StoryFileSaver.new()
		ResourceSaver.add_resource_format_saver(_story_file_saver)

	if !_story_note_selector:
		_story_note_selector = StoryNoteSelector.new()
		add_inspector_plugin(_story_note_selector)

	if !_story_talk_selector:
		_story_talk_selector = StoryTalkSelector.new()
		add_inspector_plugin(_story_talk_selector)


func _exit_tree() -> void:
	if _main:
		_main.queue_free()

	if _story_file_loader:
		ResourceLoader.remove_resource_format_loader(_story_file_loader)

	if _story_file_saver:
		ResourceSaver.remove_resource_format_saver(_story_file_saver)

	if _story_note_selector:
		remove_inspector_plugin(_story_note_selector)

	if _story_talk_selector:
		remove_inspector_plugin(_story_talk_selector)


func _apply_changes() -> void:
	StoryFileSource.save_all_files()


func _edit(object: Object) -> void:
	if object is StoryFile:
		StoryFileSource.reload_file_list()
		_main._reload_files(object)


func _handles(object: Object) -> bool:
	return object is StoryFile


func _has_main_screen() -> bool:
	return true


func _make_visible(visible: bool) -> void:
	if _main:
		if visible:
			StoryFileSource.reload_file_list()
			_main._reload_files()
		_main.visible = visible


func _get_plugin_name() -> String:
	return "Story"


func _get_plugin_icon() -> Texture2D:
	return Icon
