class_name ProxyItemSource extends RefCounted

var name: String
var source: Object
var method_get_item_count: String
var method_get_item_icon: String
var method_get_item_metadata: String
var method_get_item_text: String
var method_get_item_tooltip: String


func get_item_count() -> int:
	return source.call(method_get_item_count)


func get_item_icon(index: int) -> Texture2D:
	return source.call(method_get_item_icon, index)


func get_item_metadata(index: int) -> Variant:
	return source.call(method_get_item_metadata, index)


func get_item_text(index: int) -> String:
	return source.call(method_get_item_text, index)


func get_item_tooltip(index: int) -> String:
	return source.call(method_get_item_tooltip, index)


func _to_string() -> String:
	return "<ProxyItemSource:%s>" % name
