
/*============================ INCLUDES ======================================*/

#include "bsp.h"

#include <RTE_Components.h>
#undef __USE_EVENT_RECORDER__
#if defined(RTE_Compiler_EventRecorder) || defined(RTE_CMSIS_View_EventRecorder)
#   define __USE_EVENT_RECORDER__  1
#endif

#if __USE_EVENT_RECORDER__
#   include <EventRecorder.h>
#   include "EventRecorderConf.h"
#endif


#include "..\..\zero_strm\zero_strm.h"

/*============================ MACROS ========================================*/
#undef   this
#define  this   (*ptThis)
#define  __MY_DEBGU   0
/*============================ MACROFIED FUNCTIONS ===========================*/
/*============================ TYPES =========================================*/
/*============================ GLOBAL VARIABLES ==============================*/

zero_strm_read_t  g_tZStrmRead;
zero_strm_write_t g_tZStrmWrite;

/*============================ PROTOTYPES ====================================*/


static void uart_dma_data_get(zero_strm_mem_blk_t *ptThis);
static void uart_dma_data_send(zero_strm_mem_blk_t *ptThis);
static uint16_t get_dma_cnt(void) ;

/*============================ LOCAL VARIABLES ===============================*/

__attribute__((aligned(32)))
static uint8_t s_chReadBuffer[1024*5];

__attribute__((aligned(32)))
static uint8_t s_chWriteBuffer[1024*5];


static zero_strm_read_cfg_t s_tZStrmReadCfg = {
    .pchBuffer     = s_chReadBuffer,
    .hwSize        = sizeof(s_chReadBuffer),
    .wTimeOutMs    = 4000,
    .fnDmaStartRx  = uart_dma_data_get,
    .fnDmaCntGet   = get_dma_cnt,
};

static zero_strm_write_cfg_t s_tZStrmWriteCfg = {
    .pchBuffer     = s_chWriteBuffer,
    .hwSize        = sizeof(s_chWriteBuffer),
    .fnDmaSendData = uart_dma_data_send,
};





/*============================ IMPLEMENTATION ================================*/

int main(void)
{
    bsp_init();
    
#if __USE_EVENT_RECORDER__    
    EventRecorderInitialize(0, 1);
#endif
    uint8_t chByte = 0x40;

    zero_strm_read_init(&g_tZStrmRead,&s_tZStrmReadCfg);
    zero_strm_write_init(&g_tZStrmWrite,&s_tZStrmWriteCfg);

    while(1) {
        uint8_t chByte;
       
        
        if ( zero_strm_read(&g_tZStrmRead,&chByte) ) {
            
            zero_strm_write(&g_tZStrmWrite,chByte);
             
        } 

    }
}

int stdout_putchar(int ch)
{   
#if 1
    uint8_t chByte = 0;
    chByte = (uint8_t)(0x000000ff&ch);

    if ( zero_strm_write(&g_tZStrmWrite,chByte) ) {
        return ch;
    }
    return -1;
#endif
}

void DMA1_Channel4_IRQHandler(void)
{
#if 1
    if ( RESET != DMA_GetITStatus(DMA1_IT_TC4) ) {
        DMA_Cmd(DMA1_Channel4,DISABLE);
        DMA_ClearITPendingBit(DMA1_IT_TC4);

        zero_strm_dma_send_data_cpl_event_handler(&g_tZStrmWrite);
    }
#endif
}

void DMA1_Channel5_IRQHandler(void)
{   
    if ( RESET != DMA_GetITStatus(DMA1_IT_HT5) ) {
        DMA_ClearITPendingBit(DMA1_IT_HT5);

        zero_strm_uart_dma_get_data_insert_to_dma_irq_event_handler(&g_tZStrmRead); 
    }
   
    if ( RESET != DMA_GetITStatus(DMA1_IT_TC5) ) {
        DMA_ClearITPendingBit(DMA1_IT_TC5);
    }
}

void USART1_IRQHandler(void)
{
    if ( RESET != USART_GetITStatus(USART1,USART_IT_IDLE) ) {
        uint32_t temp = USART1->SR;  
        temp = USART1->DR;
        (void)temp;
        
        zero_strm_uart_idle_insert_to_uart_irq_event_handler(&g_tZStrmRead);
    }
}

void TIM5_IRQHandler(void)
{
    uint32_t timesr;
    uint16_t itstatus = 0x0, itenable = 0x0;
    TIM_TypeDef *TIMx = TIM5;

    timesr = TIMx->SR;
    if (timesr & TIM_IT_Update) {
        TIMx->SR = (uint16_t)~TIM_IT_Update;
        zero_strm_uart_wait_time_out_insert_to_hard_timer_irq_event_handler(&g_tZStrmRead);
    }
    
}

static void uart_dma_data_get(zero_strm_mem_blk_t *ptThis)
{
    if ( NULL == ptThis ) {
        return ;
    }

    DMA_Cmd(DMA1_Channel5,DISABLE);
    
    DMA1_Channel5->CMAR  = (uint32_t)(this.chMemory);
    DMA1_Channel5->CNDTR = this.tSizeInByte;  
    
    DMA_Cmd(DMA1_Channel5,ENABLE);
}

static void uart_dma_data_send(zero_strm_mem_blk_t *ptThis)
{
    if ( NULL == ptThis ) {
        return ;
    }
    
    DMA_Cmd(DMA1_Channel4,DISABLE);
    
    DMA1_Channel4->CMAR  = (uint32_t)(this.chMemory);
    DMA1_Channel4->CNDTR = this.tSizeInByte;  
   
    DMA_Cmd(DMA1_Channel4,ENABLE);
}

static uint16_t get_dma_cnt(void) 
{   
    return DMA_GetCurrDataCounter(DMA1_Channel5);
}

