/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.util.StringConverter;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;

public final class SafeStringConverter<S extends T, T>
extends StringConverter<T> {
    private final ExceptionalFunction<String, S, ?> converter;
    private final Class<?> malformedExceptionClass;
    private S fallbackValue = null;
    private final List<Predicate<S>> restrictions = new ArrayList<Predicate<S>>();

    public static SafeStringConverter<Integer, Number> fromInteger() {
        return new SafeStringConverter(Integer::parseInt, NumberFormatException.class).fallbackTo(0);
    }

    public static SafeStringConverter<Double, Number> fromDouble() {
        return new SafeStringConverter(Double::parseDouble, NumberFormatException.class).fallbackTo(0.0);
    }

    public static SafeStringConverter<Double, Number> fromFiniteDouble() {
        return new SafeStringConverter(Double::parseDouble, NumberFormatException.class).restrict(Double::isFinite).fallbackTo(0.0);
    }

    public <E extends Exception> SafeStringConverter(ExceptionalFunction<String, S, E> converter, Class<E> malformedExceptionClass) {
        this.converter = converter;
        this.malformedExceptionClass = malformedExceptionClass;
    }

    public String toString(T object) {
        return object == null ? "" : object.toString();
    }

    public S fromString(String string) {
        return this.tryParse(string).orElse(this.fallbackValue);
    }

    private Optional<S> tryParse(String string) {
        S converted;
        if (string == null) {
            return Optional.empty();
        }
        try {
            converted = this.converter.apply(string);
        }
        catch (Exception e) {
            if (this.malformedExceptionClass.isInstance(e)) {
                return Optional.empty();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        if (!this.filter(converted)) {
            return Optional.empty();
        }
        return Optional.of(converted);
    }

    private boolean filter(S value) {
        for (Predicate<S> restriction : this.restrictions) {
            if (restriction.test(value)) continue;
            return false;
        }
        return true;
    }

    public SafeStringConverter<S, T> fallbackTo(S fallbackValue) {
        this.fallbackValue = fallbackValue;
        return this;
    }

    public SafeStringConverter<S, T> restrict(Predicate<S> condition) {
        this.restrictions.add(condition);
        return this;
    }

    public Predicate<String> asPredicate() {
        return string -> this.tryParse((String)string).isPresent();
    }

    public SafeStringConverter<S, T> asPredicate(Consumer<Predicate<String>> consumer) {
        consumer.accept(this.asPredicate());
        return this;
    }
}

