/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Log4jLevel {
    FATAL(1),
    ERROR(2),
    WARN(3),
    INFO(4),
    DEBUG(5),
    TRACE(6),
    ALL(Integer.MAX_VALUE);

    private final int level;
    public static final Pattern MINECRAFT_LOGGER;
    public static final Pattern MINECRAFT_LOGGER_CATEGORY;
    public static final String JAVA_SYMBOL = "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$][a-zA-Z\\d_$]*";

    private Log4jLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean lessOrEqual(Log4jLevel level) {
        return this.level <= level.level;
    }

    public static Log4jLevel guessLevel(String line) {
        Log4jLevel level = null;
        Matcher m = MINECRAFT_LOGGER.matcher(line);
        if (m.find()) {
            String level2Str;
            Matcher m2;
            String levelStr = m.group("level");
            if (null != levelStr) {
                switch (levelStr) {
                    case "INFO": {
                        level = INFO;
                        break;
                    }
                    case "WARN": {
                        level = WARN;
                        break;
                    }
                    case "ERROR": {
                        level = ERROR;
                        break;
                    }
                    case "FATAL": {
                        level = FATAL;
                        break;
                    }
                    case "TRACE": {
                        level = TRACE;
                        break;
                    }
                    case "DEBUG": {
                        level = DEBUG;
                        break;
                    }
                }
            }
            if ((m2 = MINECRAFT_LOGGER_CATEGORY.matcher(line)).find() && null != (level2Str = m2.group("category"))) {
                switch (level2Str) {
                    case "STDOUT": {
                        level = INFO;
                        break;
                    }
                    case "STDERR": {
                        level = ERROR;
                    }
                }
            }
            if (line.contains("STDERR]") || line.contains("[STDERR/]")) {
                level = ERROR;
            }
        } else {
            if (line.contains("[INFO]") || line.contains("[CONFIG]") || line.contains("[FINE]") || line.contains("[FINER]") || line.contains("[FINEST]")) {
                level = INFO;
            }
            if (line.contains("[SEVERE]") || line.contains("[STDERR]")) {
                level = ERROR;
            }
            if (line.contains("[WARNING]")) {
                level = WARN;
            }
            if (line.contains("[DEBUG]")) {
                level = DEBUG;
            }
        }
        if (line.contains("overwriting existing")) {
            level = FATAL;
        }
        return level;
    }

    public static boolean isError(Log4jLevel a) {
        return a != null && a.lessOrEqual(ERROR);
    }

    public static Log4jLevel mergeLevel(Log4jLevel a, Log4jLevel b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.level < b.level ? a : b;
    }

    public static boolean guessLogLineError(String log) {
        return Log4jLevel.isError(Log4jLevel.guessLevel(log));
    }

    static {
        MINECRAFT_LOGGER = Pattern.compile("\\[(?<timestamp>[0-9:]+)] \\[[^/]+/(?<level>[^]]+)]");
        MINECRAFT_LOGGER_CATEGORY = Pattern.compile("\\[(?<timestamp>[0-9:]+)] \\[[^/]+/(?<level>[^]]+)] \\[(?<category>[^]]+)]");
    }
}

