/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXPopup;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.DatapackListPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.ui.versions.WorldBackupsPage;
import org.jackhuang.hmcl.ui.versions.WorldInfoPage;
import org.jackhuang.hmcl.util.ChunkBaseApp;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class WorldManagePage
extends DecoratorAnimatedPage
implements DecoratorPage {
    private final ObjectProperty<DecoratorPage.State> state;
    private final World world;
    private final Path backupsDir;
    private final Profile profile;
    private final String id;
    private final TabHeader header;
    private final TabControl.Tab<WorldInfoPage> worldInfoTab = new TabControl.Tab("worldInfoPage");
    private final TabControl.Tab<WorldBackupsPage> worldBackupsTab = new TabControl.Tab("worldBackupsPage");
    private final TabControl.Tab<DatapackListPage> datapackTab = new TabControl.Tab("datapackListPage");
    private final TransitionPane transitionPane = new TransitionPane();
    private FileChannel sessionLockChannel;

    public WorldManagePage(World world, Path backupsDir, Profile profile, String id) {
        this.world = world;
        this.backupsDir = backupsDir;
        this.profile = profile;
        this.id = id;
        this.worldInfoTab.setNodeSupplier(() -> new WorldInfoPage(this));
        this.worldBackupsTab.setNodeSupplier(() -> new WorldBackupsPage(this));
        this.datapackTab.setNodeSupplier(() -> new DatapackListPage(this));
        this.state = new SimpleObjectProperty((Object)DecoratorPage.State.fromTitle(I18n.i18n("world.manage.title", world.getWorldName())));
        this.header = new TabHeader(this.transitionPane, this.worldInfoTab, this.worldBackupsTab);
        this.header.select(this.worldInfoTab);
        try {
            this.sessionLockChannel = world.lock();
            Logger.LOG.info("Acquired lock on world " + world.getFileName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setCenter(new Node[]{this.transitionPane});
        BorderPane left = new BorderPane();
        FXUtils.setLimitWidth((Region)left, 200.0);
        VBox.setVgrow((Node)left, (Priority)Priority.ALWAYS);
        this.setLeft(new Node[]{left});
        AdvancedListBox sideBar = new AdvancedListBox().addNavigationDrawerTab(this.header, this.worldInfoTab, I18n.i18n("world.info"), SVG.INFO, SVG.INFO_FILL).addNavigationDrawerTab(this.header, this.worldBackupsTab, I18n.i18n("world.backup"), SVG.ARCHIVE, SVG.ARCHIVE_FILL);
        if (world.getGameVersion() != null && world.getGameVersion().isAtLeast("1.13", "17w43a")) {
            this.header.getTabs().add(this.datapackTab);
            sideBar.addNavigationDrawerTab(this.header, this.datapackTab, I18n.i18n("world.datapack"), SVG.EXTENSION, SVG.EXTENSION_FILL);
        }
        left.setTop((Node)sideBar);
        AdvancedListBox toolbar = new AdvancedListBox();
        if (world.getGameVersion() != null && world.getGameVersion().isAtLeast("1.20", "23w14a")) {
            toolbar.addNavigationDrawerItem(I18n.i18n("version.launch"), SVG.ROCKET_LAUNCH, this::launch, null);
            toolbar.addNavigationDrawerItem(I18n.i18n("version.launch_script"), SVG.SCRIPT, this::generateLaunchScript, null);
        }
        if (ChunkBaseApp.isSupported(world)) {
            PopupMenu popupMenu = new PopupMenu();
            JFXPopup popup = new JFXPopup((Region)popupMenu);
            popupMenu.getContent().addAll((Object[])new Node[]{new IconedMenuItem(SVG.EXPLORE, I18n.i18n("world.chunkbase.seed_map"), () -> ChunkBaseApp.openSeedMap(world), popup), new IconedMenuItem(SVG.VISIBILITY, I18n.i18n("world.chunkbase.stronghold"), () -> ChunkBaseApp.openStrongholdFinder(world), popup), new IconedMenuItem(SVG.FORT, I18n.i18n("world.chunkbase.nether_fortress"), () -> ChunkBaseApp.openNetherFortressFinder(world), popup)});
            if (world.getGameVersion() != null && world.getGameVersion().compareTo("1.13") >= 0) {
                popupMenu.getContent().add((Object)new IconedMenuItem(SVG.LOCATION_CITY, I18n.i18n("world.chunkbase.end_city"), () -> ChunkBaseApp.openEndCityFinder(world), popup));
            }
            toolbar.addNavigationDrawerItem(I18n.i18n("world.chunkbase"), SVG.EXPLORE, null, chunkBaseMenuItem -> chunkBaseMenuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> popup.show((Node)chunkBaseMenuItem, JFXPopup.PopupVPosition.BOTTOM, JFXPopup.PopupHPosition.LEFT, chunkBaseMenuItem.getWidth(), 0.0))));
        }
        toolbar.addNavigationDrawerItem(I18n.i18n("settings.game.exploration"), SVG.FOLDER_OPEN, () -> FXUtils.openFolder(world.getFile()), null);
        BorderPane.setMargin((Node)toolbar, (Insets)new Insets(0.0, 0.0, 12.0, 0.0));
        left.setBottom((Node)toolbar);
        this.addEventHandler(Navigator.NavigationEvent.EXITED, this::onExited);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state;
    }

    public World getWorld() {
        return this.world;
    }

    public Path getBackupsDir() {
        return this.backupsDir;
    }

    public boolean isReadOnly() {
        return this.sessionLockChannel == null;
    }

    public void onExited(Navigator.NavigationEvent event) {
        if (this.sessionLockChannel != null) {
            try {
                this.sessionLockChannel.close();
                Logger.LOG.info("Releases the lock on world " + this.world.getFileName());
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to close session lock channel", e);
            }
            this.sessionLockChannel = null;
        }
    }

    public void launch() {
        this.fireEvent(new PageCloseEvent());
        Versions.launchAndEnterWorld(this.profile, this.id, this.world.getFileName());
    }

    public void generateLaunchScript() {
        Versions.generateLaunchScriptForQuickEnterWorld(this.profile, this.id, this.world.getFileName());
    }
}

