/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.image.apng.reader;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jackhuang.hmcl.ui.image.apng.reader.PngSource;
import org.jackhuang.hmcl.ui.image.apng.util.InputStreamSlice;

public class PngStreamSource
implements PngSource {
    final InputStream src;
    private final DataInputStream dis;

    public PngStreamSource(InputStream src) {
        this.src = src;
        this.dis = new DataInputStream(this.src);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public boolean supportsByteAccess() {
        return false;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return null;
    }

    @Override
    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    @Override
    public short readUnsignedShort() throws IOException {
        return (short)this.dis.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    @Override
    public long skip(int chunkLength) throws IOException {
        return this.dis.skip(chunkLength);
    }

    @Override
    public int tell() {
        return 0;
    }

    @Override
    public int available() {
        try {
            return this.dis.available();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public DataInputStream getDis() {
        return this.dis;
    }

    @Override
    public InputStream slice(int dataLength) {
        return new InputStreamSlice(this.src, dataLength);
    }
}

