/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.theme;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakListener;
import javafx.beans.property.Property;
import javafx.scene.control.ColorPicker;
import javafx.scene.paint.Color;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=TypeAdapter.class)
public record ThemeColor(@NotNull String name, @NotNull Color color) {
    public static final ThemeColor DEFAULT = new ThemeColor("blue", Color.web((String)"#5C6BC0"));
    public static final List<ThemeColor> STANDARD_COLORS = List.of(DEFAULT, new ThemeColor("darker_blue", Color.web((String)"#283593")), new ThemeColor("green", Color.web((String)"#43A047")), new ThemeColor("orange", Color.web((String)"#E67E22")), new ThemeColor("purple", Color.web((String)"#9C27B0")), new ThemeColor("red", Color.web((String)"#B71C1C")));

    public static String getColorDisplayName(Color c) {
        return c != null ? String.format("#%02X%02X%02X", Math.round(c.getRed() * 255.0), Math.round(c.getGreen() * 255.0), Math.round(c.getBlue() * 255.0)) : null;
    }

    public static String getColorDisplayNameWithOpacity(Color c, double opacity) {
        return c != null ? String.format("#%02X%02X%02X%02X", Math.round(c.getRed() * 255.0), Math.round(c.getGreen() * 255.0), Math.round(c.getBlue() * 255.0), Math.round(opacity * 255.0)) : null;
    }

    @Nullable
    public static ThemeColor of(String name) {
        if (name == null) {
            return null;
        }
        if (!name.startsWith("#")) {
            for (ThemeColor color : STANDARD_COLORS) {
                if (!name.equalsIgnoreCase(color.name())) continue;
                return color;
            }
        }
        try {
            return new ThemeColor(name, Color.web((String)name));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Contract(value="null -> null; !null -> !null")
    public static ThemeColor of(Color color) {
        return color != null ? new ThemeColor(ThemeColor.getColorDisplayName(color), color) : null;
    }

    public static void bindBidirectional(ColorPicker colorPicker, Property<ThemeColor> property) {
        BidirectionalBinding binding = new BidirectionalBinding(colorPicker, property);
        colorPicker.valueProperty().removeListener((InvalidationListener)binding);
        property.removeListener((InvalidationListener)binding);
        ThemeColor themeColor = (ThemeColor)property.getValue();
        colorPicker.setValue((Object)(themeColor != null ? themeColor.color() : null));
        colorPicker.valueProperty().addListener((InvalidationListener)binding);
        property.addListener((InvalidationListener)binding);
    }

    private static final class BidirectionalBinding
    implements InvalidationListener,
    WeakListener {
        private final WeakReference<ColorPicker> colorPickerRef;
        private final WeakReference<Property<ThemeColor>> propertyRef;
        private final int hashCode;
        private boolean updating = false;

        private BidirectionalBinding(ColorPicker colorPicker, Property<ThemeColor> property) {
            this.colorPickerRef = new WeakReference<ColorPicker>(colorPicker);
            this.propertyRef = new WeakReference<Property<ThemeColor>>(property);
            this.hashCode = System.identityHashCode(colorPicker) ^ System.identityHashCode(property);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidated(Observable sourceProperty) {
            if (!this.updating) {
                ColorPicker colorPicker = (ColorPicker)this.colorPickerRef.get();
                Property property = (Property)this.propertyRef.get();
                if (colorPicker == null || property == null) {
                    if (colorPicker != null) {
                        colorPicker.valueProperty().removeListener((InvalidationListener)this);
                    }
                    if (property != null) {
                        property.removeListener((InvalidationListener)this);
                    }
                } else {
                    this.updating = true;
                    try {
                        if (property == sourceProperty) {
                            ThemeColor newValue = (ThemeColor)property.getValue();
                            colorPicker.setValue((Object)(newValue != null ? newValue.color() : null));
                        } else {
                            Color newValue = (Color)colorPicker.getValue();
                            property.setValue((Object)(newValue != null ? ThemeColor.of(newValue) : null));
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }

        public boolean wasGarbageCollected() {
            return this.colorPickerRef.get() == null || this.propertyRef.get() == null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BidirectionalBinding)) {
                return false;
            }
            BidirectionalBinding that = (BidirectionalBinding)o;
            ColorPicker colorPicker = (ColorPicker)this.colorPickerRef.get();
            Property property = (Property)this.propertyRef.get();
            ColorPicker thatColorPicker = (ColorPicker)that.colorPickerRef.get();
            Property thatProperty = (Property)that.propertyRef.get();
            if (colorPicker == null || property == null || thatColorPicker == null || thatProperty == null) {
                return false;
            }
            return colorPicker == thatColorPicker && property == thatProperty;
        }
    }

    static final class TypeAdapter
    extends com.google.gson.TypeAdapter<ThemeColor> {
        TypeAdapter() {
        }

        @Override
        public void write(JsonWriter out, ThemeColor value) throws IOException {
            out.value(value.name());
        }

        @Override
        public ThemeColor read(JsonReader in) throws IOException {
            return Objects.requireNonNullElse(ThemeColor.of(in.nextString()), DEFAULT);
        }
    }
}

