/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.jackhuang.hmcl.mod.LocalMod;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class LocalModFile
implements Comparable<LocalModFile> {
    private Path file;
    private final ModManager modManager;
    private final LocalMod mod;
    private final String name;
    private final Description description;
    private final String authors;
    private final String version;
    private final String gameVersion;
    private final String url;
    private final String fileName;
    private final String logoPath;
    private final BooleanProperty activeProperty;

    public LocalModFile(ModManager modManager, LocalMod mod, Path file, String name, Description description) {
        this(modManager, mod, file, name, description, "", "", "", "", "");
    }

    public LocalModFile(final ModManager modManager, LocalMod mod, Path file, String name, Description description, String authors, String version, String gameVersion, String url, String logoPath) {
        this.modManager = modManager;
        this.mod = mod;
        this.file = file;
        this.name = name;
        this.description = description;
        this.authors = authors;
        this.version = version;
        this.gameVersion = gameVersion;
        this.url = url;
        this.logoPath = logoPath;
        this.activeProperty = new SimpleBooleanProperty(this, "active", !modManager.isDisabled(file)){

            protected void invalidated() {
                if (LocalModFile.this.isOld()) {
                    return;
                }
                Path path = LocalModFile.this.file.toAbsolutePath();
                try {
                    LocalModFile.this.file = this.get() ? modManager.enableMod(path) : modManager.disableMod(path);
                }
                catch (IOException e) {
                    Logger.LOG.error("Unable to invert state of mod file " + String.valueOf(path), e);
                }
            }
        };
        this.fileName = FileUtils.getNameWithoutExtension(ModManager.getModName(file));
        if (this.isOld()) {
            mod.getOldFiles().add(this);
        } else {
            mod.getFiles().add(this);
        }
    }

    public ModManager getModManager() {
        return this.modManager;
    }

    public LocalMod getMod() {
        return this.mod;
    }

    public Path getFile() {
        return this.file;
    }

    public ModLoaderType getModLoaderType() {
        return this.mod.getModLoaderType();
    }

    public String getId() {
        return this.mod.getId();
    }

    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public String getAuthors() {
        return this.authors;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLogoPath() {
        return this.logoPath;
    }

    public BooleanProperty activeProperty() {
        return this.activeProperty;
    }

    public boolean isActive() {
        return this.activeProperty.get();
    }

    public void setActive(boolean active) {
        this.activeProperty.set(active);
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isOld() {
        return this.modManager.isOld(this.file);
    }

    public void setOld(boolean old) throws IOException {
        this.file = this.modManager.setOld(this, old);
        if (old) {
            this.mod.getFiles().remove(this);
            this.mod.getOldFiles().add(this);
        } else {
            this.mod.getOldFiles().remove(this);
            this.mod.getFiles().add(this);
        }
    }

    public void disable() throws IOException {
        this.file = this.modManager.disableMod(this.file);
    }

    public ModUpdate checkUpdates(String gameVersion, RemoteModRepository repository) throws IOException {
        Optional<RemoteMod.Version> currentVersion = repository.getRemoteVersionByLocalFile(this, this.file);
        if (!currentVersion.isPresent()) {
            return null;
        }
        List<RemoteMod.Version> remoteVersions = repository.getRemoteVersionsById(currentVersion.get().getModid()).filter(version -> version.getGameVersions().contains(gameVersion)).filter(version -> version.getLoaders().contains((Object)this.getModLoaderType())).filter(version -> version.getDatePublished().compareTo(((RemoteMod.Version)currentVersion.get()).getDatePublished()) > 0).sorted(Comparator.comparing(RemoteMod.Version::getDatePublished).reversed()).collect(Collectors.toList());
        if (remoteVersions.isEmpty()) {
            return null;
        }
        return new ModUpdate(this, currentVersion.get(), remoteVersions);
    }

    @Override
    public int compareTo(LocalModFile o) {
        return this.getFileName().compareToIgnoreCase(o.getFileName());
    }

    public boolean equals(Object obj) {
        return obj instanceof LocalModFile && Objects.equals(this.getFileName(), ((LocalModFile)obj).getFileName());
    }

    public int hashCode() {
        return Objects.hash(this.getFileName());
    }

    public static class Description {
        private final List<Part> parts;

        public Description(String text) {
            this.parts = new ArrayList<Part>();
            this.parts.add(new Part(text, "black"));
        }

        public Description(List<Part> parts) {
            this.parts = parts;
        }

        public List<Part> getParts() {
            return this.parts;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Part part : this.parts) {
                builder.append(part.text);
            }
            return builder.toString();
        }

        public static class Part {
            private final String text;
            private final String color;

            public Part(String text) {
                this(text, "");
            }

            public Part(String text, String color) {
                this.text = Objects.requireNonNull(text);
                this.color = Objects.requireNonNull(color);
            }

            public String getText() {
                return this.text;
            }

            public String getColor() {
                return this.color;
            }
        }
    }

    public static class ModUpdate {
        private final LocalModFile localModFile;
        private final RemoteMod.Version currentVersion;
        private final List<RemoteMod.Version> candidates;

        public ModUpdate(LocalModFile localModFile, RemoteMod.Version currentVersion, List<RemoteMod.Version> candidates) {
            this.localModFile = localModFile;
            this.currentVersion = currentVersion;
            this.candidates = candidates;
        }

        public LocalModFile getLocalMod() {
            return this.localModFile;
        }

        public RemoteMod.Version getCurrentVersion() {
            return this.currentVersion;
        }

        public List<RemoteMod.Version> getCandidates() {
            return this.candidates;
        }
    }
}

