/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.quilt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.UnsupportedInstallationException;
import org.jackhuang.hmcl.download.quilt.QuiltRemoteVersion;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;

public final class QuiltInstallTask
extends Task<Version> {
    private final DefaultDependencyManager dependencyManager;
    private final Version version;
    private final QuiltRemoteVersion remote;
    private final GetTask launchMetaTask;
    private final List<Task<?>> dependencies = new ArrayList(1);

    public QuiltInstallTask(DefaultDependencyManager dependencyManager, Version version, QuiltRemoteVersion remoteVersion) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.remote = remoteVersion;
        this.launchMetaTask = new GetTask(dependencyManager.getDownloadProvider().injectURLsWithCandidates(remoteVersion.getUrls()));
        this.launchMetaTask.setCacheRepository(dependencyManager.getCacheRepository());
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        if (!Objects.equals("net.minecraft.client.main.Main", this.version.resolve(this.dependencyManager.getGameRepository()).getMainClass())) {
            throw new UnsupportedInstallationException(3);
        }
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return Collections.singleton(this.launchMetaTask);
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isRelyingOnDependencies() {
        return false;
    }

    @Override
    public void execute() {
        this.setResult(this.getPatch(JsonUtils.GSON.fromJson((String)this.launchMetaTask.getResult(), QuiltInfo.class), this.remote.getGameVersion(), this.remote.getSelfVersion()));
        this.dependencies.add(this.dependencyManager.checkLibraryCompletionAsync((Version)this.getResult(), true));
    }

    private Version getPatch(QuiltInfo quiltInfo, String gameVersion, String loaderVersion) {
        JsonObject launcherMeta = quiltInfo.launcherMeta;
        Arguments arguments = new Arguments();
        String mainClass = !launcherMeta.get("mainClass").isJsonObject() ? launcherMeta.get("mainClass").getAsString() : launcherMeta.get("mainClass").getAsJsonObject().get("client").getAsString();
        if (launcherMeta.has("launchwrapper")) {
            String clientTweaker = launcherMeta.get("launchwrapper").getAsJsonObject().get("tweakers").getAsJsonObject().get("client").getAsJsonArray().get(0).getAsString();
            arguments = arguments.addGameArguments("--tweakClass", clientTweaker);
        }
        JsonObject librariesObject = launcherMeta.getAsJsonObject("libraries");
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (String side : new String[]{"common", "server"}) {
            for (JsonElement element : librariesObject.getAsJsonArray(side)) {
                libraries.add(JsonUtils.GSON.fromJson(element, Library.class));
            }
        }
        libraries.add(new Library(Artifact.fromDescriptor(quiltInfo.intermediary.maven), QuiltInstallTask.getMavenRepositoryByGroup(quiltInfo.intermediary.maven), null));
        libraries.add(new Library(Artifact.fromDescriptor(quiltInfo.loader.maven), QuiltInstallTask.getMavenRepositoryByGroup(quiltInfo.loader.maven), null));
        return new Version(LibraryAnalyzer.LibraryType.QUILT.getPatchId(), loaderVersion, 30000, arguments, mainClass, libraries);
    }

    private static String getMavenRepositoryByGroup(String maven) {
        Artifact artifact = Artifact.fromDescriptor(maven);
        switch (artifact.getGroup()) {
            case "net.fabricmc": {
                return "https://maven.fabricmc.net/";
            }
            case "org.quiltmc": {
                return "https://maven.quiltmc.org/repository/release/";
            }
        }
        return "https://maven.fabricmc.net/";
    }

    public static class QuiltInfo {
        private final LoaderInfo loader;
        private final IntermediaryInfo hashed;
        private final IntermediaryInfo intermediary;
        private final JsonObject launcherMeta;

        public QuiltInfo(LoaderInfo loader, IntermediaryInfo hashed, IntermediaryInfo intermediary, JsonObject launcherMeta) {
            this.loader = loader;
            this.hashed = hashed;
            this.intermediary = intermediary;
            this.launcherMeta = launcherMeta;
        }

        public LoaderInfo getLoader() {
            return this.loader;
        }

        public IntermediaryInfo getHashed() {
            return this.hashed;
        }

        public IntermediaryInfo getIntermediary() {
            return this.intermediary;
        }

        public JsonObject getLauncherMeta() {
            return this.launcherMeta;
        }
    }

    public static class IntermediaryInfo {
        private final String maven;
        private final String version;

        public IntermediaryInfo(String maven, String version) {
            this.maven = maven;
            this.version = version;
        }

        public String getMaven() {
            return this.maven;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static class LoaderInfo {
        private final String separator;
        private final int build;
        private final String maven;
        private final String version;
        private final boolean stable;

        public LoaderInfo(String separator, int build, String maven, String version, boolean stable) {
            this.separator = separator;
            this.build = build;
            this.maven = maven;
            this.version = version;
            this.stable = stable;
        }

        public String getSeparator() {
            return this.separator;
        }

        public int getBuild() {
            return this.build;
        }

        public String getMaven() {
            return this.maven;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isStable() {
            return this.stable;
        }
    }
}

