/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.liteloader;

import java.util.Collections;
import java.util.Map;
import org.jackhuang.hmcl.download.BMCLAPIDownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderVersion;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class LiteLoaderBMCLVersionList
extends VersionList<LiteLoaderRemoteVersion> {
    private final BMCLAPIDownloadProvider downloadProvider;

    public LiteLoaderBMCLVersionList(BMCLAPIDownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public Task<?> refreshAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Task<?> refreshAsync(String gameVersion) {
        return new GetTask(NetworkUtils.withQuery(this.downloadProvider.getApiRoot() + "/liteloader/list", Map.of("mcversion", gameVersion))).thenApplyAsync(json -> JsonUtils.fromMaybeMalformedJson(json, LiteLoaderBMCLVersion.class)).thenAcceptAsync(v -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                if (v == null) {
                    return;
                }
                this.versions.put(gameVersion, new LiteLoaderRemoteVersion(gameVersion, v.version, RemoteVersion.Type.UNCATEGORIZED, Collections.singletonList(NetworkUtils.withQuery(this.downloadProvider.getApiRoot() + "/liteloader/download", Collections.singletonMap("version", v.version))), v.build.getTweakClass(), v.build.getLibraries()));
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private static final class LiteLoaderBMCLVersion {
        private final LiteLoaderVersion build;
        private final String version;

        public LiteLoaderBMCLVersion(LiteLoaderVersion build, String version) {
            this.build = build;
            this.version = version;
        }
    }
}

