/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.java.mojang;

import java.util.Collections;
import java.util.Map;
import org.jackhuang.hmcl.game.DownloadInfo;
import org.jackhuang.hmcl.util.gson.JsonSubtype;
import org.jackhuang.hmcl.util.gson.JsonType;

public final class MojangJavaRemoteFiles {
    private final Map<String, Remote> files;

    public MojangJavaRemoteFiles(Map<String, Remote> files) {
        this.files = files;
    }

    public Map<String, Remote> getFiles() {
        return this.files;
    }

    public static class RemoteLink
    extends Remote {
        private final String target;

        public RemoteLink(String target) {
            super("link");
            this.target = target;
        }

        public String getTarget() {
            return this.target;
        }
    }

    public static class RemoteDirectory
    extends Remote {
        public RemoteDirectory() {
            super("directory");
        }
    }

    public static class RemoteFile
    extends Remote {
        private final boolean executable;
        private final Map<String, DownloadInfo> downloads;

        public RemoteFile(boolean executable, Map<String, DownloadInfo> downloads) {
            super("file");
            this.executable = executable;
            this.downloads = downloads;
        }

        public boolean isExecutable() {
            return this.executable;
        }

        public Map<String, DownloadInfo> getDownloads() {
            return this.downloads == null ? Collections.emptyMap() : this.downloads;
        }
    }

    @JsonType(property="type", subtypes={@JsonSubtype(clazz=RemoteFile.class, name="file"), @JsonSubtype(clazz=RemoteDirectory.class, name="directory"), @JsonSubtype(clazz=RemoteLink.class, name="link")})
    public static class Remote {
        private final String type;

        public Remote(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

