/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.offline;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javafx.beans.binding.ObjectBinding;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactInfo;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloadException;
import org.jackhuang.hmcl.auth.offline.Skin;
import org.jackhuang.hmcl.auth.offline.YggdrasilServer;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;

public class OfflineAccount
extends Account {
    private final AuthlibInjectorArtifactProvider downloader;
    private final String username;
    private final UUID uuid;
    private Skin skin;

    protected OfflineAccount(AuthlibInjectorArtifactProvider downloader, String username, UUID uuid, Skin skin) {
        this.downloader = Objects.requireNonNull(downloader);
        this.username = Objects.requireNonNull(username);
        this.uuid = Objects.requireNonNull(uuid);
        this.skin = skin;
        if (StringUtils.isBlank(username)) {
            throw new IllegalArgumentException("Username cannot be blank");
        }
    }

    public AuthlibInjectorArtifactProvider getDownloader() {
        return this.downloader;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getCharacter() {
        return this.username;
    }

    @Override
    public String getIdentifier() {
        return this.username + ":" + this.username;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
        this.invalidate();
    }

    protected boolean loadAuthlibInjector(Skin skin) {
        return skin != null && skin.getType() != Skin.Type.DEFAULT;
    }

    public AuthInfo logInWithoutSkin() throws AuthenticationException {
        return new AuthInfo(this.username, this.uuid, UUIDTypeAdapter.fromUUID(UUID.randomUUID()), "msa", "{}");
    }

    @Override
    public AuthInfo logIn() throws AuthenticationException {
        AuthInfo authInfo = this.logInWithoutSkin();
        if (this.loadAuthlibInjector(this.skin)) {
            AuthlibInjectorArtifactInfo artifact;
            CompletableFuture<AuthlibInjectorArtifactInfo> artifactTask = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.downloader.getArtifactInfo();
                }
                catch (IOException e) {
                    throw new CompletionException(new AuthlibInjectorDownloadException(e));
                }
            });
            try {
                artifact = artifactTask.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AuthenticationException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof AuthenticationException) {
                    throw (AuthenticationException)e.getCause();
                }
                throw new AuthenticationException(e.getCause());
            }
            try {
                return new OfflineAuthInfo(authInfo, artifact);
            }
            catch (Exception e) {
                throw new AuthenticationException(e);
            }
        }
        return authInfo;
    }

    @Override
    public AuthInfo playOffline() throws AuthenticationException {
        return this.logIn();
    }

    @Override
    public Map<Object, Object> toStorage() {
        return Lang.mapOf(Pair.pair("uuid", UUIDTypeAdapter.fromUUID(this.uuid)), Pair.pair("username", this.username), Pair.pair("skin", this.skin == null ? null : this.skin.toStorage()));
    }

    @Override
    public ObjectBinding<Optional<Map<TextureType, Texture>>> getTextures() {
        return super.getTextures();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("username", this.username).append("uuid", this.uuid).toString();
    }

    @Override
    public int hashCode() {
        return this.username.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflineAccount)) {
            return false;
        }
        OfflineAccount another = (OfflineAccount)obj;
        return this.isPortable() == another.isPortable() && this.username.equals(another.username);
    }

    private class OfflineAuthInfo
    extends AuthInfo {
        private final AuthlibInjectorArtifactInfo artifact;
        private YggdrasilServer server;

        public OfflineAuthInfo(AuthInfo authInfo, AuthlibInjectorArtifactInfo artifact) {
            super(authInfo.getUsername(), authInfo.getUUID(), authInfo.getAccessToken(), "msa", authInfo.getUserProperties());
            this.artifact = artifact;
        }

        @Override
        public Arguments getLaunchArguments(LaunchOptions options) throws IOException {
            if (!options.isDaemon()) {
                return null;
            }
            this.server = new YggdrasilServer(0);
            this.server.start();
            try {
                this.server.addCharacter(new YggdrasilServer.Character(OfflineAccount.this.uuid, OfflineAccount.this.username, OfflineAccount.this.skin != null ? OfflineAccount.this.skin.load(OfflineAccount.this.username).run() : null));
            }
            catch (IOException iOException) {
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return new Arguments().addJVMArguments("-javaagent:" + this.artifact.getLocation().toString() + "=http://localhost:" + this.server.getListeningPort(), "-Dauthlibinjector.side=client");
        }

        @Override
        public void close() throws Exception {
            super.close();
            if (this.server != null) {
                this.server.stop();
            }
        }
    }
}

