/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.authlibinjector;

import java.net.URI;
import java.util.UUID;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilProvider;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;

public class AuthlibInjectorProvider
implements YggdrasilProvider {
    private final String apiRoot;

    public AuthlibInjectorProvider(String apiRoot) {
        this.apiRoot = apiRoot;
    }

    @Override
    public URI getAuthenticationURL() throws AuthenticationException {
        return URI.create(this.apiRoot + "authserver/authenticate");
    }

    @Override
    public URI getRefreshmentURL() throws AuthenticationException {
        return URI.create(this.apiRoot + "authserver/refresh");
    }

    @Override
    public URI getValidationURL() throws AuthenticationException {
        return URI.create(this.apiRoot + "authserver/validate");
    }

    @Override
    public URI getInvalidationURL() throws AuthenticationException {
        return URI.create(this.apiRoot + "authserver/invalidate");
    }

    @Override
    public URI getSkinUploadURL(UUID uuid) throws UnsupportedOperationException {
        return URI.create(this.apiRoot + "api/user/profile/" + UUIDTypeAdapter.fromUUID(uuid) + "/skin");
    }

    @Override
    public URI getProfilePropertiesURL(UUID uuid) throws AuthenticationException {
        return URI.create(this.apiRoot + "sessionserver/session/minecraft/profile/" + UUIDTypeAdapter.fromUUID(uuid));
    }

    public String toString() {
        return this.apiRoot;
    }
}

