/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

public final class Metadata {
    public static final String NAME = "HMCL";
    public static final String FULL_NAME = "Hello Minecraft! Launcher";
    public static final String VERSION;
    public static final String TITLE;
    public static final String FULL_TITLE;
    public static final int MINIMUM_REQUIRED_JAVA_VERSION = 17;
    public static final int MINIMUM_SUPPORTED_JAVA_VERSION = 17;
    public static final int RECOMMENDED_JAVA_VERSION = 21;
    public static final String PUBLISH_URL = "https://hmcl.huangyuhui.net";
    public static final String ABOUT_URL = "https://hmcl.huangyuhui.net/about";
    public static final String DOWNLOAD_URL = "https://hmcl.huangyuhui.net/download";
    public static final String HMCL_UPDATE_URL;
    public static final String DOCS_URL = "https://docs.hmcl.net";
    public static final String CONTACT_URL = "https://docs.hmcl.net/help.html";
    public static final String CHANGELOG_URL = "https://docs.hmcl.net/changelog/";
    public static final String EULA_URL = "https://docs.hmcl.net/eula/hmcl.html";
    public static final String GROUPS_URL = "https://www.bilibili.com/opus/905435541874409529";
    public static final String BUILD_CHANNEL;
    public static final String GITHUB_SHA;
    public static final Path CURRENT_DIRECTORY;
    public static final Path MINECRAFT_DIRECTORY;
    public static final Path HMCL_GLOBAL_DIRECTORY;
    public static final Path HMCL_CURRENT_DIRECTORY;
    public static final Path DEPENDENCIES_DIRECTORY;

    private Metadata() {
    }

    public static boolean isStable() {
        return "stable".equals(BUILD_CHANNEL);
    }

    public static boolean isDev() {
        return "dev".equals(BUILD_CHANNEL);
    }

    public static boolean isNightly() {
        return !Metadata.isStable() && !Metadata.isDev();
    }

    @Nullable
    public static String getSuggestedJavaDownloadLink() {
        if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX && Architecture.SYSTEM_ARCH == Architecture.LOONGARCH64_OW) {
            return "https://www.loongnix.cn/zh/api/java/downloads-jdk21/index.html";
        }
        EnumSet<Object> supportedArchitectures = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? EnumSet.of(Architecture.X86_64, Architecture.X86, Architecture.ARM64) : (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX ? EnumSet.of(Architecture.X86_64, new Architecture[]{Architecture.X86, Architecture.ARM64, Architecture.ARM32, Architecture.RISCV64, Architecture.LOONGARCH64}) : (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS ? EnumSet.of(Architecture.X86_64, Architecture.ARM64) : EnumSet.noneOf(Architecture.class)));
        if (supportedArchitectures.contains((Object)Architecture.SYSTEM_ARCH)) {
            return String.format("https://docs.hmcl.net/downloads/%s/%s.html", OperatingSystem.CURRENT_OS.getCheckedName(), Architecture.SYSTEM_ARCH.getCheckedName());
        }
        return null;
    }

    static {
        String xdgData;
        VERSION = System.getProperty("hmcl.version.override", JarUtils.getAttribute("hmcl.version", "@develop@"));
        TITLE = "HMCL " + VERSION;
        FULL_TITLE = "Hello Minecraft! Launcher v" + VERSION;
        HMCL_UPDATE_URL = System.getProperty("hmcl.update_source.override", "https://hmcl.huangyuhui.net/api/update_link");
        BUILD_CHANNEL = JarUtils.getAttribute("hmcl.version.type", "nightly");
        GITHUB_SHA = JarUtils.getAttribute("hmcl.version.hash", null);
        CURRENT_DIRECTORY = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize();
        MINECRAFT_DIRECTORY = OperatingSystem.getWorkingDirectory("minecraft");
        String hmclHome = System.getProperty("hmcl.home");
        HMCL_GLOBAL_DIRECTORY = hmclHome == null ? (OperatingSystem.CURRENT_OS.isLinuxOrBSD() ? (StringUtils.isNotBlank(xdgData = System.getenv("XDG_DATA_HOME")) ? Paths.get(xdgData, "hmcl").toAbsolutePath().normalize() : Paths.get(System.getProperty("user.home"), ".local", "share", "hmcl").toAbsolutePath().normalize()) : OperatingSystem.getWorkingDirectory("hmcl")) : Paths.get(hmclHome, new String[0]).toAbsolutePath().normalize();
        String hmclCurrentDir = System.getProperty("hmcl.dir");
        HMCL_CURRENT_DIRECTORY = hmclCurrentDir != null ? Paths.get(hmclCurrentDir, new String[0]).toAbsolutePath().normalize() : CURRENT_DIRECTORY.resolve(".hmcl");
        DEPENDENCIES_DIRECTORY = HMCL_CURRENT_DIRECTORY.resolve("dependencies");
    }
}

