/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx;

import org.jetbrains.annotations.NotNull;

public final class Contrast {
    public static final Contrast LOW = new Contrast(-1.0);
    public static final Contrast STANDARD = new Contrast(0.0);
    public static final Contrast MEDIUM = new Contrast(0.5);
    public static final Contrast HIGH = new Contrast(1.0);
    public static final Contrast DEFAULT = STANDARD;
    private final double value;

    @NotNull
    public static Contrast of(double value) {
        if (value < -1.0 || value > 1.0 || Double.isNaN(value)) {
            throw new IllegalArgumentException("Contrast value must be between -1.0 and 1.0.");
        }
        if (value == Contrast.LOW.value) {
            return LOW;
        }
        if (value == Contrast.STANDARD.value) {
            return STANDARD;
        }
        if (value == Contrast.MEDIUM.value) {
            return MEDIUM;
        }
        if (value == Contrast.HIGH.value) {
            return HIGH;
        }
        return new Contrast(value);
    }

    private Contrast(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Contrast)) {
            return false;
        }
        return this.value == ((Contrast)o).value;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public String toString() {
        return "Contrast[" + this.value + ']';
    }
}

