/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.glavo.monetfx.internal.dynamiccolor.ColorSpec;
import org.glavo.monetfx.internal.dynamiccolor.DynamicColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ColorRole {
    PRIMARY(ColorSpec::primary),
    ON_PRIMARY(ColorSpec::onPrimary),
    PRIMARY_CONTAINER(ColorSpec::primaryContainer),
    ON_PRIMARY_CONTAINER(ColorSpec::onPrimaryContainer),
    PRIMARY_FIXED(ColorSpec::primaryFixed),
    PRIMARY_FIXED_DIM(ColorSpec::primaryFixedDim),
    ON_PRIMARY_FIXED(ColorSpec::onPrimaryFixed),
    ON_PRIMARY_FIXED_VARIANT(ColorSpec::onPrimaryFixedVariant),
    SECONDARY(ColorSpec::secondary),
    ON_SECONDARY(ColorSpec::onSecondary),
    SECONDARY_CONTAINER(ColorSpec::secondaryContainer),
    ON_SECONDARY_CONTAINER(ColorSpec::onSecondaryContainer),
    SECONDARY_FIXED(ColorSpec::secondaryFixed),
    SECONDARY_FIXED_DIM(ColorSpec::secondaryFixedDim),
    ON_SECONDARY_FIXED(ColorSpec::onSecondaryFixed),
    ON_SECONDARY_FIXED_VARIANT(ColorSpec::onSecondaryFixedVariant),
    TERTIARY(ColorSpec::tertiary),
    ON_TERTIARY(ColorSpec::onTertiary),
    TERTIARY_CONTAINER(ColorSpec::tertiaryContainer),
    ON_TERTIARY_CONTAINER(ColorSpec::onTertiaryContainer),
    TERTIARY_FIXED(ColorSpec::tertiaryFixed),
    TERTIARY_FIXED_DIM(ColorSpec::tertiaryFixedDim),
    ON_TERTIARY_FIXED(ColorSpec::onTertiaryFixed),
    ON_TERTIARY_FIXED_VARIANT(ColorSpec::onTertiaryFixedVariant),
    ERROR(ColorSpec::error),
    ON_ERROR(ColorSpec::onError),
    ERROR_CONTAINER(ColorSpec::errorContainer),
    ON_ERROR_CONTAINER(ColorSpec::onErrorContainer),
    SURFACE(ColorSpec::surface),
    ON_SURFACE(ColorSpec::onSurface),
    SURFACE_DIM(ColorSpec::surfaceDim),
    SURFACE_BRIGHT(ColorSpec::surfaceBright),
    SURFACE_CONTAINER_LOWEST(ColorSpec::surfaceContainerLowest),
    SURFACE_CONTAINER_LOW(ColorSpec::surfaceContainerLow),
    SURFACE_CONTAINER(ColorSpec::surfaceContainer),
    SURFACE_CONTAINER_HIGH(ColorSpec::surfaceContainerHigh),
    SURFACE_CONTAINER_HIGHEST(ColorSpec::surfaceContainerHighest),
    SURFACE_VARIANT(ColorSpec::surfaceVariant),
    ON_SURFACE_VARIANT(ColorSpec::onSurfaceVariant),
    BACKGROUND(ColorSpec::background),
    ON_BACKGROUND(ColorSpec::onBackground),
    OUTLINE(ColorSpec::outline),
    OUTLINE_VARIANT(ColorSpec::outlineVariant),
    SHADOW(ColorSpec::shadow),
    SCRIM(ColorSpec::scrim),
    INVERSE_SURFACE(ColorSpec::inverseSurface),
    INVERSE_ON_SURFACE(ColorSpec::inverseOnSurface),
    INVERSE_PRIMARY(ColorSpec::inversePrimary),
    SURFACE_TINT(ColorSpec::surfaceTint);

    static final String DEFAULT_VARIABLE_NAME_PREFIX = "-monet";
    public static final List<ColorRole> ALL;
    private static final Map<String, ColorRole> searchTable;
    final String displayName;
    final Function<ColorSpec, DynamicColor> accessor;
    final String variableNameBase = this.name().toLowerCase(Locale.ROOT).replace("_", "-");
    final String defaultVariableName = "-monet-" + this.variableNameBase;

    private static String normalizeName(String name) {
        if (name.indexOf(95) >= 0) {
            name = name.replace("_", "");
        } else if (name.indexOf(45) >= 0) {
            name = name.replace("-", "");
        }
        return name.toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static ColorRole of(@NotNull String role) {
        return searchTable.get(ColorRole.normalizeName(role));
    }

    private ColorRole(Function<ColorSpec, DynamicColor> accessor) {
        this.accessor = accessor;
        CharSequence[] parts = this.name().split("_");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = ((String)parts[i]).charAt(0) + ((String)parts[i]).substring(1).toLowerCase(Locale.ROOT);
        }
        this.displayName = String.join((CharSequence)" ", parts);
    }

    public String getVariableName(String prefix) {
        return prefix + "-" + this.variableNameBase;
    }

    public String getVariableName() {
        return this.defaultVariableName;
    }

    public String toString() {
        return this.displayName;
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(ColorRole.values()));
        searchTable = new HashMap<String, ColorRole>();
        for (ColorRole role : ALL) {
            if (searchTable.put(ColorRole.normalizeName(role.name()), role) != null) {
                throw new AssertionError((Object)("Duplicate role: " + (Object)((Object)role)));
            }
        }
    }
}

