/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.utils;

import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

public final class TimeUtils {
    static final long HUNDRED_NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L) / 100L;
    private static final long HUNDRED_NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L) / 100L;
    static final long WINDOWS_EPOCH_OFFSET = -116444736000000000L;

    public static boolean isUnixTime(FileTime time) {
        return TimeUtils.isUnixTime(TimeUtils.toUnixTime(time));
    }

    public static boolean isUnixTime(long seconds) {
        return Integer.MIN_VALUE <= seconds && seconds <= Integer.MAX_VALUE;
    }

    public static FileTime ntfsTimeToFileTime(long ntfsTime) {
        long javaHundredsNanos = Math.addExact(ntfsTime, -116444736000000000L);
        long javaSeconds = Math.floorDiv(javaHundredsNanos, HUNDRED_NANOS_PER_SECOND);
        long javaNanos = Math.floorMod(javaHundredsNanos, HUNDRED_NANOS_PER_SECOND) * 100L;
        return FileTime.from(Instant.ofEpochSecond(javaSeconds, javaNanos));
    }

    public static long toNtfsTime(FileTime fileTime) {
        Instant instant = fileTime.toInstant();
        long javaHundredNanos = instant.getEpochSecond() * HUNDRED_NANOS_PER_SECOND + (long)(instant.getNano() / 100);
        return Math.subtractExact(javaHundredNanos, -116444736000000000L);
    }

    public static long toNtfsTime(long javaTime) {
        long javaHundredNanos = javaTime * HUNDRED_NANOS_PER_MILLISECOND;
        return Math.subtractExact(javaHundredNanos, -116444736000000000L);
    }

    public static long toUnixTime(FileTime fileTime) {
        return fileTime != null ? fileTime.to(TimeUnit.SECONDS) : 0L;
    }

    public static FileTime truncateToHundredNanos(FileTime fileTime) {
        Instant instant = fileTime.toInstant();
        return FileTime.from(Instant.ofEpochSecond(instant.getEpochSecond(), instant.getNano() / 100 * 100));
    }

    public static FileTime unixTimeToFileTime(long time) {
        return FileTime.from(time, TimeUnit.SECONDS);
    }

    public static FileTime dosTimeToFileTime(long dosTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, (int)(dosTime >> 25 & 0x7FL) + 1980);
        cal.set(2, (int)(dosTime >> 21 & 0xFL) - 1);
        cal.set(5, (int)(dosTime >> 16) & 0x1F);
        cal.set(11, (int)(dosTime >> 11) & 0x1F);
        cal.set(12, (int)(dosTime >> 5) & 0x3F);
        cal.set(13, (int)(dosTime << 1) & 0x3E);
        cal.set(14, 0);
        return FileTime.fromMillis(cal.getTimeInMillis());
    }

    private TimeUtils() {
    }
}

