/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.skins.ListViewSkin;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.effects.JFXDepthManager;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.skin.VirtualFlow;
import org.jackhuang.hmcl.ui.FXUtils;

public class JFXListViewSkin<T>
extends ListViewSkin<T> {
    private final VirtualFlow<ListCell<T>> flow = (VirtualFlow)this.getChildren().get(0);

    public JFXListViewSkin(JFXListView<T> listView) {
        super(listView);
        JFXDepthManager.setDepth(this.flow, (Integer)listView.depthProperty().get());
        listView.depthProperty().addListener((o, oldVal, newVal) -> JFXDepthManager.setDepth(this.flow, newVal));
        if (!Boolean.TRUE.equals(listView.getProperties().get((Object)"no-smooth-scrolling"))) {
            FXUtils.smoothScrolling(this.flow);
        }
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 200.0;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        int itemsCount = ((ListView)this.getSkinnable()).getItems().size();
        if (((ListView)this.getSkinnable()).maxHeightProperty().isBound() || itemsCount <= 0) {
            return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        double fixedCellSize = ((ListView)this.getSkinnable()).getFixedCellSize();
        double computedHeight = fixedCellSize != -1.0 ? fixedCellSize * (double)itemsCount + this.snapVerticalInsets() : this.estimateHeight();
        double height = super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        if (height > computedHeight) {
            height = computedHeight;
        }
        if (((ListView)this.getSkinnable()).getMaxHeight() > 0.0 && computedHeight > ((ListView)this.getSkinnable()).getMaxHeight()) {
            return ((ListView)this.getSkinnable()).getMaxHeight();
        }
        return height;
    }

    private double estimateHeight() {
        double borderWidth = this.snapVerticalInsets();
        JFXListView listview = (JFXListView)this.getSkinnable();
        double gap = listview.isExpanded() != false ? ((JFXListView)this.getSkinnable()).getVerticalGap() * (double)((ListView)this.getSkinnable()).getItems().size() : 0.0;
        double cellsHeight = 0.0;
        for (int i = 0; i < this.flow.getCellCount(); ++i) {
            ListCell cell = (ListCell)this.flow.getCell(i);
            cellsHeight += cell.getHeight();
        }
        return cellsHeight + gap + borderWidth;
    }

    private double snapVerticalInsets() {
        return ((ListView)this.getSkinnable()).snappedBottomInset() + ((ListView)this.getSkinnable()).snappedTopInset();
    }
}

