import type { StateCreator } from 'zustand'
import type {
  RunFile,
} from '@/app/components/workflow/types'

export type FormSliceShape = {
  inputs: Record<string, string | number | boolean>
  setInputs: (inputs: Record<string, string | number | boolean>) => void
  files: RunFile[]
  setFiles: (files: RunFile[]) => void
}

export const createFormSlice: StateCreator<FormSliceShape> = set => ({
  inputs: {},
  setInputs: inputs => set(() => ({ inputs })),
  files: [],
  setFiles: files => set(() => ({ files })),
})
