package mill.scalajslib

import mill.api.Discover
import mill.scalajslib.api.*
import mill.testkit.UnitTester
import mill.testkit.TestRootModule
import utest.*

object FullOptESModuleTests extends TestSuite {

  object FullOptESModuleModule extends TestRootModule {

    object fullOptESModuleModule extends ScalaJSModule {
      override def scalaVersion = "2.13.16"
      override def scalaJSVersion = "1.20.2"
      override def moduleKind = ModuleKind.ESModule
    }

    override lazy val millDiscover = {
      import mill.util.TokenReaders.given
      Discover[this.type]
    }
  }

  val millSourcePath = os.Path(sys.env("MILL_TEST_RESOURCE_DIR")) / "hello-js-world"

  val tests: Tests = Tests {
    test("fullOpt with ESModule moduleKind") - UnitTester(
      FullOptESModuleModule,
      millSourcePath
    ).scoped { eval =>
      val result = eval(FullOptESModuleModule.fullOptESModuleModule.fullLinkJS)
      assert(result.isRight)
    }
  }
}
